/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.algorithms;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class GraphUtilities {
    private GraphUtilities() {
    }

    public static Graph createGrid2(GraphSystem graphSystem, int n, int n2) {
        Graph graph = graphSystem.createGraph();
        Node node = null;
        for (int i = 1; i <= n2; ++i) {
            for (int j = 1; j <= n; ++j) {
                Node node2;
                try {
                    node = graph.createNode(Integer.toString(i) + "/" + Integer.toString(j));
                }
                catch (GraphException graphException) {
                    System.out.println(graphException);
                }
                if (i > 1) {
                    node2 = (Node)graph.getElement(Integer.toString(i - 1) + "/" + Integer.toString(j));
                    graph.createEdge(node2, node);
                }
                if (j <= 1) continue;
                node2 = (Node)graph.getElement(Integer.toString(i) + "/" + Integer.toString(j - 1));
                graph.createEdge(node2, node);
            }
        }
        return graph;
    }

    public static Graph createDiscreteGraph(GraphSystem graphSystem, int n) {
        Graph graph = graphSystem.createGraph();
        for (int i = 1; i <= n; ++i) {
            Node node = graph.createNode();
        }
        return graph;
    }

    public static Graph createCompleteGraph(GraphSystem graphSystem, int n) {
        Graph graph = graphSystem.createGraph();
        for (int i = 1; i <= n; ++i) {
            Node node = graph.createNode();
            node.setLabel(Integer.toString(i));
        }
        for (Node node : graph.getNodes()) {
            for (Node node2 : graph.getNodes()) {
                if (node == node2) continue;
                graph.createEdge(node, node2);
            }
        }
        return graph;
    }

    public static Set getConnectedComponents(Graph graph) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        hashSet2.addAll(graph.getNodes());
        while (!hashSet2.isEmpty()) {
            Node node = (Node)hashSet2.iterator().next();
            HashSet<Node> hashSet3 = new HashSet<Node>();
            hashSet.add(hashSet3);
            hashSet3.add(node);
            hashSet2.remove(node);
            HashSet hashSet4 = new HashSet();
            hashSet4.addAll(graph.getEdges(node));
            while (!hashSet4.isEmpty()) {
                Edge edge = (Edge)hashSet4.iterator().next();
                if (hashSet2.remove(edge.getSource())) {
                    hashSet3.add(edge.getSource());
                    hashSet4.addAll(graph.getEdges(edge.getSource()));
                }
                if (hashSet2.remove(edge.getTarget())) {
                    hashSet3.add(edge.getTarget());
                    hashSet4.addAll(graph.getEdges(edge.getTarget()));
                }
                hashSet4.remove(edge);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Graph createSubTree(Graph graph, Node node, int n, int n2, int n3, long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (n == n2) {
            return null;
        }
        for (int i = 1; i <= n3; ++i) {
            Node node2 = graph.createNode();
            Graph graph2 = graph;
            synchronized (graph2) {
                graph.createEdge(node, node2);
            }
            GraphUtilities.createSubTree(graph, node2, n, n2 + 1, n3, l);
        }
        return graph;
    }

    public static Graph createTree(GraphSystem graphSystem, int n, int n2) {
        Graph graph = graphSystem.createGraph();
        Node node = graph.createNode();
        GraphUtilities.createSubTree(graph, node, n, 0, n2, 0L);
        return graph;
    }

    public static Graph createTreeDelayed(GraphSystem graphSystem, int n, int n2, long l) {
        Graph graph = graphSystem.createGraph();
        CreateTreeThread createTreeThread = new CreateTreeThread(graph, n, n2, l);
        createTreeThread.start();
        return graph;
    }

    public static Graph createRandomGraph(GraphSystem graphSystem, int n, double d, double d2, double d3, double d4, long l) {
        Graph graph = graphSystem.createGraph();
        CreateRandomGraphThread createRandomGraphThread = new CreateRandomGraphThread(graph, n, d, d2, d3, d4, l);
        createRandomGraphThread.start();
        return graph;
    }

    public static boolean isAcyclic(Graph graph) {
        return GraphUtilities.getTopologicalOrdering(graph).size() == graph.getNodes().size();
    }

    public static List getTopologicalOrdering(Graph graph) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Element, Integer> hashMap = new HashMap<Element, Integer>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : graph.getEdges()) {
            Object object2 = (Integer)hashMap.get(object.getTarget());
            if (object2 == null) {
                hashMap.put(object.getTarget(), new Integer(1));
                continue;
            }
            hashMap.put(object.getTarget(), new Integer((Integer)object2 + 1));
        }
        for (Object object : graph.getNodes()) {
            if (hashMap.keySet().contains(object)) continue;
            hashMap.put((Element)object, new Integer(0));
            linkedList.add(object);
        }
        while (!linkedList.isEmpty()) {
            Node node = (Node)linkedList.remove(0);
            for (Object object2 : graph.getEdges(node)) {
                if (!object2.getSource().equals(node)) continue;
                Integer n = (Integer)hashMap.get(object2.getTarget());
                if (n == 1) {
                    linkedList.add(object2.getTarget());
                }
                hashMap.put(object2.getTarget(), new Integer(n - 1));
            }
            arrayList.add(node);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            object = (Node)arrayList.get(i);
            object.setLabel(object.getLabel() + " / " + i);
        }
        return arrayList;
    }

    public static Set makeAcyclic(Graph graph) {
        HashSet<Edge> hashSet = new HashSet<Edge>();
        for (Node node : graph.getNodes()) {
            Collection collection = graph.getEdges(node);
            int n = 0;
            int n2 = 0;
            for (Edge edge : collection) {
                if (edge.getSource().equals(node)) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            for (Edge edge : collection) {
                if ((n <= n2 || !edge.getSource().equals(node)) && (n > n2 || !edge.getTarget().equals(node)) || hashSet.contains(edge)) continue;
                hashSet.add(edge);
                edge.reverse();
            }
        }
        return hashSet;
    }

    private static class CreateRandomGraphThread
    extends Thread {
        Graph graph;
        Node root;
        int size;
        double addNodeProb;
        double removeNodeProb;
        double addEdgeProb;
        double removeEdgeProb;
        long delay;

        public CreateRandomGraphThread(Graph graph, int n, double d, double d2, double d3, double d4, long l) {
            this.graph = graph;
            this.size = n;
            this.addNodeProb = d;
            this.removeNodeProb = d2;
            this.addEdgeProb = d3;
            this.removeEdgeProb = d4;
            this.delay = l;
            this.root = graph.createNode();
        }

        private Node getRandomNode() {
            Node node2 = null;
            for (Node node2 : this.graph.getNodes()) {
                if (!(Math.random() < 1.0 / (double)this.graph.getNodes().size())) continue;
                return node2;
            }
            return node2;
        }

        private Edge getRandomEdge() {
            Edge edge2 = null;
            for (Edge edge2 : this.graph.getEdges()) {
                if (!(Math.random() < 1.0 / (double)this.graph.getEdges().size())) continue;
                return edge2;
            }
            return edge2;
        }

        @Override
        public void run() {
            while (this.graph.getNodes().size() < this.size) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("==============================================");
                System.out.println(this.graph);
                Node node = this.getRandomNode();
                double d = Math.random();
                if (d < this.addNodeProb) {
                    this.graph.createNode();
                } else if (d < this.addNodeProb + this.addEdgeProb) {
                    Node node2 = this.getRandomNode();
                    this.graph.createEdge(node, node2);
                } else if (d < this.addNodeProb + this.addEdgeProb + this.removeNodeProb) {
                    this.graph.removeElement(node);
                } else if (d < this.addNodeProb + this.addEdgeProb + this.removeNodeProb + this.removeEdgeProb) {
                    this.graph.removeElement(this.getRandomEdge());
                }
                System.out.println(this.graph);
            }
        }
    }

    private static class CreateTreeThread
    extends Thread {
        Graph graph;
        Node root;
        int generations;
        int branchFactor;
        long delay;

        public CreateTreeThread(Graph graph, int n, int n2, long l) {
            this.graph = graph;
            this.generations = n;
            this.branchFactor = n2;
            this.delay = l;
            this.root = graph.createNode();
        }

        @Override
        public void run() {
            GraphUtilities.createSubTree(this.graph, this.root, this.generations, 0, this.branchFactor, this.delay);
        }
    }
}

