/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.algorithms;

import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.algorithms.GraphWalkerListener;
import javax.swing.event.EventListenerList;

public abstract class GraphWalker {
    private EventListenerList listenerList = new EventListenerList();
    private Graph graph;

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void addListener(GraphWalkerListener graphWalkerListener) {
        this.listenerList.add(GraphWalkerListener.class, graphWalkerListener);
    }

    public void removeListener(GraphWalkerListener graphWalkerListener) {
        this.listenerList.remove(GraphWalkerListener.class, graphWalkerListener);
    }

    public void visitElement(Element element) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GraphWalkerListener.class) continue;
            ((GraphWalkerListener)objectArray[i + 1]).visitElement(element);
        }
    }

    public abstract void walk();
}

