/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.algorithms;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.algorithms.GraphUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LayerAssignment {
    public static final String LAYER = "layer";
    private boolean createDummy;
    private Class layerImpl;
    private Graph graph;

    public void setLayerClass(Class clazz) {
        if (clazz.isAssignableFrom(Layer.class)) {
            this.layerImpl = clazz;
        }
    }

    public void setCreateDummy(boolean bl) {
        this.createDummy = bl;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void assignLayers(Set set, Set hashSet) {
        AttributeManager attributeManager = this.graph.getAttributeManager();
        List list = GraphUtilities.getTopologicalOrdering(this.graph);
        if (list.size() != this.graph.getNodes().size()) {
            GraphUtilities.makeAcyclic(this.graph);
            list = GraphUtilities.getTopologicalOrdering(this.graph);
        }
        for (Iterator iterator : list) {
            long l = 0L;
            for (Edge edge : this.graph.getEdges((Node)((Object)iterator))) {
                if (!edge.getTarget().equals(iterator)) continue;
                l = Math.max(l, ((Layer)attributeManager.getAttribute(LAYER, edge.getSource())).getLayer());
            }
            attributeManager.setAttribute(LAYER, (Element)((Object)iterator), this.createLayer(l + 1L));
            iterator.setLabel(iterator.getLabel() + " layer = " + (l + 1L));
        }
        if (this.createDummy) {
            Iterator iterator;
            if (hashSet == null) {
                hashSet = new HashSet<Edge>();
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.graph.getEdges());
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                long l = ((Layer)attributeManager.getAttribute(LAYER, edge.getSource())).getLayer();
                long l2 = ((Layer)attributeManager.getAttribute(LAYER, edge.getTarget())).getLayer();
                if (l2 <= l + 1L) continue;
                hashSet.add(edge);
                Node node = edge.getSource();
                for (long i = l + 1L; i < l2; ++i) {
                    Node node2 = this.graph.createNode();
                    attributeManager.setAttribute(LAYER, node2, this.createLayer(i));
                    this.graph.createEdge(node, node2);
                    node = node2;
                    if (set == null) continue;
                    set.add(node2);
                }
                this.graph.createEdge(node, edge.getTarget());
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.graph.removeElement((Edge)iterator.next());
            }
        }
    }

    private Layer createLayer(long l) {
        Layer layer;
        try {
            layer = (Layer)this.layerImpl.newInstance();
        }
        catch (Exception exception) {
            layer = new LayerImpl();
        }
        layer.setLayer(l);
        return layer;
    }

    private class LayerImpl
    implements Layer {
        private long layer;

        private LayerImpl() {
        }

        @Override
        public void setLayer(long l) {
            this.layer = l;
        }

        @Override
        public long getLayer() {
            return this.layer;
        }
    }

    public static interface Layer {
        public long getLayer();

        public void setLayer(long var1);
    }
}

