/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.io;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.io.GraphWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractGraphWriter
implements GraphWriter {
    protected Writer writer;
    protected Graph graph;

    public AbstractGraphWriter(Writer writer) throws IOException {
        this.setWriter(writer);
    }

    public AbstractGraphWriter(String string) throws IOException {
        this.setWriter(new FileWriter(new File(string)));
    }

    public AbstractGraphWriter(File file) throws IOException {
        this.setWriter(new FileWriter(file));
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public abstract void writeHeader() throws IOException;

    public abstract void writeGroup(Group var1) throws IOException;

    public abstract void writeNode(Node var1) throws IOException;

    public abstract void writeEdge(Edge var1) throws IOException;

    public abstract void writeFooter() throws IOException;

    @Override
    public void write(Graph graph) throws IOException {
        this.graph = graph;
        this.writeHeader();
        this.writer.write("  <!--Group section-->\n");
        for (Element element : graph.getGroups()) {
            this.writeGroup((Group)element);
        }
        this.writer.write("  <!--Node section-->\n");
        for (Element element : graph.getNodes()) {
            this.writeNode((Node)element);
        }
        this.writer.write("  <!--Edge section-->\n");
        for (Element element : graph.getEdges()) {
            this.writeEdge((Edge)element);
        }
        this.writeFooter();
    }
}

