/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.io;

import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.io.ContentHandler;
import hypergraph.graphApi.io.SAXReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GXLContentHandler
extends DefaultHandler
implements ContentHandler {
    private SAXReader reader;
    private Graph graph;
    private Element currentElement;
    private StringBuffer currentText;

    @Override
    public void setReader(SAXReader sAXReader) {
        this.reader = sAXReader;
    }

    @Override
    public SAXReader getReader() {
        return this.reader;
    }

    @Override
    public void endDocument() throws SAXException {
        this.reader.setGraph(this.graph);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("graph")) {
            this.graph = this.getReader().getGraphSystem().createGraph();
            return;
        }
        if (string3.equals("node")) {
            String string4 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("id")) continue;
                string4 = attributes.getValue(i);
            }
            try {
                this.currentElement = this.graph.createNode(string4);
            }
            catch (GraphException graphException) {
                graphException.printStackTrace();
            }
            return;
        }
        if (string3.equals("edge")) {
            String string5 = null;
            Node node = null;
            Node node2 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string6;
                if (attributes.getQName(i).equals("id")) {
                    string5 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getQName(i).equals("from")) {
                    string6 = attributes.getValue(i);
                    node = (Node)this.graph.getElement(string6);
                    if (node != null) continue;
                    try {
                        node = this.graph.createNode(string6);
                    }
                    catch (GraphException graphException) {
                        graphException.printStackTrace();
                    }
                    continue;
                }
                if (!attributes.getQName(i).equals("to") || (node2 = (Node)this.graph.getElement(string6 = attributes.getValue(i))) != null) continue;
                try {
                    node2 = this.graph.createNode(string6);
                    continue;
                }
                catch (GraphException graphException) {
                    graphException.printStackTrace();
                }
            }
            try {
                this.currentElement = this.graph.createEdge(string5, node, node2);
            }
            catch (GraphException graphException) {
                graphException.printStackTrace();
            }
            return;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.currentText == null) {
            this.currentText = new StringBuffer();
        }
        this.currentText.append(cArray, n, n2);
    }
}

