/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.io;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.io.AbstractGraphWriter;
import java.io.File;
import java.io.IOException;

public class GXLWriter
extends AbstractGraphWriter {
    public GXLWriter(String string) throws IOException {
        super(string);
    }

    public GXLWriter(File file) throws IOException {
        super(file);
    }

    @Override
    public void writeHeader() throws IOException {
        this.writer.write("<?xml version=\"1.0\"?>\n");
        this.writer.write("<!DOCTYPE GXL SYSTEM \"GXL.dtd\">\n");
        this.writer.write("<!--This file has been automatically created by HyperGraph.-->\n");
        this.writer.write("<gxl>\n");
        this.writer.write("  <graph id=\"" + this.graph.getName() + "\">\n");
    }

    @Override
    public void writeGroup(Group group) throws IOException {
        this.writer.write("    <group name=\"" + group.getName() + "\" ");
        if (group.getGroup() != null) {
            this.writer.write("group=\"" + group.getGroup().getName() + "\" ");
        }
        this.writer.write(">\n");
        this.writer.write("    </group>\n");
    }

    @Override
    public void writeNode(Node node) throws IOException {
        this.writer.write("    <node id=\"" + node.getName() + "\" ");
        if (node.getGroup() != null) {
            this.writer.write("group=\"" + node.getGroup().getName() + "\" ");
        }
        this.writer.write(">\n");
        this.writer.write("      <attr name=\"label\"><string>" + node.getLabel() + "</string></attr>\n");
        this.writer.write("    </node>\n");
    }

    @Override
    public void writeEdge(Edge edge) throws IOException {
        this.writer.write("    <edge id=\"" + edge.getName() + "\" " + "from=\"" + edge.getSource().getName() + "\" " + "to=\"" + edge.getTarget().getName() + "\" ");
        if (edge.getGroup() != null) {
            this.writer.write("group=\"" + edge.getGroup().getName() + "\" ");
        }
        this.writer.write(">\n");
        if (edge.getLabel() != null) {
            this.writer.write("      <label>" + edge.getLabel() + "</label>\n");
        }
        this.writer.write("    </edge>\n");
    }

    @Override
    public void writeFooter() throws IOException {
        this.writer.write("  </graph>\n");
        this.writer.write("</gxl>\n");
        this.writer.close();
    }
}

