/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.io;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.io.AbstractGraphWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class GraphXMLWriter
extends AbstractGraphWriter {
    public GraphXMLWriter(String string) throws IOException {
        super(string);
    }

    public GraphXMLWriter(File file) throws IOException {
        super(file);
    }

    public GraphXMLWriter(Writer writer) throws IOException {
        super(writer);
    }

    @Override
    public void writeHeader() throws IOException {
        this.writer.write("<?xml version=\"1.0\"?>\n");
        this.writer.write("<!DOCTYPE GraphXML SYSTEM \"GraphXML.dtd\">\n");
        this.writer.write("<!--This file has been automatically created by HyperGraph.-->\n");
        this.writer.write("<GraphXML>\n");
        this.writer.write("  <graph>\n");
    }

    @Override
    public void writeGroup(Group group) throws IOException {
    }

    @Override
    public void writeNode(Node node) throws IOException {
        this.writer.write("    <node name=\"" + node.getName() + "\" ");
        if (node.getGroup() != null) {
            this.writer.write("class=\"" + node.getGroup().getName() + "\" ");
        }
        this.writer.write(">\n");
        this.writer.write("      <label>" + node.getLabel() + "</label>\n");
        this.writer.write("    </node>\n");
    }

    @Override
    public void writeEdge(Edge edge) throws IOException {
        this.writer.write("    <edge name=\"" + edge.getName() + "\" " + "source=\"" + edge.getSource().getName() + "\" " + "target=\"" + edge.getTarget().getName() + "\" ");
        if (edge.getGroup() != null) {
            this.writer.write("class=\"" + edge.getGroup().getName() + "\" ");
        }
        this.writer.write(">\n");
        if (edge.getLabel() != null) {
            this.writer.write("      <label>" + edge.getLabel() + "</label>\n");
        }
        this.writer.write("    </edge>\n");
    }

    @Override
    public void writeFooter() throws IOException {
        this.writer.write("  </graph>\n");
        this.writer.write("</GraphXML>\n");
        this.writer.close();
    }
}

