/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.hyperbolic.ModelPoint;

public class Complex
implements ModelPoint {
    double real;
    double imag;
    private final double epsilon = 1.0E-10;

    public static Complex getRotation(double d) {
        return new Complex(Math.cos(d), Math.sin(d));
    }

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double[] dArray) {
        if (dArray.length > 0) {
            this.real = dArray[0];
        }
        if (dArray.length > 1) {
            this.imag = dArray[1];
        }
    }

    public Complex(Complex complex) {
        this(complex.real, complex.imag);
    }

    public Complex(double d) {
        this.real = d;
        this.imag = 0.0;
    }

    public Complex(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    @Override
    public void setTo(ModelPoint modelPoint) {
        if (modelPoint == null) {
            return;
        }
        this.real = ((Complex)modelPoint).real;
        this.imag = ((Complex)modelPoint).imag;
    }

    public boolean equals(Object object) {
        return Math.abs(((Complex)object).real - this.real) < 1.0E-10 && Math.abs(((Complex)object).imag - this.imag) < 1.0E-10;
    }

    public int hashCode() {
        return new Double(this.real).hashCode() + new Double(this.imag).hashCode();
    }

    public double[] toArray() {
        double[] dArray = new double[]{this.real, this.imag};
        return dArray;
    }

    public void setReal(double d) {
        if (d == Double.NaN) {
            throw new IllegalArgumentException();
        }
        this.real = d;
    }

    public double getReal() {
        return this.real;
    }

    public void setImag(double d) {
        if (d == Double.NaN) {
            throw new IllegalArgumentException();
        }
        this.imag = d;
    }

    public double getImag() {
        return this.imag;
    }

    public double getRad() {
        double d = Math.acos(this.real / this.norm());
        if (this.imag < 0.0) {
            d = -d;
        }
        return d;
    }

    public void add(double d) {
        this.real += d;
    }

    public void add(Complex complex) {
        this.real += complex.real;
        this.imag += complex.imag;
    }

    public void subtract(Complex complex) {
        this.real -= complex.real;
        this.imag -= complex.imag;
    }

    public void multiply(double d) {
        this.real *= d;
        this.imag *= d;
    }

    public void multiply(Complex complex) {
        double d = this.real * complex.real - this.imag * complex.imag;
        this.imag = this.real * complex.imag + this.imag * complex.real;
        this.real = d;
    }

    public void reciprocal() {
        this.imag = -this.imag;
        double d = this.norm2();
        this.divide(d);
    }

    public Complex getReciprocal() {
        Complex complex = new Complex(this);
        complex.reciprocal();
        return complex;
    }

    public void divide(double d) {
        this.real /= d;
        this.imag /= d;
    }

    public void divide(Complex complex) {
        complex.conjugate();
        this.multiply(complex);
        complex.conjugate();
        this.divide(complex.norm2());
    }

    public void conjugate() {
        this.imag = -this.imag;
    }

    public void normalize() {
        this.multiply(1.0 / this.norm());
    }

    public double dist(Complex complex) {
        if (complex == null) {
            return Double.NaN;
        }
        return Math.sqrt((this.real - complex.real) * (this.real - complex.real) + (this.imag - complex.imag) * (this.imag - complex.imag));
    }

    public double dist2(Complex complex) {
        if (complex == null) {
            return Double.NaN;
        }
        return (this.real - complex.real) * (this.real - complex.real) + (this.imag - complex.imag) * (this.imag - complex.imag);
    }

    public double norm2() {
        return this.real * this.real + this.imag * this.imag;
    }

    public double norm() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    double scalarProduct(Complex complex) {
        return this.real * complex.real + this.imag * complex.imag;
    }

    @Override
    public Object clone() {
        return new Complex(this);
    }

    public String toString() {
        return this.real + "+i*" + this.imag;
    }
}

