/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.hyperbolic.Complex;
import hypergraph.hyperbolic.Isometry;
import hypergraph.hyperbolic.ModelPanel;
import hypergraph.hyperbolic.ModelPanelUI;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.Projector;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import javax.swing.JComponent;

public class HalfPlaneProjector
implements Projector {
    private Hashtable rendererClassNames;

    @Override
    public Point[] getLineSegments(ModelPoint modelPoint, ModelPoint modelPoint2, JComponent jComponent) {
        ModelPanelUI modelPanelUI = ((ModelPanel)jComponent).getUI();
        modelPanelUI.applyViewMatrix(modelPoint, jComponent);
        modelPanelUI.applyViewMatrix(modelPoint2, jComponent);
        if (modelPanelUI.isDraft() || ((Complex)modelPoint).dist((Complex)modelPoint2) < 0.01) {
            Point[] pointArray = new Point[]{modelPanelUI.map(modelPoint, jComponent), modelPanelUI.map(modelPoint2, jComponent)};
            return pointArray;
        }
        Complex complex = (Complex)modelPoint;
        int n = 6;
        if (((Complex)modelPoint).dist((Complex)modelPoint2) > 1.0) {
            n = 30;
        }
        Point[] pointArray = new Point[n + 1];
        pointArray[0] = modelPanelUI.map(complex, jComponent);
        Isometry isometry = ((ModelPanel)jComponent).getModel().getTranslation(modelPoint, modelPoint2, 1.0 / (double)n);
        for (int i = 1; i < n + 1; ++i) {
            isometry.apply(complex);
            pointArray[i] = modelPanelUI.map(complex, jComponent);
        }
        return pointArray;
    }

    @Override
    public Point map(ModelPoint modelPoint, JComponent jComponent) {
        Complex complex = new Complex(1.0, 0.0);
        complex.add((Complex)modelPoint);
        Complex complex2 = new Complex(-1.0, 0.0);
        complex2.add((Complex)modelPoint);
        complex2.multiply(-1.0);
        complex.divide(complex2);
        return new Point((int)Math.round(complex.getReal() * 0.5 * (double)jComponent.getWidth()), (int)Math.round(complex.getImag() * 0.5 * (double)jComponent.getHeight() + (double)jComponent.getHeight() * 0.5));
    }

    @Override
    public ModelPoint inversMap(Point point, JComponent jComponent) {
        Complex complex = new Complex(point.getX() * 2.0 / (double)jComponent.getWidth(), (point.getY() - (double)jComponent.getHeight() * 0.5) * 2.0 / (double)jComponent.getHeight());
        if (complex.getReal() <= 0.0) {
            return null;
        }
        Complex complex2 = (Complex)complex.clone();
        complex.add(-1.0);
        complex2.add(1.0);
        complex.divide(complex2);
        return complex;
    }

    @Override
    public Point2D getScale(ModelPoint modelPoint, JComponent jComponent) {
        double d = 1.0 - ((Complex)modelPoint).norm2();
        return new Point2D.Double(d, d);
    }
}

