/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.test;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.GraphSystemFactory;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.algorithms.GraphUtilities;
import hypergraph.graphApi.algorithms.LayerAssignment;
import hypergraph.graphApi.io.ContentHandlerFactory;
import hypergraph.graphApi.io.GXLWriter;
import hypergraph.graphApi.io.GraphMLWriter;
import hypergraph.graphApi.io.GraphXMLWriter;
import hypergraph.graphApi.io.SAXReader;
import hypergraph.visualnet.GenericMDSLayout;
import hypergraph.visualnet.GraphPanel;
import hypergraph.visualnet.GraphSelectionEvent;
import hypergraph.visualnet.GraphSelectionListener;
import hypergraph.visualnet.GraphSelectionModel;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class NetApplication
implements GraphSelectionListener {
    static Graph graph;

    @Override
    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        GraphSelectionModel graphSelectionModel = (GraphSelectionModel)graphSelectionEvent.getSource();
        Iterator iterator = graphSelectionModel.getSelectionElementIterator();
        if (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            AttributeManager attributeManager = graph.getAttributeManager();
            String string = (String)attributeManager.getAttribute("xlink:href", node);
        }
    }

    public static void main(String[] stringArray) {
        NetApplication netApplication = new NetApplication();
        netApplication.go(stringArray);
    }

    public void go(String[] stringArray) {
        Object object;
        Object object2;
        JFrame jFrame = new JFrame();
        UIManager.put("ModelPanelUI", "hypergraph.hyperbolic.ModelPanelUI");
        GraphSystem graphSystem = null;
        try {
            graphSystem = GraphSystemFactory.createGraphSystem("hypergraph.graph.GraphSystemImpl", null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(8);
        }
        graph = null;
        try {
            object2 = new URL(stringArray[0]);
            object = new SAXReader(graphSystem, (URL)object2);
            ((SAXReader)object).setContentHandlerFactory(new ContentHandlerFactory());
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
            exception.printStackTrace(System.out);
        }
        if (graph == null) {
            graph = GraphUtilities.createTree(graphSystem, 5, 2);
        }
        try {
            new GraphXMLWriter("test-GraphXML.xml").write(graph);
            new GraphMLWriter("test-graphml.xml").write(graph);
            new GXLWriter("test-gxl.xml").write(graph);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = new LayerAssignment();
        ((LayerAssignment)object2).setGraph(graph);
        ((LayerAssignment)object2).setCreateDummy(false);
        object = new float[]{15.0f, 2.0f, 2.0f, 2.0f, 2.0f, 10.0f};
        GraphPanel graphPanel = new GraphPanel(graph);
        graph.getAttributeManager().setAttribute("edge.stroke", graph, object);
        graphPanel.getPropertyManager().setProperty("visualnet.GenericMDSLayout.repulsingForce", new Double(0.05));
        graphPanel.getPropertyManager().setProperty("visualnet.GenericMDSLayout.repulsingForceCutOff", new Double(5.0));
        graphPanel.getPropertyManager().setProperty("visualnet.GenericMDSLayout.connectedDisparity", new Double(0.3));
        graphPanel.setGraphLayout(new GenericMDSLayout(null, graphPanel.getModel(), graph, graphPanel.getPropertyManager()));
        graphPanel.getSelectionModel().addSelectionEventListener(this);
        jFrame.getContentPane().add(graphPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }
}

