/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Node;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.visualnet.GraphLayoutEvent;
import hypergraph.visualnet.GraphLayoutListener;
import hypergraph.visualnet.GraphLayoutModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class DefaultGraphLayoutModel
implements GraphLayoutModel {
    Map nodePositions;
    EventListenerList listenerList;
    private boolean valid;

    public DefaultGraphLayoutModel() {
        this.clearNodePositions();
        this.listenerList = new EventListenerList();
    }

    @Override
    public void setValid(boolean bl) {
        if (bl != this.valid) {
            this.fireLayoutChanged();
        }
        this.valid = bl;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void addLayoutEventListener(GraphLayoutListener graphLayoutListener) {
        this.listenerList.add(GraphLayoutListener.class, graphLayoutListener);
    }

    @Override
    public void removeLayoutEventListener(GraphLayoutListener graphLayoutListener) {
        this.listenerList.remove(GraphLayoutListener.class, graphLayoutListener);
    }

    @Override
    public void fireLayoutChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GraphLayoutListener.class) continue;
            ((GraphLayoutListener)objectArray[i + 1]).valueChanged(new GraphLayoutEvent(this));
        }
    }

    @Override
    public void clearNodePositions() {
        this.nodePositions = new HashMap();
    }

    @Override
    public void setNodePosition(Node node, ModelPoint modelPoint) {
        this.nodePositions.put(node, modelPoint);
        this.fireLayoutChanged();
    }

    @Override
    public ModelPoint getNodePosition(Node node) {
        return (ModelPoint)this.nodePositions.get(node);
    }
}

