/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.visualnet.GraphSelectionEvent;
import hypergraph.visualnet.GraphSelectionListener;
import hypergraph.visualnet.GraphSelectionModel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.EventListenerList;

public class DefaultGraphSelectionModel
implements GraphSelectionModel {
    Graph graph;
    Set selectedElements;
    EventListenerList listenerList;

    public DefaultGraphSelectionModel(Graph graph) {
        this.setGraph(graph);
        this.selectedElements = new HashSet();
        this.listenerList = new EventListenerList();
    }

    void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void addSelectionEventListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.add(GraphSelectionListener.class, graphSelectionListener);
    }

    @Override
    public void removeSelectionEventListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.remove(GraphSelectionListener.class, graphSelectionListener);
    }

    void fireSelectionChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GraphSelectionListener.class) continue;
            ((GraphSelectionListener)objectArray[i + 1]).valueChanged(new GraphSelectionEvent(this));
        }
    }

    @Override
    public void clearSelection() {
        this.selectedElements.clear();
        this.fireSelectionChanged();
    }

    @Override
    public void addSelectionElement(Element element) {
        this.selectedElements.add(element);
        this.fireSelectionChanged();
    }

    @Override
    public void removeSelectionElement(Element element) {
        this.selectedElements.remove(element);
        this.fireSelectionChanged();
    }

    @Override
    public boolean isElementSelected(Element element) {
        return this.selectedElements.contains(element);
    }

    @Override
    public Iterator getSelectionElementIterator() {
        return this.selectedElements.iterator();
    }
}

