/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.Node;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.StubRenderer;
import hypergraph.hyperbolic.TextRenderer;
import hypergraph.visualnet.GraphPanel;
import hypergraph.visualnet.NodeRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DefaultNodeRenderer
extends JComponent
implements NodeRenderer {
    private TextRenderer textRenderer;
    protected GraphPanel graphPanel;
    protected Node node;
    protected Icon icon;

    public void setTextRenderer(TextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public TextRenderer getTextRenderer() {
        if (this.textRenderer == null) {
            this.textRenderer = this.graphPanel.getTextRenderer();
        }
        return this.textRenderer;
    }

    @Override
    public void configure(GraphPanel graphPanel, ModelPoint modelPoint, Node node) {
        this.graphPanel = graphPanel;
        this.node = node;
        if (node == null) {
            this.getTextRenderer().configure(graphPanel, null, null);
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            this.getTextRenderer().configure(graphPanel, modelPoint, node.getLabel());
            Component component = this.getTextRenderer().getComponent();
            Graph graph = graphPanel.getGraph();
            AttributeManager attributeManager = graph.getAttributeManager();
            Color color = (Color)attributeManager.getAttribute("node.color", node);
            if (color != null) {
                this.getTextRenderer().setColor(color);
            }
            Color color2 = (Color)attributeManager.getAttribute("node.bkcolor", node);
            this.getTextRenderer().setBackground(color2);
            this.setBackground(color2);
            if (graphPanel.getSelectionModel().isElementSelected(node)) {
                this.setFont(this.getFont().deriveFont(1));
            }
            if (this.graphPanel.hasExpander(node)) {
                n3 = 10;
            }
            this.icon = (Icon)attributeManager.getAttribute("node.icon", node);
            if (this.icon != null) {
                n2 = this.icon.getIconHeight();
                n = this.icon.getIconWidth();
            }
            this.setSize(n + component.getWidth() + n3, Math.max(n2, component.getHeight()));
            int n4 = this.getWidth() - component.getWidth();
            int n5 = this.getHeight() - component.getHeight();
            this.setLocation(component.getX() - n4 / 2, component.getY() - n5 / 2);
            component.setLocation(this.getX() + n, this.getY() + (this.getHeight() - component.getHeight()) / 2);
            if (graphPanel.getHoverElement() == node) {
                if (this.getBackground() == null) {
                    Color color3 = graphPanel.getBackground();
                    this.setBackground(new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), 224));
                }
                this.setFont(this.getFont().deriveFont(1));
            }
        }
    }

    @Override
    public Font getFont() {
        return this.getTextRenderer().getComponent().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getTextRenderer().getComponent().setFont(font);
    }

    @Override
    public Component getComponent() {
        if (this.getTextRenderer().getComponent() instanceof StubRenderer) {
            return this.getTextRenderer().getComponent();
        }
        return this;
    }

    public void paintExpander(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.lightGray);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawLine(n + 2, n2 + n4 / 2, n + n3 - 2, n2 + n4 / 2);
        if (!this.graphPanel.isExpanded(this.node)) {
            graphics.drawLine(n + n3 / 2, n2 + 2, n + n3 / 2, n2 + n4 - 2);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.graphPanel.hasExpander(this.node)) {
            this.paintExpander(graphics, this.getWidth() - 9, 0, 8, 8);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics, 0, (this.getHeight() - this.icon.getIconHeight()) / 2);
            graphics.translate(this.icon.getIconWidth(), 0);
        }
        this.getTextRenderer().getComponent().paint(graphics);
    }

    public boolean expanderHit(Point point) {
        if (!this.graphPanel.hasExpander(this.node)) {
            return false;
        }
        int n = point.x - this.getX() - this.getWidth();
        int n2 = point.y - this.getY();
        return n >= -10 && n <= 0 && n2 >= 0 && n2 <= 10;
    }
}

