/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.graphApi.GraphListener;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.algorithms.BFSGraphWalker;
import hypergraph.graphApi.algorithms.GraphWalkerListener;
import hypergraph.visualnet.GenericMDSLayout;
import java.util.ArrayList;
import java.util.List;

public class MDSWeight
implements GenericMDSLayout.MDSWeight,
GraphListener {
    private Graph graph;
    private DistanceArray distances;

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
        this.graph.addGraphListener(this);
        this.distances = new DistanceArray(this.graph);
    }

    @Override
    public void elementsAdded(GraphEvent graphEvent) {
        this.distances = new DistanceArray(this.graph);
    }

    @Override
    public void elementsRemoved(GraphEvent graphEvent) {
        this.distances = new DistanceArray(this.graph);
    }

    @Override
    public void structureChanged(GraphEvent graphEvent) {
        this.distances = new DistanceArray(this.graph);
    }

    @Override
    public double getWeight(Node node) {
        return this.distances.getSphereSize(node, 2);
    }

    @Override
    public double getWeight(Node node, Node node2, double d) {
        double d2;
        double d3 = 0.0;
        if (d < 20.0) {
            d3 += 0.5 / d - 0.025;
        }
        if ((d2 = (double)this.distances.getDistance(node, node2)) > 0.0 && d2 < 2.0) {
            d3 += (d - d2 * 0.15) * (d - d2 * 0.15) / d2;
        }
        return d3;
    }

    @Override
    public double getWeightDerivative(Node node, Node node2, double d) {
        double d2;
        double d3 = 0.0;
        if (d < 20.0) {
            d3 += -0.5 / (d * d);
        }
        if ((d2 = (double)this.distances.getDistance(node, node2)) > 0.0 && d2 < 2.0) {
            d3 += (d - d2 * 0.15) / d2;
        }
        return d3;
    }

    public class DistanceArray
    implements GraphWalkerListener {
        private Graph graph;
        private int[][] distances;
        private List spheres;
        private GenericMDSLayout.NodeIndex nodeIndex;
        private int currentNode;
        private BFSGraphWalker gw;
        private int c;
        private int d;

        public DistanceArray(Graph graph) {
            this.graph = graph;
            this.initializeDistances();
        }

        public int getSphereSize(Node node, int n) {
            return ((int[])this.spheres.get(n))[this.nodeIndex.getIndex(node)];
        }

        public int getDistance(Node node, Node node2) {
            return this.distances[this.nodeIndex.getIndex(node)][this.nodeIndex.getIndex(node2)];
        }

        private void initializeDistances() {
            this.nodeIndex = new GenericMDSLayout.NodeIndex(this.graph);
            this.distances = new int[this.nodeIndex.getSize()][this.nodeIndex.getSize()];
            this.spheres = new ArrayList();
            this.gw = new BFSGraphWalker();
            this.gw.setGraph(this.graph);
            this.gw.addListener(this);
            this.currentNode = 0;
            while (this.currentNode < this.nodeIndex.getSize()) {
                Node node = this.nodeIndex.getNode(this.currentNode);
                this.gw.setStartNode(node);
                this.d = 0;
                this.c = 0;
                this.gw.walk();
                this.setSphereSize(this.currentNode, this.d, this.c);
                ++this.currentNode;
            }
        }

        private void setSphereSize(int n, int n2, int n3) {
            int[] nArray;
            if (n2 >= this.spheres.size()) {
                nArray = new int[this.nodeIndex.getSize()];
                this.spheres.add(n2, nArray);
            } else {
                nArray = (int[])this.spheres.get(n2);
            }
            nArray[n] = n3;
        }

        @Override
        public void visitElement(Element element) {
            if (element.getElementType() == 1) {
                int n = this.nodeIndex.getIndex((Node)element);
                this.distances[this.currentNode][n] = this.gw.getIteration();
                this.distances[n][this.currentNode] = this.gw.getIteration();
                if (this.gw.getIteration() != this.d) {
                    this.setSphereSize(this.currentNode, this.d, this.c);
                    this.d = this.gw.getIteration();
                    this.c = 0;
                }
                ++this.c;
            }
        }
    }
}

