/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import java.util.Locale;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;

public class HTMLElementImpl
extends ElementImpl
implements HTMLElement {
    public String getClassName() {
        return this.getAttribute("class");
    }

    public String getDir() {
        return this.getAttribute("dir");
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public String getLang() {
        return this.getAttribute("lang");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    int getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException except) {
            return 0;
        }
    }

    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    public void setDir(String dir) {
        this.setAttribute("dir", dir);
    }

    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public void setLang(String lang) {
        this.setAttribute("lang", lang);
    }

    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    boolean getBinary(String name) {
        return this.getAttributeNode(name) != null;
    }

    void setAttribute(String name, boolean value) {
        if (value) {
            this.setAttribute(name, name);
        } else {
            this.removeAttribute(name);
        }
    }

    public HTMLFormElement getForm() {
        Node parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof HTMLFormElement) {
                return (HTMLFormElement)parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    String capitalize(String value) {
        char[] chars = value.toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toUpperCase(chars[0]);
            int i = 1;
            while (i < chars.length) {
                chars[i] = Character.toLowerCase(chars[i]);
                ++i;
            }
            return String.valueOf(chars);
        }
        return value;
    }

    public String getAttribute(String attrName) {
        return super.getAttribute(attrName.toLowerCase(Locale.ENGLISH));
    }

    String getCapitalized(String name) {
        char[] chars;
        String value = this.getAttribute(name);
        if (value != null && (chars = value.toCharArray()).length > 0) {
            chars[0] = Character.toUpperCase(chars[0]);
            int i = 1;
            while (i < chars.length) {
                chars[i] = Character.toLowerCase(chars[i]);
                ++i;
            }
            return String.valueOf(chars);
        }
        return value;
    }

    HTMLElementImpl(HTMLDocumentImpl owner, String tagName) {
        super(owner, tagName.toUpperCase(Locale.ENGLISH));
    }

    public Attr getAttributeNode(String attrName) {
        return super.getAttributeNode(attrName.toLowerCase(Locale.ENGLISH));
    }

    public final NodeList getElementsByTagName(String tagName) {
        return super.getElementsByTagName(tagName.toUpperCase(Locale.ENGLISH));
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return super.getAttributeNS(namespaceURI, localName);
        }
        return super.getAttribute(localName.toLowerCase(Locale.ENGLISH));
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return super.getAttributeNodeNS(namespaceURI, localName);
        }
        return super.getAttributeNode(localName.toLowerCase(Locale.ENGLISH));
    }

    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return super.getElementsByTagNameNS(namespaceURI, localName.toUpperCase(Locale.ENGLISH));
        }
        return super.getElementsByTagName(localName.toUpperCase(Locale.ENGLISH));
    }
}

