/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;

public class Selector {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;
    protected IdentityConstraint fIDConstraint;

    public String toString() {
        return this.fXPath.toString();
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIdentityConstraint;
    }

    public Selector(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator activator, int initialDepth) {
        return new Matcher(this.fXPath, activator, initialDepth);
    }

    public class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected int fInitialDepth;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public int getInitialDepth() {
            return this.fInitialDepth;
        }

        public IdentityConstraint getIdentityConstraint() {
            return Selector.this.fIdentityConstraint;
        }

        public void startDocumentFragment(SymbolTable symbolTable) throws XNIException {
            super.startDocumentFragment(symbolTable);
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        public void endElement(QName element, XSElementDecl eDecl, String value) {
            super.endElement(element, eDecl, value);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
            }
        }

        public void startElement(QName element, XMLAttributes attributes, XSElementDecl elementDecl) throws XNIException {
            super.startElement(element, attributes, elementDecl);
            ++this.fElementDepth;
            int matched = this.isMatched();
            if (this.fMatchedDepth == -1 && (matched & 1) == 1 || (matched & 5) == 5) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
                int count = Selector.this.fIdentityConstraint.getFieldCount();
                int i = 0;
                while (i < count) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(i);
                    XPathMatcher matcher = this.fFieldActivator.activateField(field, this.fInitialDepth);
                    matcher.startElement(element, attributes, elementDecl);
                    ++i;
                }
            }
        }

        public Matcher(XPath xpath, FieldActivator activator, int initialDepth) {
            super(xpath);
            this.fFieldActivator = activator;
            this.fInitialDepth = initialDepth;
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        private static String normalize(String xpath) {
            StringBuffer modifiedXPath = new StringBuffer(xpath.length() + 5);
            int unionIndex = -1;
            while (true) {
                if (!xpath.trim().startsWith("/") && !xpath.trim().startsWith(".")) {
                    modifiedXPath.append("./");
                }
                if ((unionIndex = xpath.indexOf(124)) == -1) break;
                modifiedXPath.append(xpath.substring(0, unionIndex + 1));
                xpath = xpath.substring(unionIndex + 1, xpath.length());
            }
            modifiedXPath.append(xpath);
            return modifiedXPath.toString();
        }

        public XPath(String xpath, SymbolTable symbolTable, NamespaceContext context) throws XPathException {
            super(XPath.normalize(xpath), symbolTable, context);
            int i = 0;
            while (i < this.fLocationPaths.length) {
                XPath.Axis axis = this.fLocationPaths[i].steps[this.fLocationPaths[i].steps.length - 1].axis;
                if (axis.type == 2) {
                    throw new XPathException("c-selector-xpath");
                }
                ++i;
            }
        }
    }
}

