/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public class XML11Char {
    public static final byte[] XML11CHARS = new byte[65536];
    public static final int MASK_XML11_VALID = 1;
    public static final int MASK_XML11_SPACE = 2;
    public static final int MASK_XML11_NAME_START = 4;
    public static final int MASK_XML11_NAME = 8;
    public static final int MASK_XML11_CONTROL = 16;
    public static final int MASK_XML11_CONTENT = 32;
    public static final int MASK_XML11_NCNAME_START = 64;
    public static final int MASK_XML11_NCNAME = 128;

    static {
        int[] xml11NonWhitespaceRange = new int[]{33, 126, 160, 8231, 8233, 55295, 57344, 65533};
        int[] xml11WhitespaceChars = new int[]{9, 10, 13, 32, 133, 8232};
        int[] xml11ControlCharRange = new int[]{1, 8, 11, 12, 14, 31, 127, 132, 134, 159};
        int[] xml11NameStartCharRange = new int[]{58, 58, 65, 90, 95, 95, 97, 122, 192, 767, 880, 893, 895, 8191, 8204, 8205, 8304, 8591, 11264, 12271, 12289, 55295, 63744, 65533};
        int[] xml11NameCharRange = new int[]{45, 45, 46, 46, 48, 57, 183, 183, 768, 879, 8255, 8256};
        int[] xml11SpecialChars = new int[]{60, 38, 10, 13, 93};
        int i = 0;
        while (i < xml11NonWhitespaceRange.length) {
            int j = xml11NonWhitespaceRange[i];
            while (j <= xml11NonWhitespaceRange[i + 1]) {
                int n = j++;
                XML11CHARS[n] = (byte)(XML11CHARS[n] | 0x21);
            }
            i += 2;
        }
        int i2 = 0;
        while (i2 < xml11WhitespaceChars.length) {
            int n = xml11WhitespaceChars[i2];
            XML11CHARS[n] = (byte)(XML11CHARS[n] | 0x23);
            ++i2;
        }
        int i3 = 0;
        while (i3 < xml11ControlCharRange.length) {
            int j = xml11ControlCharRange[i3];
            while (j <= xml11ControlCharRange[i3 + 1]) {
                int n = j++;
                XML11CHARS[n] = (byte)(XML11CHARS[n] | 0x11);
            }
            i3 += 2;
        }
        int i4 = 0;
        while (i4 < xml11NameStartCharRange.length) {
            int j = xml11NameStartCharRange[i4];
            while (j <= xml11NameStartCharRange[i4 + 1]) {
                int n = j++;
                XML11CHARS[n] = (byte)(XML11CHARS[n] | 0xCC);
            }
            i4 += 2;
        }
        int i5 = 0;
        while (i5 < xml11NameCharRange.length) {
            int j = xml11NameCharRange[i5];
            while (j <= xml11NameCharRange[i5 + 1]) {
                int n = j++;
                XML11CHARS[n] = (byte)(XML11CHARS[n] | 0x88);
            }
            i5 += 2;
        }
        XML11CHARS[58] = (byte)(XML11CHARS[58] & 0xFFFFFF3F);
        int i6 = 0;
        while (i6 < xml11SpecialChars.length) {
            int n = xml11SpecialChars[i6];
            XML11CHARS[n] = (byte)(XML11CHARS[n] & 0xFFFFFFDF);
            ++i6;
        }
    }

    public static boolean isXML11Content(int c) {
        return c < 65536 && (XML11CHARS[c] & 0x20) != 0 || 65536 <= c && c <= 0x10FFFF;
    }

    public static boolean isXML11Invalid(int c) {
        return !XML11Char.isXML11Valid(c);
    }

    public static boolean isXML11NCName(int c) {
        return c < 65536 && (XML11CHARS[c] & 0x80) != 0 || 65536 <= c && c < 983040;
    }

    public static boolean isXML11NCNameStart(int c) {
        return c < 65536 && (XML11CHARS[c] & 0x40) != 0 || 65536 <= c && c < 983040;
    }

    public static boolean isXML11Name(int c) {
        return c < 65536 && (XML11CHARS[c] & 8) != 0 || c >= 65536 && c < 983040;
    }

    public static boolean isXML11NameStart(int c) {
        return c < 65536 && (XML11CHARS[c] & 4) != 0 || 65536 <= c && c < 983040;
    }

    public static boolean isXML11Space(int c) {
        return c < 65536 && (XML11CHARS[c] & 2) != 0;
    }

    public static boolean isXML11Valid(int c) {
        return c < 65536 && (XML11CHARS[c] & 1) != 0 || 65536 <= c && c <= 0x10FFFF;
    }

    public static boolean isXML11ValidLiteral(int c) {
        return c < 65536 && (XML11CHARS[c] & 1) != 0 && (XML11CHARS[c] & 0x10) == 0 || 65536 <= c && c <= 0x10FFFF;
    }

    public static boolean isXML11ValidNCName(String ncName) {
        if (ncName.length() == 0) {
            return false;
        }
        char ch = ncName.charAt(0);
        if (!XML11Char.isXML11NCNameStart(ch)) {
            return false;
        }
        int i = 1;
        while (i < ncName.length()) {
            ch = ncName.charAt(i);
            if (!XML11Char.isXML11NCName(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isXML11ValidName(String name) {
        if (name.length() == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!XML11Char.isXML11NameStart(ch)) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            ch = name.charAt(i);
            if (!XML11Char.isXML11Name(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isXML11ValidNmtoken(String nmtoken) {
        if (nmtoken.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < nmtoken.length()) {
            char ch = nmtoken.charAt(i);
            if (!XML11Char.isXML11Name(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

