/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.ws.datadictionary.client;

import gov.nih.ndar.model.abstraction.dictionary.IDataStructure;
import gov.nih.ndar.model.transfer.dictionary.XmlDataDictionary;
import gov.nih.ndar.model.transfer.dictionary.XmlDataStructure;
import gov.nih.ndar.model.transfer.dictionary.XmlDataStructureListElement;
import gov.nih.ndar.model.transfer.dictionary.XmlDataType;
import gov.nih.ndar.model.transfer.dictionary.XmlDataTypeListElement;
import gov.nih.ndar.ws.datadictionary.client.DataDictionaryClient;
import gov.nih.ndar.ws.datadictionary.client.DataDictionaryClientPorts;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDictionaryProvider {
    protected DataDictionaryClient dataManagerClient;

    public DataDictionaryProvider(String url) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        DataDictionaryClientPorts.setURL(url);
        this.dataManagerClient = new DataDictionaryClientPorts().getDataDictionaryService();
    }

    public List<IDataStructure> getDataStructureList(XmlDataType ... args) {
        ArrayList<XmlDataType> dataTypes = new ArrayList<XmlDataType>();
        for (int i = 0; i < args.length; ++i) {
            dataTypes.add(args[i]);
        }
        return this.getDataStructureList(dataTypes);
    }

    public List<IDataStructure> getDataStructureList(List<XmlDataType> dataTypes) {
        XmlDataTypeListElement dtElement = new XmlDataTypeListElement();
        dtElement.getDataType().addAll(dataTypes);
        return this.dataManagerClient.getDataStructureList(dtElement).getDataStructure();
    }

    public List<IDataStructure> getPublicDataStructureList(XmlDataType ... args) {
        ArrayList<XmlDataType> dataTypes = new ArrayList<XmlDataType>();
        for (int i = 0; i < args.length; ++i) {
            dataTypes.add(args[i]);
        }
        return this.getPublicDataStructureList(dataTypes);
    }

    public List<IDataStructure> getPublicDataStructureList(List<XmlDataType> dataTypes) {
        XmlDataTypeListElement dtElement = new XmlDataTypeListElement();
        dtElement.getDataType().addAll(dataTypes);
        return this.dataManagerClient.getPublicDataStructureList(dtElement).getDataStructure();
    }

    public XmlDataDictionary getDataDictionary(String ... shortnames) {
        ArrayList<IDataStructure> dsList = new ArrayList<IDataStructure>();
        for (int i = 0; i < shortnames.length; ++i) {
            XmlDataStructure ds = new XmlDataStructure();
            ds.setShortName(shortnames[i]);
            dsList.add((IDataStructure)ds);
        }
        return this.getDataDictionary(dsList);
    }

    public XmlDataDictionary getDataDictionary(List<IDataStructure> dataStructures) {
        XmlDataStructureListElement dsList = new XmlDataStructureListElement();
        dsList.getDataStructure().addAll(dataStructures);
        return this.dataManagerClient.getDataDictionary(dsList).getDataDictionary();
    }
}

