/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiDecoderFactory;
import com.sun.jimi.core.JimiEncoderFactory;
import com.sun.jimi.core.JimiExtension;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.Vector;

public class JimiControl {
    protected static Hashtable mimeToDecoderMap = new Hashtable();
    protected static Hashtable mimeToEncoderMap = new Hashtable();
    protected static Hashtable fileExtensionToDecoderMap = new Hashtable();
    protected static Hashtable fileExtensionToEncoderMap = new Hashtable();
    protected static Vector decoderFactories = new Vector();
    protected static Vector encoderFactories = new Vector();
    protected static Vector extensions = new Vector();
    protected static boolean extensionsAllowed = true;

    protected static void addDecoder(JimiDecoderFactory jimiDecoderFactory) {
        Object object;
        decoderFactories.addElement(jimiDecoderFactory);
        String[] stringArray = jimiDecoderFactory.getMimeTypes();
        int n = 0;
        while (n < stringArray.length) {
            mimeToDecoderMap.put(stringArray[n], jimiDecoderFactory);
            if (stringArray[n].indexOf(47) > 0) {
                object = String.valueOf(stringArray[n].substring(0, stringArray[n].indexOf(47) + 1)) + "x-" + stringArray[n].substring(stringArray[n].indexOf(47) + 1);
                mimeToDecoderMap.put(object, jimiDecoderFactory);
            }
            ++n;
        }
        object = jimiDecoderFactory.getFilenameExtensions();
        int n2 = 0;
        while (n2 < ((String[])object).length) {
            fileExtensionToDecoderMap.put(object[n2], jimiDecoderFactory);
            ++n2;
        }
    }

    protected static void addEncoder(JimiEncoderFactory jimiEncoderFactory) {
        Object object;
        encoderFactories.addElement(jimiEncoderFactory);
        String[] stringArray = jimiEncoderFactory.getMimeTypes();
        int n = 0;
        while (n < stringArray.length) {
            mimeToEncoderMap.put(stringArray[n], jimiEncoderFactory);
            if (stringArray[n].indexOf(47) > 0) {
                object = String.valueOf(stringArray[n].substring(0, stringArray[n].indexOf(47) + 1)) + "x-" + stringArray[n].substring(stringArray[n].indexOf(47) + 1);
                mimeToEncoderMap.put(object, jimiEncoderFactory);
            }
            ++n;
        }
        object = jimiEncoderFactory.getFilenameExtensions();
        int n2 = 0;
        while (n2 < ((String[])object).length) {
            fileExtensionToEncoderMap.put(object[n2], jimiEncoderFactory);
            ++n2;
        }
    }

    public static synchronized void addExtension(JimiExtension jimiExtension) {
        if (!extensionsAllowed) {
            throw new RuntimeException("This JIMI license does not permit extensions.");
        }
        extensions.addElement(jimiExtension);
        JimiDecoderFactory[] jimiDecoderFactoryArray = jimiExtension.getDecoders();
        int n = 0;
        while (n < jimiDecoderFactoryArray.length) {
            JimiControl.addDecoder(jimiDecoderFactoryArray[n]);
            ++n;
        }
        JimiEncoderFactory[] jimiEncoderFactoryArray = jimiExtension.getEncoders();
        int n2 = 0;
        while (n2 < jimiEncoderFactoryArray.length) {
            JimiControl.addEncoder(jimiEncoderFactoryArray[n2]);
            ++n2;
        }
    }

    protected static void disableExtensions() {
        extensionsAllowed = false;
    }

    protected static JimiDecoderFactory getDecoderByFileExtension(String string) {
        String string2 = string;
        if (string2.lastIndexOf(".") != -1) {
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        return (JimiDecoderFactory)fileExtensionToDecoderMap.get(string2.toLowerCase());
    }

    protected static JimiDecoderFactory getDecoderByType(String string) {
        return (JimiDecoderFactory)mimeToDecoderMap.get(string);
    }

    protected static synchronized JimiDecoderFactory getDecoderForInputStream(PushbackInputStream pushbackInputStream) {
        byte[] byArray = new byte[16];
        try {
            DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);
            dataInputStream.readFully(byArray);
            pushbackInputStream.unread(byArray);
            int n = decoderFactories.size();
            int n2 = 0;
            while (n2 < n) {
                JimiDecoderFactory jimiDecoderFactory = (JimiDecoderFactory)decoderFactories.elementAt(n2);
                byte[][] byArray2 = jimiDecoderFactory.getFormatSignatures();
                if (byArray2 != null) {
                    int n3 = 0;
                    while (n3 < byArray2.length) {
                        int n4 = Math.min(byArray2[n3].length, byArray.length);
                        int n5 = 0;
                        if (n5 < n4) {
                            if (byArray2[n3][n5] == byArray[n5]) {
                                return jimiDecoderFactory;
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static JimiEncoderFactory getEncoderByFileExtension(String string) {
        String string2 = string;
        if (string2.lastIndexOf(".") != -1) {
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        return (JimiEncoderFactory)fileExtensionToEncoderMap.get(string2.toLowerCase());
    }

    protected static JimiEncoderFactory getEncoderByType(String string) {
        return (JimiEncoderFactory)mimeToEncoderMap.get(string);
    }
}

