/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.DataSynthesizer;
import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.Random;
import java.util.logging.Logger;
import numerics.MTRandom;
import tools.CL_Initializer;

public class AddNoise
extends Executable {
    private static final Logger logger = Logger.getLogger("apps.AddNoise");
    private int voxels;
    private boolean gaussianNoise;
    private Random twister;

    public AddNoise(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.data = new VoxelOrderDataSource(CL_Initializer.inputFile, 1, CL_Initializer.inputDataType);
    }

    @Override
    public void initVariables() {
        this.twister = new MTRandom(CL_Initializer.seed);
        if (CL_Initializer.sigma <= 0.0) {
            String string = new String("Must set the noise level.  Include -sigma <sigma>.");
            logger.severe(string);
            throw new RuntimeException(string);
        }
        this.gaussianNoise = false;
        if (CL_Initializer.noiseType.toLowerCase().equals("gaussian")) {
            this.gaussianNoise = true;
        }
        this.voxels = Math.max(CL_Initializer.numVoxels, 1);
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (CL_Initializer.data.more()) {
            double[] dArray = CL_Initializer.data.nextVoxel();
            for (int i = 0; i < this.voxels; ++i) {
                double[] dArray2 = this.gaussianNoise ? DataSynthesizer.addGaussianNoise(dArray, CL_Initializer.sigma, this.twister) : DataSynthesizer.addNoise(dArray, CL_Initializer.sigma, this.twister);
                outputManager.output(dArray2);
            }
        }
        outputManager.close();
    }
}

