/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import java.io.DataInputStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class BinaryToText
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.BinaryToText");
    private String inputDataType;
    private String inputFile;
    private static DataInputStream in;
    private int decimalPlaces;
    private String zeros;
    private boolean annotate;
    private int components;

    public BinaryToText(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.inputDataType = "float";
        this.inputFile = null;
        in = new DataInputStream(System.in);
        this.decimalPlaces = 6;
        this.zeros = "";
        this.annotate = false;
        this.components = 0;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-inputdatatype")) {
                this.inputDataType = stringArray[i + 1];
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-dp")) {
                this.decimalPlaces = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-linenum")) {
                this.annotate = true;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-components")) continue;
            this.annotate = true;
            this.components = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        for (int i = 0; i < this.decimalPlaces; ++i) {
            this.zeros = this.zeros + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0." + this.zeros + "E00;-0." + this.zeros + "E00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0000");
        int n = 0;
        Object[] objectArray = new Object[1];
        while (true) {
            BinaryToText.readNext(this.inputDataType, objectArray);
            if (this.annotate) {
                if (this.components == 0) {
                    System.out.print(decimalFormat2.format(n + 1) + " : ");
                } else {
                    if (n % this.components == 0) {
                        System.out.println("--- Voxel : " + decimalFormat2.format(n / this.components + 1) + " ---");
                    }
                    System.out.print(decimalFormat2.format(n % this.components + 1) + " : ");
                }
            }
            if (this.inputDataType.equals("char") || this.inputDataType.equals("byte") || this.inputDataType.equals("short") || this.inputDataType.equals("int") || this.inputDataType.equals("long")) {
                System.out.println(MessageFormat.format("{0,number, 0;-0}", objectArray));
            } else if (this.inputDataType.equals("float") || this.inputDataType.equals("double")) {
                System.out.println(decimalFormat.format(((Number)objectArray[0]).doubleValue()));
            }
            ++n;
        }
    }

    public static void readNext(String string, Object[] objectArray) {
        try {
            if (string.equals("byte")) {
                objectArray[0] = new Byte(in.readByte());
            } else if (string.equals("char")) {
                int n = in.readByte();
                objectArray[0] = new Integer(n >= 0 ? n : 256 + n);
            } else if (string.equals("short")) {
                objectArray[0] = new Short(in.readShort());
            } else if (string.equals("int")) {
                objectArray[0] = new Integer(in.readInt());
            } else if (string.equals("long")) {
                objectArray[0] = new Long(in.readLong());
            } else if (string.equals("float")) {
                objectArray[0] = new Float(in.readFloat());
            } else if (string.equals("double")) {
                objectArray[0] = new Double(in.readDouble());
            }
        }
        catch (Exception exception) {
            try {
                in.close();
            }
            catch (Exception exception2) {
                LoggedException.logExceptionWarning(exception2, Thread.currentThread().getName());
            }
            System.exit(0);
        }
    }
}

