/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class ChunkStats
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.ChunkStats");
    private int chunkSize;
    private boolean mean;
    private boolean std;
    private int max;
    private int min;

    public ChunkStats(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.chunkSize = 1;
        this.mean = false;
        this.std = false;
        this.max = -1;
        this.min = -1;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-chunksize")) {
                this.chunkSize = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-mean")) {
                this.mean = true;
                CL_Initializer.markAsParsed(i, 1);
            }
            if (stringArray[i].equals("-std")) {
                this.std = true;
                CL_Initializer.markAsParsed(i, 1);
            }
            if (stringArray[i].equals("-max")) {
                this.max = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-min")) continue;
            this.min = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        if (this.max >= this.chunkSize || this.min >= this.chunkSize || this.max < -1 || this.min < -1) {
            throw new LoggedException("Index to max or min out of range.");
        }
    }

    @Override
    public void initVariables() {
        CL_Initializer.data = new VoxelOrderDataSource(CL_Initializer.inputFile, this.chunkSize, CL_Initializer.inputDataType);
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (CL_Initializer.data.more()) {
            try {
                int n;
                double[] dArray = null;
                double[] dArray2 = null;
                double[] dArray3 = null;
                double[] dArray4 = null;
                double d = 0.0;
                double d2 = 0.0;
                for (n = 0; n < CL_Initializer.samples; ++n) {
                    int n2;
                    double[] dArray5 = CL_Initializer.data.nextVoxel();
                    if (n == 0) {
                        dArray = new double[dArray5.length];
                        dArray2 = new double[dArray5.length];
                        dArray3 = new double[dArray5.length];
                        dArray4 = new double[dArray5.length];
                        for (n2 = 0; n2 < dArray5.length; ++n2) {
                            dArray[n2] = dArray5[n2];
                            dArray2[n2] = dArray5[n2] * dArray5[n2];
                            dArray3[n2] = dArray5[n2];
                            dArray4[n2] = dArray5[n2];
                        }
                        d = this.max >= 0 ? dArray5[this.max] : 0.0;
                        d2 = this.min >= 0 ? dArray5[this.min] : 0.0;
                        continue;
                    }
                    n2 = this.max >= 0 && dArray5[this.max] > d ? 1 : 0;
                    d = n2 != 0 ? dArray5[this.max] : d;
                    boolean bl = this.min >= 0 && dArray5[this.min] < d2;
                    d2 = bl ? dArray5[this.min] : d2;
                    for (int i = 0; i < dArray5.length; ++i) {
                        int n3 = i;
                        dArray[n3] = dArray[n3] + dArray5[i];
                        int n4 = i;
                        dArray2[n4] = dArray2[n4] + dArray5[i] * dArray5[i];
                        dArray3[i] = n2 != 0 ? dArray5[i] : dArray3[i];
                        dArray4[i] = bl ? dArray5[i] : dArray4[i];
                    }
                }
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = dArray[n] / (double)CL_Initializer.samples;
                    dArray2[n] = Math.sqrt(dArray2[n] / (double)(CL_Initializer.samples - 1) - dArray[n] * dArray[n]);
                }
                if (this.mean) {
                    outputManager.output(dArray);
                }
                if (this.std) {
                    outputManager.output(dArray2);
                }
                if (this.max >= 0) {
                    outputManager.output(dArray3);
                }
                if (this.min < 0) continue;
                outputManager.output(dArray4);
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
        outputManager.close();
    }
}

