/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.DataSource;
import data.OutputManager;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import java.io.IOException;
import misc.LoggedException;
import tools.CL_Initializer;

public class DT_ToCamino
extends Executable {
    private DataSource tensorSource;
    private DataSource s0Source;
    private String s0File;
    private boolean fileIsLnS0;
    private double scaleSlope;
    private double scaleInter;
    private boolean upperTriangular;
    private ImageHeader dtHeader;

    public DT_ToCamino(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.tensorSource = null;
        this.s0Source = null;
        this.s0File = null;
        this.fileIsLnS0 = false;
        this.scaleSlope = 1.0;
        this.scaleInter = 0.0;
        this.upperTriangular = false;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initMaskSource();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-s0")) {
                this.s0File = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-lns0")) {
                this.s0File = stringArray[i + 1];
                this.fileIsLnS0 = true;
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-scaleslope")) {
                this.scaleSlope = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-scaleinter")) {
                this.scaleInter = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-uppertriangular")) {
                this.upperTriangular = true;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-lowertriangular")) continue;
            this.upperTriangular = false;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        try {
            this.dtHeader = ImageHeader.readHeader(CL_Initializer.inputFile);
            this.tensorSource = this.dtHeader.getImageDataSource();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    @Override
    public void execute(OutputManager outputManager) {
        Object object;
        if (this.s0File != null) {
            if (ImageHeader.imageExists(this.s0File)) {
                try {
                    object = ImageHeader.readHeader(this.s0File);
                    this.s0Source = ((ImageHeader)object).getImageDataSource();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            } else {
                this.s0Source = new VoxelOrderDataSource(this.s0File, 1, CL_Initializer.inputDataType);
            }
        }
        while (this.tensorSource.more()) {
            object = this.tensorSource.nextVoxel();
            double[] dArray = new double[8];
            if (CL_Initializer.bgMask != null) {
                double d = dArray[0] = CL_Initializer.bgMask.nextVoxel()[0] == 0.0 ? -1.0 : 0.0;
            }
            if (dArray[0] >= 0.0) {
                if (this.upperTriangular) {
                    dArray[2] = (double)(object[0] * this.scaleSlope + this.scaleInter);
                    dArray[3] = (double)(object[1] * this.scaleSlope + this.scaleInter);
                    dArray[4] = (double)(object[2] * this.scaleSlope + this.scaleInter);
                    dArray[5] = (double)(object[3] * this.scaleSlope + this.scaleInter);
                    dArray[6] = (double)(object[4] * this.scaleSlope + this.scaleInter);
                    dArray[7] = (double)(object[5] * this.scaleSlope + this.scaleInter);
                } else {
                    dArray[2] = (double)(object[0] * this.scaleSlope + this.scaleInter);
                    dArray[3] = (double)(object[1] * this.scaleSlope + this.scaleInter);
                    dArray[4] = (double)(object[3] * this.scaleSlope + this.scaleInter);
                    dArray[5] = (double)(object[2] * this.scaleSlope + this.scaleInter);
                    dArray[6] = (double)(object[4] * this.scaleSlope + this.scaleInter);
                    dArray[7] = (double)(object[5] * this.scaleSlope + this.scaleInter);
                }
            }
            if (this.s0Source != null) {
                double d = 0.0;
                if (this.fileIsLnS0) {
                    d = this.s0Source.nextVoxel()[0];
                } else {
                    double d2 = this.s0Source.nextVoxel()[0];
                    if (d2 > 0.0) {
                        d = Math.log(d2);
                    }
                }
                if (dArray[0] >= 0.0) {
                    dArray[1] = d;
                }
            }
            outputManager.output(dArray);
        }
        outputManager.close();
    }
}

