/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.PointSetToScheme;
import data.OutputManager;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;
import misc.OrderedAcqSingleSubsetMinimizer;
import misc.OrderedAcqSubsetMinimizer;
import tools.CL_Initializer;
import tools.FileInput;
import tools.FileOutput;

public class ElectrostaticSubsets
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.ElectrostaticSubsets");
    private int numPoints;
    private int numSubsets;
    private int[] pairsPerSubset;
    private double temperature;
    private double coolingFactor;
    private int iterations;
    private boolean initFromFile;
    private boolean randomInit;
    private double[][] points;
    private String saveStateRoot;
    private boolean singleSubset;
    private int singleSubsetSize;
    private long seed;
    private OrderedAcqMinimizer minimizer;
    private Random ran;

    public ElectrostaticSubsets(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.numPoints = 0;
        this.numSubsets = 0;
        this.pairsPerSubset = null;
        this.temperature = -1.0;
        this.coolingFactor = 1.0E-7;
        this.iterations = 1000;
        this.initFromFile = false;
        this.randomInit = false;
        this.points = null;
        this.saveStateRoot = "ElectrostaticSubsets";
        this.singleSubset = false;
        this.singleSubsetSize = 0;
        this.seed = System.currentTimeMillis();
        this.minimizer = null;
    }

    @Override
    public void initOptions(String[] stringArray) {
        if (stringArray.length == 0) {
            System.exit(0);
        }
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Object object;
            if (stringArray[i].equals("-numpoints")) {
                this.numPoints = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-singlesubset")) {
                this.singleSubset = true;
                this.singleSubsetSize = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-numsubsets")) {
                this.numSubsets = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-pointspersubset")) {
                object = new int[1000];
                int n2 = 0;
                while (i + n2 + 1 < stringArray.length && !stringArray[i + 1 + n2].startsWith("-")) {
                    object[n2] = Integer.parseInt(stringArray[i + n2 + 1]);
                    ++n2;
                }
                this.pairsPerSubset = new int[n2];
                this.numSubsets = n2;
                for (n = 0; n < this.pairsPerSubset.length; ++n) {
                    this.pairsPerSubset[n] = object[n];
                }
                CL_Initializer.markAsParsed(i, this.numSubsets + 1);
            }
            if (stringArray[i].equals("-seed")) {
                this.seed = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-coolingfactor")) {
                this.coolingFactor = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-trialsbetweencooling")) {
                this.iterations = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-temperature")) {
                this.temperature = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-savestate")) {
                this.saveStateRoot = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-resume")) {
                this.initFromFile = true;
                object = new FileInput(stringArray[i + 1]);
                String[] stringArray2 = ((FileInput)object).readString().split("\\s");
                this.numPoints = Integer.parseInt(stringArray2[0]);
                this.numSubsets = Integer.parseInt(stringArray2[1]);
                this.pairsPerSubset = new int[this.numSubsets];
                for (n = 0; n < this.numSubsets; ++n) {
                    this.pairsPerSubset[n] = Integer.parseInt(stringArray2[n + 2]);
                }
                if (this.temperature == -1.0) {
                    this.temperature = Double.parseDouble(stringArray2[2 + this.numSubsets]);
                }
                this.points = new double[this.numPoints][3];
                for (n = 0; n < this.numPoints; ++n) {
                    String[] stringArray3 = ((FileInput)object).readString().split("\\s");
                    this.points[n][0] = Double.parseDouble(stringArray3[0]);
                    this.points[n][1] = Double.parseDouble(stringArray3[1]);
                    this.points[n][2] = Double.parseDouble(stringArray3[2]);
                }
                ((FileInput)object).close();
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-randominit")) continue;
            this.randomInit = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        if (this.singleSubset && this.numSubsets > 0) {
            logger.warning("Single subset specified, but user also passed -numsubsets or -pointspersubset args.");
        }
        if (this.numPoints == 0) {
            this.initFromFile = true;
            try {
                this.points = PointSetToScheme.normalizePoints(PointSetToScheme.readPoints(CL_Initializer.inputFile));
                this.numPoints = this.points.length;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        this.ran = new Random(this.seed);
    }

    @Override
    public void execute(OutputManager outputManager) {
        System.err.println(this.seed);
        if (this.singleSubset) {
            if (this.initFromFile) {
                this.minimizer = new OrderedAcqSingleSubsetMinimizer(this.points, this.singleSubsetSize, this.coolingFactor, this.iterations, this.saveStateRoot, this.ran);
                if (this.randomInit) {
                    this.minimizer.initializeRandom();
                }
            } else {
                this.minimizer = new OrderedAcqSingleSubsetMinimizer(this.numPoints, this.singleSubsetSize, this.coolingFactor, this.iterations, this.saveStateRoot, this.ran);
            }
        } else {
            int n;
            if (this.pairsPerSubset == null) {
                if (this.numPoints % this.numSubsets != 0) {
                    throw new IllegalArgumentException("Can't divide " + this.numPoints + " pairs equally into " + this.numSubsets + "subsets");
                }
                this.pairsPerSubset = new int[this.numSubsets];
                for (n = 0; n < this.numSubsets; ++n) {
                    this.pairsPerSubset[n] = this.numPoints / this.numSubsets;
                }
            }
            n = 0;
            for (int i = 0; i < this.numSubsets; ++i) {
                n += this.pairsPerSubset[i];
            }
            if (n != this.numPoints) {
                throw new LoggedException("Specified subsets require " + n + " points but there are " + this.numPoints + " points");
            }
            if (this.initFromFile) {
                this.minimizer = new OrderedAcqSubsetMinimizer(this.points, this.pairsPerSubset, this.coolingFactor, this.iterations, this.saveStateRoot, this.ran);
                if (this.randomInit) {
                    this.minimizer.initializeRandom();
                }
            } else {
                this.minimizer = new OrderedAcqSubsetMinimizer(this.numPoints, this.pairsPerSubset, this.coolingFactor, this.iterations, this.saveStateRoot, this.ran);
            }
        }
        if (this.temperature < 0.0) {
            this.minimizer.setTemperature(this.minimizer.calibratedTemp(0.7));
        } else {
            this.minimizer.setTemperature(this.temperature);
        }
        this.minimizer.minimize();
        if (OutputManager.outputFile == null) {
            System.out.print(this.minimizer.lowestEnergyState());
        } else {
            FileOutput fileOutput = new FileOutput(OutputManager.outputFile);
            fileOutput.writeString(this.minimizer.lowestEnergyState());
            fileOutput.close();
        }
    }
}

