/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.FileInput;
import tools.FileOutput;

public class FSL_ToScheme
extends Executable {
    private static final Logger logger = Logger.getLogger("apps.FSL_ToScheme");
    private String bvecfile;
    private String bvalfile;
    private String outputFile;
    private double bScale;
    private boolean flipX;
    private boolean flipY;
    private boolean flipZ;
    private int numScans;
    private boolean interleave;
    private boolean useGradMod;

    public FSL_ToScheme(String[] stringArray) {
        super(stringArray);
        Locale.setDefault(Locale.UK);
    }

    @Override
    public void initDefaultVals() {
        this.bvecfile = null;
        this.bvalfile = null;
        this.outputFile = null;
        this.bScale = 1000000.0;
        this.flipX = false;
        this.flipY = false;
        this.flipZ = false;
        this.numScans = 1;
        this.interleave = false;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-bvecfile") || stringArray[i].equals("-bvecs")) {
                this.bvecfile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-bvalfile") || stringArray[i].equals("-bvals")) {
                this.bvalfile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputfile")) {
                this.outputFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-bscale")) {
                this.bScale = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-numscans")) {
                this.numScans = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-interleave")) {
                this.interleave = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-usegradmod")) {
                this.useGradMod = true;
                logger.info("Gradient direction magnitude will be incorporated into b-value");
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipx")) {
                this.flipX = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipy")) {
                this.flipY = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (!stringArray[i].equals("-flipz")) continue;
            this.flipZ = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n;
        String string = "";
        FileInput fileInput = new FileInput(this.bvecfile);
        String[] stringArray = fileInput.readString().trim().split("\\s+");
        String[] stringArray2 = fileInput.readString().trim().split("\\s+");
        String[] stringArray3 = fileInput.readString().trim().split("\\s+");
        fileInput.close();
        int n2 = stringArray.length;
        int n3 = this.numScans * n2;
        FileInput fileInput2 = new FileInput(this.bvalfile);
        String[] stringArray4 = fileInput2.readString().trim().split("\\s+");
        if (stringArray4.length != n2) {
            throw new LoggedException("Number of b-vectors and b-values do not match");
        }
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.000000");
        DecimalFormat decimalFormat3 = new DecimalFormat("   0.000E00");
        string = string + "# Scheme file created by fsl2scheme\nVERSION: BVECTOR\n";
        boolean bl = false;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = Double.parseDouble(stringArray[n]);
            dArray2[n] = Double.parseDouble(stringArray2[n]);
            dArray3[n] = Double.parseDouble(stringArray3[n]);
            dArray4[n] = Double.parseDouble(stringArray4[n]);
        }
        if (this.numScans > 1) {
            int n4;
            double[] dArray5 = new double[n3];
            double[] dArray6 = new double[n3];
            double[] dArray7 = new double[n3];
            double[] dArray8 = new double[n3];
            if (this.interleave) {
                for (n4 = 0; n4 < n2; ++n4) {
                    for (int i = 0; i < this.numScans; ++i) {
                        dArray5[n4 * this.numScans + i] = dArray[n4];
                        dArray6[n4 * this.numScans + i] = dArray2[n4];
                        dArray7[n4 * this.numScans + i] = dArray3[n4];
                        dArray8[n4 * this.numScans + i] = dArray4[n4];
                    }
                }
            } else {
                for (n4 = 0; n4 < this.numScans; ++n4) {
                    System.arraycopy(dArray, 0, dArray5, n2 * n4, n2);
                    System.arraycopy(dArray2, 0, dArray6, n2 * n4, n2);
                    System.arraycopy(dArray3, 0, dArray7, n2 * n4, n2);
                    System.arraycopy(dArray4, 0, dArray8, n2 * n4, n2);
                }
            }
            dArray = dArray5;
            dArray2 = dArray6;
            dArray3 = dArray7;
            dArray4 = dArray8;
        }
        for (n = 0; n < n3; ++n) {
            double d = Math.sqrt(dArray[n] * dArray[n] + dArray2[n] * dArray2[n] + dArray3[n] * dArray3[n]);
            if (d == 0.0 || Math.abs(1.0 - d) < 1.0E-4) {
                d = 1.0;
            }
            if (!this.useGradMod && d != 1.0) {
                bl = true;
            }
            dArray[n] = dArray[n] / d;
            if (this.flipX && dArray[n] != 0.0) {
                dArray[n] = -dArray[n];
            }
            dArray2[n] = dArray2[n] / d;
            if (this.flipY && dArray2[n] != 0.0) {
                dArray2[n] = -dArray2[n];
            }
            dArray3[n] = dArray3[n] / d;
            if (this.flipZ && dArray3[n] != 0.0) {
                dArray3[n] = -dArray3[n];
            }
            if (dArray[n] == 0.0) {
                dArray[n] = Math.abs(dArray[n]);
            }
            if (dArray2[n] == 0.0) {
                dArray2[n] = Math.abs(dArray2[n]);
            }
            if (dArray3[n] == 0.0) {
                dArray3[n] = Math.abs(dArray3[n]);
            }
            string = string + decimalFormat.format(dArray[n]);
            string = string + decimalFormat.format(dArray2[n]);
            string = string + decimalFormat.format(dArray3[n]);
            string = this.useGradMod ? string + decimalFormat3.format(dArray4[n] * this.bScale * d * d) + "\n" : string + decimalFormat3.format(dArray4[n] * this.bScale) + "\n";
        }
        if (bl) {
            logger.warning("Some measurements have non-unit gradient directions. Directions have been normalized to unit length");
        }
        if (this.outputFile != null) {
            FileOutput fileOutput = new FileOutput(this.outputFile);
            fileOutput.writeString(string);
            fileOutput.close();
        } else {
            System.out.println(string);
        }
    }
}

