/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.BallStick;
import data.OutputManager;
import numerics.Vector3D;
import tools.CL_Initializer;

public class FanningGrid
extends Executable {
    private double diffusivity;
    private double volfrac;
    private int[] gridsize;
    private double centreDist;

    public FanningGrid(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.diffusivity = 0.0;
        double d = 0.0;
        Object var3_2 = null;
        double d2 = 0.0;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        this.diffusivity = CL_Initializer.DIFF_CONST;
        this.volfrac = CL_Initializer.volFrac;
        this.gridsize = CL_Initializer.dataDims;
        this.centreDist = CL_Initializer.centreDist;
    }

    @Override
    public void execute(OutputManager outputManager) {
        for (int i = 0; i < this.gridsize[2]; ++i) {
            for (int j = 0; j < this.gridsize[1]; ++j) {
                for (int k = 0; k < this.gridsize[0]; ++k) {
                    double[] dArray = FanningGrid.getOrientation(k, j, i, this.gridsize, this.centreDist);
                    BallStick ballStick = new BallStick(this.diffusivity, this.volfrac, dArray);
                    double[] dArray2 = ballStick.getInformationArray();
                    double[] dArray3 = new double[dArray2.length + 2];
                    dArray3[0] = 0.0;
                    dArray3[1] = 0.0;
                    for (int i2 = 2; i2 < dArray3.length; ++i2) {
                        dArray3[i2] = dArray2[i2 - 2];
                    }
                    outputManager.output(dArray3);
                }
            }
        }
        outputManager.close();
    }

    private static double[] getOrientation(int n, int n2, int n3, int[] nArray, double d) {
        Vector3D vector3D = new Vector3D((double)(-nArray[0]) / 2.0 + (double)n + 0.5, (double)(-nArray[1]) / 2.0 + (double)n2 + 0.5, d - (double)nArray[2] / 2.0 + (double)n3 + 0.5);
        double d2 = vector3D.mod();
        if (d2 > 0.0) {
            double[] dArray = new double[]{vector3D.x / d2, vector3D.y / d2, vector3D.z / d2};
            return dArray;
        }
        return new double[]{1.0, 0.0, 0.0};
    }
}

