/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.ModelFit;
import data.OutputManager;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import tools.CL_Initializer;

public class FracAnis
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.FracAnis");

    public FracAnis(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputModel = "dt";
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initTensorDataSource();
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (CL_Initializer.data.more()) {
            try {
                int n;
                boolean bl;
                double[] dArray = CL_Initializer.data.nextVoxel();
                DT[] dTArray = FracAnis.getTensorList(dArray, CL_Initializer.inputModel);
                double[] dArray2 = new double[dTArray.length];
                boolean bl2 = bl = !ModelFit.isBG(Math.exp(dArray[1]));
                if (dArray[0] >= 0.0 && bl) {
                    for (n = 0; n < dTArray.length; ++n) {
                        dArray2[n] = dTArray[n].fa();
                    }
                } else {
                    for (n = 0; n < dTArray.length; ++n) {
                        dArray2[n] = 0.0;
                    }
                }
                outputManager.output(dArray2);
            }
            catch (Exception exception) {
                LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            }
        }
        outputManager.close();
    }

    public static DT[] getTensorList(double[] dArray, String string) {
        DT[] dTArray = null;
        if (string.equals("dt")) {
            dTArray = new DT[]{new DT(dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7])};
        } else if (string.equals("twotensor")) {
            dTArray = new DT[]{new DT(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9]), new DT(dArray[11], dArray[12], dArray[13], dArray[14], dArray[15], dArray[16])};
        } else if (string.equals("threetensor")) {
            dTArray = new DT[]{new DT(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9]), new DT(dArray[11], dArray[12], dArray[13], dArray[14], dArray[15], dArray[16]), new DT(dArray[18], dArray[19], dArray[20], dArray[21], dArray[22], dArray[23])};
        } else if (string.equals("multitensor")) {
            dTArray = new DT[CL_Initializer.maxTensorComponents];
            for (int i = 0; i < dTArray.length; ++i) {
                dTArray[i] = new DT(dArray[4 + 7 * i], dArray[5 + 7 * i], dArray[6 + 7 * i], dArray[7 + 7 * i], dArray[8 + 7 * i], dArray[9 + 7 * i]);
            }
        } else {
            throw new RuntimeException("Cannot extract tensors from model: " + string);
        }
        return dTArray;
    }
}

