/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import imaging.DW_Scheme;
import inverters.ModelIndex;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import misc.LoggedException;
import numerics.MTRandom;
import tools.CL_Initializer;
import tractography.DT_LookupTableGenerator;
import tractography.OneTensorLUTGenerator;
import tractography.TwoTensorLUTGenerator;

public final class GenerateDTLUT
extends Executable {
    Random ran;
    private double xMin;
    private double xMax;
    private double step;
    private int samples;
    private double prop;
    private double cross;
    private int crossDeg;
    private boolean watson;
    private boolean bingham;
    private boolean acg;
    private boolean twoTensor;
    private long seed;
    private boolean twoD;
    private double trace;
    private String outputRoot;
    private double snr;
    private ModelIndex inversionIndex;
    private DW_Scheme imPars;

    public GenerateDTLUT(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.xMin = 0.0;
        this.xMax = 0.0;
        this.step = 0.0;
        this.samples = 2000;
        this.seed = System.currentTimeMillis();
        this.prop = 0.5;
        this.cross = 0.0;
        this.crossDeg = 0;
        this.watson = false;
        this.bingham = false;
        this.acg = false;
        this.twoTensor = false;
        this.twoD = true;
        this.outputRoot = "";
        this.snr = 0.0;
        this.inversionIndex = null;
        this.imPars = null;
        this.trace = 2.1E-9;
    }

    @Override
    public void initOptions(String[] stringArray) {
        if (stringArray.length == 0) {
            System.exit(0);
        }
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initImagingScheme();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-lrange")) {
                this.xMin = Double.parseDouble(stringArray[i + 1]);
                this.xMax = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
                continue;
            }
            if (stringArray[i].equals("-frange")) {
                this.xMin = Double.parseDouble(stringArray[i + 1]);
                this.xMax = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
                continue;
            }
            if (stringArray[i].equals("-step")) {
                this.step = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-trace")) {
                this.trace = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                this.seed = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-samples")) {
                this.samples = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-watson")) {
                this.watson = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-bingham")) {
                this.bingham = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-acg")) {
                this.acg = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-prop")) {
                this.prop = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-cross")) {
                this.cross = Math.PI / 180 * Double.parseDouble(stringArray[i + 1]);
                this.crossDeg = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-outputroot")) continue;
            this.outputRoot = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        this.inversionIndex = CL_Initializer.inversionIndices[0];
        this.imPars = CL_Initializer.imPars;
        this.snr = CL_Initializer.SNR;
    }

    @Override
    public void execute(OutputManager outputManager) {
        if (this.snr == -1.0) {
            throw new LoggedException("Cannot generate LUT without valid SNR");
        }
        if (this.cross > 0.0 || this.inversionIndex.numDTs == 2) {
            this.twoTensor = true;
            if (this.cross == 0.0) {
                throw new LoggedException("Attempting to create two-tensor LUT with zero degree crossing angle");
            }
            if (this.inversionIndex.numDTs < 2) {
                throw new LoggedException("Attempting to create two-tensor LUT with single tensor inversion.");
            }
        }
        if (this.xMin == 0.0 && this.xMax == 0.0) {
            if (this.twoTensor) {
                this.xMin = 0.3;
                this.xMax = 0.94;
            } else {
                this.xMin = 1.0;
                this.xMax = 10.0;
            }
        }
        if (this.step == 0.0) {
            this.step = this.xMax < 1.0 ? 0.02 : 0.2;
        }
        if (this.xMax < 1.0 && this.inversionIndex.numDTs == 1) {
            this.twoD = false;
        }
        if (!(this.watson || this.bingham || this.acg)) {
            this.bingham = true;
        }
        if ((this.xMin - this.xMax) / this.step - (double)((int)((this.xMin - this.xMax) / this.step)) > 1.0E-8) {
            throw new LoggedException("LUT range must divide into a whole number of steps");
        }
        if (this.xMin > this.xMax) {
            throw new LoggedException("Illegal range specified: max < min");
        }
        if (this.twoTensor) {
            if (this.xMin < 0.0 || this.xMax > 1.0) {
                throw new LoggedException("FA range must be between 0 and 1");
            }
        } else if (!this.twoD) {
            if (this.xMin < 0.0 || this.xMax > 1.0) {
                throw new LoggedException("FA range must be between 0 and 1");
            }
        } else if (this.xMin < 1.0) {
            throw new LoggedException("min(L1 / L3) must not be less than 1");
        }
        this.ran = new MTRandom(this.seed);
        DT_LookupTableGenerator dT_LookupTableGenerator = null;
        dT_LookupTableGenerator = this.twoTensor ? new TwoTensorLUTGenerator(this.imPars, this.snr, this.trace, this.prop, this.cross, this.ran) : new OneTensorLUTGenerator(this.imPars, this.snr, this.trace, this.ran);
        double[][][][] dArray = ((DT_LookupTableGenerator)dT_LookupTableGenerator).generateLUT(this.xMin, this.xMax, this.step, this.samples, this.inversionIndex, this.watson, this.bingham, this.acg);
        String string = "_snr" + (int)this.snr + "_" + (Object)((Object)this.inversionIndex);
        if (this.crossDeg > 0) {
            string = string + "_" + this.crossDeg;
        }
        boolean bl = (!this.watson || !this.bingham) && (this.watson || this.bingham) ^ this.acg;
        try {
            double[] dArray2 = new double[]{this.xMin, this.xMax, this.xMin, this.xMax};
            double[] dArray3 = new double[]{this.step, this.step};
            if (!this.twoD) {
                dArray2 = new double[]{0.0, 0.0, this.xMin, this.xMax};
                dArray3 = new double[]{0.0, this.step};
            }
            if (bl) {
                DataOutputStream dataOutputStream = outputManager.getOutputStream();
                if (this.watson) {
                    this.writeBinaryOutput(dArray[0], dArray2, dArray3, dataOutputStream);
                }
                if (this.bingham) {
                    this.writeBinaryOutput(dArray[1], dArray2, dArray3, dataOutputStream);
                }
                if (this.acg) {
                    this.writeBinaryOutput(dArray[2], dArray2, dArray3, dataOutputStream);
                }
            } else {
                DataOutputStream dataOutputStream;
                FileOutputStream fileOutputStream;
                if (this.watson) {
                    fileOutputStream = new FileOutputStream(this.outputRoot + "watson" + string);
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x100000));
                    this.writeBinaryOutput(dArray[0], dArray2, dArray3, dataOutputStream);
                    dataOutputStream.close();
                }
                if (this.bingham) {
                    fileOutputStream = new FileOutputStream(this.outputRoot + "bingham" + string);
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x100000));
                    this.writeBinaryOutput(dArray[1], dArray2, dArray3, dataOutputStream);
                    dataOutputStream.close();
                }
                if (this.acg) {
                    fileOutputStream = new FileOutputStream(this.outputRoot + "acg" + string);
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x100000));
                    this.writeBinaryOutput(dArray[2], dArray2, dArray3, dataOutputStream);
                    dataOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("I/O error while writing LUT");
        }
    }

    private void writeBinaryOutput(double[][][] dArray, double[] dArray2, double[] dArray3, DataOutputStream dataOutputStream) {
        try {
            int n = dArray[0][0].length;
            dataOutputStream.writeDouble(0.0);
            dataOutputStream.writeDouble(0.0);
            dataOutputStream.writeDouble(dArray2[0]);
            dataOutputStream.writeDouble(dArray2[1]);
            dataOutputStream.writeDouble(dArray2[2]);
            dataOutputStream.writeDouble(dArray2[3]);
            dataOutputStream.writeDouble(0.0);
            dataOutputStream.writeDouble(dArray3[0]);
            dataOutputStream.writeDouble(dArray3[1]);
            dataOutputStream.writeDouble(n);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    for (int k = 0; k < dArray.length; ++k) {
                        dataOutputStream.writeDouble(dArray[k][j][i]);
                    }
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new LoggedException("I/O error while writing LUT");
        }
    }
}

