/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.DataSource;
import data.ExternalDataSource;
import data.OutputManager;
import imaging.ImageHeader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class ImageToVoxel
extends Executable {
    private String singleVolumeFile;
    private String imageListFile;
    private String imagePrefix;
    private boolean imagePrefixSet;
    private static Logger logger = Logger.getLogger("camino.apps.ImageToVoxel");

    public ImageToVoxel(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.singleVolumeFile = null;
        this.imageListFile = null;
        this.imagePrefix = "";
        this.imagePrefixSet = false;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        if (CL_Initializer.inputFile != null) {
            if (ImageHeader.imageExists(CL_Initializer.inputFile)) {
                this.singleVolumeFile = CL_Initializer.inputFile;
            } else {
                this.imageListFile = CL_Initializer.inputFile;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-4dimage") || stringArray[i].equals("-4dimageroot")) {
                this.singleVolumeFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-imagelist")) {
                this.imageListFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-imageprefix")) {
                this.imagePrefix = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                this.imagePrefixSet = true;
            }
            if (!stringArray[i].equals("-ignorespmscale")) continue;
            logger.warning("Option -ignorespmscale is deprecated. Scaling is applied. Modify the header to alter scaling");
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        if (this.singleVolumeFile != null) {
            ImageHeader imageHeader = null;
            try {
                imageHeader = ImageHeader.readHeader(this.singleVolumeFile);
            }
            catch (IOException iOException) {
                throw new LoggedException("Cannot read image matching " + this.singleVolumeFile);
            }
            DataSource dataSource = imageHeader.getImageDataSource();
            while (dataSource.more()) {
                outputManager.output(dataSource.nextVoxel());
            }
            outputManager.close();
        } else {
            int n;
            String string;
            int n2;
            if (!this.imagePrefixSet && (n2 = this.imageListFile.lastIndexOf(string = "/")) > -1) {
                this.imagePrefix = this.imageListFile.substring(0, n2 + 1);
            }
            ExternalDataSource.FILEBUFFERSIZE = n = 0x400000;
            ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
            DataSource[] dataSourceArray = null;
            int n3 = 0;
            try {
                Object object;
                Scanner scanner = new Scanner(new File(this.imageListFile));
                scanner.useDelimiter("\r\n|\n");
                while (scanner.hasNext()) {
                    object = this.imagePrefix.concat(scanner.next().trim());
                    arrayList.add(ImageHeader.readHeader((String)object).getImageDataSource());
                    ++n3;
                }
                scanner.close();
                dataSourceArray = new DataSource[n3];
                arrayList.toArray(dataSourceArray);
                while (dataSourceArray[0].more()) {
                    object = new double[n3];
                    for (int i = 0; i < n3; ++i) {
                        object[i] = dataSourceArray[i].nextVoxel()[0];
                    }
                    outputManager.output((double[])object);
                }
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        outputManager.close();
    }
}

