/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.VoxelOrderDataSource;
import inverters.ModelIndex;
import java.io.DataInputStream;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import numerics.RealMatrix;
import tools.CL_Initializer;

public class InversionStats
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.InversionStats");
    protected final int NUMDTPROPERTIES = 5;
    protected final int NUMTWOTENSORPROPERTIES = 12;
    protected final int NUMTHREETENSORPROPERTIES = 18;
    protected static final int DIRSTATS = 6;
    protected final int NUMDTSTATS = 10;
    protected final int NUMTWOTENSORSTATS = 22;
    protected final int NUMTHREETENSORSTATS = 34;
    protected static double dpThresh = 0.95;
    private static int numExpectedDirections;
    private DataInputStream in;

    public InversionStats(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        dpThresh = 0.95;
        int n = -1;
        this.in = null;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-expect")) {
                numExpectedDirections = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (!stringArray[i].equals("-threshold")) continue;
            dpThresh = Double.parseDouble(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i);
            CL_Initializer.markAsParsed(i + 1);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        int n = this.getNumParams(CL_Initializer.inversionIndices[0]);
        CL_Initializer.data = new VoxelOrderDataSource(CL_Initializer.inputFile, n, CL_Initializer.inputDataType);
    }

    @Override
    public void execute(OutputManager outputManager) {
        double[][] dArray = this.getPropertiesList(CL_Initializer.numVoxels, CL_Initializer.inversionIndices[0], numExpectedDirections);
        double[] dArray2 = this.computeStats(dArray, CL_Initializer.inversionIndices[0]);
        double[] dArray3 = new double[dArray2.length + 2];
        dArray3[0] = dArray.length;
        dArray3[1] = (double)dArray.length / (double)CL_Initializer.numVoxels;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray3[i + 2] = dArray2[i];
        }
        outputManager.output(dArray3);
        outputManager.close();
    }

    protected double[][] getPropertiesList(int n, ModelIndex modelIndex, int n2) {
        int n3;
        int n4 = this.getNumParams(CL_Initializer.inversionIndices[0]);
        int n5 = this.getNumProperties(modelIndex);
        double[][] dArray = new double[n][n4];
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = CL_Initializer.data.nextVoxel();
            for (n3 = 0; n3 < n4; ++n3) {
                dArray[i][n3] = dArray2[n3];
            }
            if (!this.successfulInversion(dArray2, n2)) continue;
            ++n6;
        }
        double[][] dArray3 = new double[n6][n5];
        int n7 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (!this.successfulInversion(dArray[n3], n2)) continue;
            double[] dArray4 = this.getProperties(dArray[n3], modelIndex);
            for (int i = 0; i < dArray4.length; ++i) {
                dArray3[n7][i] = dArray4[i];
            }
            ++n7;
        }
        return dArray3;
    }

    protected boolean successfulInversion(double[] dArray, int n) {
        return dArray[0] == 0.0;
    }

    protected int getNumParams(ModelIndex modelIndex) {
        if (modelIndex.numDTs == 1) {
            return 8;
        }
        if (modelIndex.numDTs == 2) {
            return 17;
        }
        if (modelIndex.numDTs == 3) {
            return 24;
        }
        throw new LoggedException("Inversion " + (Object)((Object)modelIndex) + " is not supported");
    }

    protected int getNumProperties(ModelIndex modelIndex) {
        if (modelIndex.numDTs == 1) {
            return 5;
        }
        if (modelIndex.numDTs == 2) {
            return 12;
        }
        if (modelIndex.numDTs == 3) {
            return 18;
        }
        throw new LoggedException("Inversion " + (Object)((Object)modelIndex) + " is not supported");
    }

    protected double[] getProperties(double[] dArray, ModelIndex modelIndex) {
        if (modelIndex.numDTs == 1) {
            return this.getDT_Properties(dArray);
        }
        if (modelIndex.numDTs == 2) {
            return this.getTwoTensorProperties(dArray);
        }
        return this.getThreeTensorProperties(dArray);
    }

    protected double[] getDT_Properties(double[] dArray) {
        double[] dArray2 = new double[5];
        DT dT = new DT(dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
        double[] dArray3 = dT.getPD();
        for (int i = 0; i < dArray3.length; ++i) {
            dArray2[i] = dArray3[i];
        }
        dArray2[3] = dT.trace();
        dArray2[4] = dT.fa();
        return dArray2;
    }

    protected double[] getTwoTensorProperties(double[] dArray) {
        double[] dArray2 = new double[12];
        DT dT = new DT(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9]);
        DT dT2 = new DT(dArray[11], dArray[12], dArray[13], dArray[14], dArray[15], dArray[16]);
        double[] dArray3 = dT.getPD();
        double[] dArray4 = dT2.getPD();
        for (int i = 0; i < dArray3.length; ++i) {
            dArray2[i] = dArray3[i];
            dArray2[i + 6] = dArray4[i];
        }
        dArray2[3] = dArray[3];
        dArray2[4] = dT.trace();
        dArray2[5] = dT.fa();
        dArray2[9] = dArray[10];
        dArray2[10] = dT2.trace();
        dArray2[11] = dT2.fa();
        return dArray2;
    }

    protected double[] getThreeTensorProperties(double[] dArray) {
        double[] dArray2 = new double[18];
        DT dT = new DT(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9]);
        DT dT2 = new DT(dArray[11], dArray[12], dArray[13], dArray[14], dArray[15], dArray[16]);
        DT dT3 = new DT(dArray[18], dArray[19], dArray[20], dArray[21], dArray[22], dArray[23]);
        double[] dArray3 = dT.getPD();
        double[] dArray4 = dT2.getPD();
        double[] dArray5 = dT3.getPD();
        for (int i = 0; i < dArray3.length; ++i) {
            dArray2[i] = dArray3[i];
            dArray2[i + 6] = dArray4[i];
            dArray2[i + 12] = dArray5[i];
        }
        dArray2[3] = dArray[3];
        dArray2[4] = dT.trace();
        dArray2[5] = dT.fa();
        dArray2[9] = dArray[10];
        dArray2[10] = dT2.trace();
        dArray2[11] = dT2.fa();
        dArray2[15] = dArray[17];
        dArray2[16] = dT3.trace();
        dArray2[17] = dT3.fa();
        return dArray2;
    }

    protected double[] computeStats(double[][] dArray, ModelIndex modelIndex) {
        if (modelIndex.numDTs == 1) {
            return this.computeStatsDT(dArray);
        }
        if (modelIndex.numDTs == 2) {
            return this.computeStatsTwoTensor(dArray);
        }
        return this.computeStatsThreeTensor(dArray);
    }

    protected double[] computeStatsDT(double[][] dArray) {
        double[] dArray2 = InversionStats.oneDirectionStats(dArray, 0);
        double[] dArray3 = InversionStats.meanSTDMaxAndMin(dArray, 3);
        double[] dArray4 = InversionStats.meanSTDMaxAndMin(dArray, 4);
        double[] dArray5 = new double[10];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray5[i] = dArray2[i];
        }
        dArray5[6] = dArray3[0];
        dArray5[7] = dArray3[1];
        dArray5[8] = dArray4[0];
        dArray5[9] = dArray4[1];
        return dArray5;
    }

    protected double[] computeStatsTwoTensor(double[][] dArray) {
        int n;
        int n2 = 0;
        int n3 = 6;
        int n4 = 2;
        this.orderComponentsByDirection(dArray, n4, n3, n2);
        int n5 = 0;
        int n6 = n3;
        double[] dArray2 = InversionStats.oneDirectionStats(dArray, n5);
        double[] dArray3 = InversionStats.oneDirectionStats(dArray, n6);
        double[] dArray4 = InversionStats.meanSTDMaxAndMin(dArray, n5 + 3);
        double[] dArray5 = InversionStats.meanSTDMaxAndMin(dArray, n5 + 4);
        double[] dArray6 = InversionStats.meanSTDMaxAndMin(dArray, n5 + 5);
        double[] dArray7 = InversionStats.meanSTDMaxAndMin(dArray, n6 + 4);
        double[] dArray8 = InversionStats.meanSTDMaxAndMin(dArray, n6 + 5);
        double[] dArray9 = new double[22];
        for (n = 0; n < dArray2.length; ++n) {
            dArray9[n] = dArray2[n];
        }
        dArray9[6] = dArray5[0];
        dArray9[7] = dArray5[1];
        dArray9[8] = dArray6[0];
        dArray9[9] = dArray6[1];
        for (n = 0; n < dArray3.length; ++n) {
            dArray9[n + 10] = dArray3[n];
        }
        dArray9[16] = dArray7[0];
        dArray9[17] = dArray7[1];
        dArray9[18] = dArray8[0];
        dArray9[19] = dArray8[1];
        dArray9[20] = dArray4[0];
        dArray9[21] = dArray4[1];
        return dArray9;
    }

    protected double[] computeStatsThreeTensor(double[][] dArray) {
        int n;
        int n2 = 0;
        int n3 = 6;
        int n4 = 3;
        this.orderComponentsByDirection(dArray, n4, n3, n2);
        int n5 = 0;
        int n6 = n3;
        int n7 = n3 * 2;
        double[] dArray2 = InversionStats.oneDirectionStats(dArray, n5);
        double[] dArray3 = InversionStats.oneDirectionStats(dArray, n6);
        double[] dArray4 = InversionStats.oneDirectionStats(dArray, n7);
        double[] dArray5 = InversionStats.meanSTDMaxAndMin(dArray, n5 + 3);
        double[] dArray6 = InversionStats.meanSTDMaxAndMin(dArray, n6 + 3);
        double[] dArray7 = InversionStats.meanSTDMaxAndMin(dArray, n5 + 4);
        double[] dArray8 = InversionStats.meanSTDMaxAndMin(dArray, n5 + 5);
        double[] dArray9 = InversionStats.meanSTDMaxAndMin(dArray, n6 + 4);
        double[] dArray10 = InversionStats.meanSTDMaxAndMin(dArray, n6 + 5);
        double[] dArray11 = InversionStats.meanSTDMaxAndMin(dArray, n7 + 4);
        double[] dArray12 = InversionStats.meanSTDMaxAndMin(dArray, n7 + 5);
        double[] dArray13 = new double[34];
        for (n = 0; n < dArray2.length; ++n) {
            dArray13[n] = dArray2[n];
        }
        dArray13[6] = dArray7[0];
        dArray13[7] = dArray7[1];
        dArray13[8] = dArray8[0];
        dArray13[9] = dArray8[1];
        for (n = 0; n < dArray3.length; ++n) {
            dArray13[n + 10] = dArray3[n];
        }
        dArray13[16] = dArray9[0];
        dArray13[17] = dArray9[1];
        dArray13[18] = dArray10[0];
        dArray13[19] = dArray10[1];
        for (n = 0; n < dArray4.length; ++n) {
            dArray13[n + 20] = dArray4[n];
        }
        dArray13[26] = dArray11[0];
        dArray13[27] = dArray11[1];
        dArray13[28] = dArray12[0];
        dArray13[29] = dArray12[1];
        dArray13[30] = dArray5[0];
        dArray13[31] = dArray5[1];
        dArray13[32] = dArray6[0];
        dArray13[33] = dArray6[1];
        return dArray13;
    }

    public void orderComponentsByDirection(double[][] dArray, int n, int n2, int n3) {
        for (int i = 0; i < n - 1; ++i) {
            int n4 = i * n2 + n3;
            double[] dArray2 = InversionStats.oneDirectionStats(dArray, n4);
            boolean bl = false;
            while (!bl) {
                bl = true;
                for (int j = 0; j < dArray.length; ++j) {
                    double d = Math.abs(dArray2[0] * dArray[j][n4] + dArray2[1] * dArray[j][n4 + 1] + dArray2[2] * dArray[j][n4 + 2]);
                    for (int k = i + 1; k < n; ++k) {
                        int n5 = k * n2 + n3;
                        double d2 = Math.abs(dArray2[0] * dArray[j][n5] + dArray2[1] * dArray[j][n5 + 1] + dArray2[2] * dArray[j][n5 + 2]);
                        if (!(d < d2)) continue;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            double d3 = dArray[j][n4 + i2];
                            dArray[j][n4 + i2] = dArray[j][n5 + i2];
                            dArray[j][n5 + i2] = d3;
                        }
                        d = d2;
                        bl = false;
                    }
                }
                if (bl) continue;
                dArray2 = InversionStats.oneDirectionStats(dArray, n4);
            }
        }
    }

    public static double[] oneDirectionStats(double[][] dArray, int n) {
        int n2;
        double[] dArray2 = new double[3];
        RealMatrix realMatrix = new RealMatrix(3, 3);
        int n3 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[0] = dArray[i][n + 0];
            dArray2[1] = dArray[i][n + 1];
            dArray2[2] = dArray[i][n + 2];
            if (!(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2] > 0.0)) continue;
            ++n3;
            realMatrix = realMatrix.add(InversionStats.dyadic(dArray2));
        }
        if (n3 == 0) {
            return new double[6];
        }
        if (n3 == 1) {
            double[] dArray3 = new double[6];
            dArray3[0] = dArray2[0];
            dArray3[1] = dArray2[1];
            dArray3[2] = dArray2[2];
            dArray3[3] = 1.0;
            return dArray3;
        }
        realMatrix.scale(1.0 / (double)n3);
        RealMatrix[] realMatrixArray = realMatrix.jacobi();
        int n4 = 0;
        int n5 = 0;
        for (n2 = 1; n2 < 3; ++n2) {
            if (realMatrixArray[0].entry(n2, n2) >= realMatrixArray[0].entry(n4, n4)) {
                n4 = n2;
            }
            if (!(realMatrixArray[0].entry(n2, n2) < realMatrixArray[0].entry(n5, n5))) continue;
            n5 = n2;
        }
        n2 = 3 - n5 - n4;
        double[] dArray4 = new double[6];
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = realMatrixArray[1].entry(i, n4);
        }
        dArray4[3] = realMatrixArray[0].entry(n4, n4);
        dArray4[4] = realMatrixArray[0].entry(n2, n2);
        dArray4[5] = realMatrixArray[0].entry(n5, n5);
        return dArray4;
    }

    public static RealMatrix dyadic(double[] dArray) {
        RealMatrix realMatrix = new RealMatrix(dArray.length, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                realMatrix.setEntry(i, j, dArray[i] * dArray[j]);
            }
        }
        return realMatrix;
    }

    public static double[] meanSTDMaxAndMin(double[][] dArray, int n) {
        double[] dArray2 = new double[4];
        if (dArray.length == 0) {
            return dArray2;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = dArray[0][n];
        double d4 = dArray[0][n];
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i][n];
            d2 += dArray[i][n] * dArray[i][n];
            d3 = dArray[i][n] > d3 ? dArray[i][n] : d3;
            d4 = dArray[i][n] < d4 ? dArray[i][n] : d4;
        }
        dArray2[0] = d / (double)dArray.length;
        dArray2[1] = Math.sqrt(d2 / (double)dArray.length - dArray2[0] * dArray2[0]);
        dArray2[2] = d3;
        dArray2[3] = d4;
        return dArray2;
    }
}

