/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.PointSetToScheme;
import data.OutputManager;
import java.io.IOException;
import java.util.Random;
import misc.LoggedException;
import misc.OrderedAcqWeightedMinimizer;
import tools.CL_Initializer;
import tools.FileInput;
import tools.FileOutput;

public class OrderElectrostaticPoints
extends Executable {
    private int numPoints;
    private double temperature;
    private double coolingFactor;
    private int iterations;
    private boolean initFromFile;
    private boolean randomInit;
    private double[][] points;
    private String saveStateRoot;
    private long seed;

    public OrderElectrostaticPoints(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.numPoints = 0;
        this.temperature = -1.0;
        this.coolingFactor = 1.0E-7;
        this.iterations = 1000;
        this.initFromFile = false;
        this.randomInit = false;
        double[][] dArray = null;
        this.saveStateRoot = "OrderElectrostaticPoints";
        this.seed = System.currentTimeMillis();
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-numpoints")) {
                this.numPoints = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-seed")) {
                this.seed = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-coolingfactor")) {
                this.coolingFactor = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-trialsbetweencooling")) {
                this.iterations = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-temperature")) {
                this.temperature = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-savestate")) {
                this.saveStateRoot = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-resume")) {
                this.initFromFile = true;
                FileInput fileInput = new FileInput(stringArray[i + 1]);
                String[] stringArray2 = fileInput.readString().split("\\s");
                this.numPoints = Integer.parseInt(stringArray2[0]);
                if (this.temperature == -1.0) {
                    this.temperature = Double.parseDouble(stringArray2[1]);
                }
                this.points = new double[this.numPoints][3];
                for (int j = 0; j < this.numPoints; ++j) {
                    String[] stringArray3 = fileInput.readString().split("\\s");
                    this.points[j][0] = Double.parseDouble(stringArray3[0]);
                    this.points[j][1] = Double.parseDouble(stringArray3[1]);
                    this.points[j][2] = Double.parseDouble(stringArray3[2]);
                }
                fileInput.close();
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-randominit")) continue;
            this.randomInit = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        if (this.numPoints == 0) {
            this.initFromFile = true;
            try {
                this.points = PointSetToScheme.normalizePoints(PointSetToScheme.readPoints(CL_Initializer.inputFile));
                this.numPoints = this.points.length;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        Random random = new Random(this.seed);
        OrderedAcqWeightedMinimizer orderedAcqWeightedMinimizer = null;
        if (this.initFromFile) {
            orderedAcqWeightedMinimizer = new OrderedAcqWeightedMinimizer(this.points, this.coolingFactor, this.iterations, this.saveStateRoot, random);
            if (this.randomInit) {
                orderedAcqWeightedMinimizer.initializeRandom();
            }
        } else {
            orderedAcqWeightedMinimizer = new OrderedAcqWeightedMinimizer(this.numPoints, this.coolingFactor, this.iterations, this.saveStateRoot, random);
        }
        if (this.temperature < 0.0) {
            orderedAcqWeightedMinimizer.setTemperature(orderedAcqWeightedMinimizer.calibratedTemp(0.7));
        } else {
            orderedAcqWeightedMinimizer.setTemperature(this.temperature);
        }
        orderedAcqWeightedMinimizer.minimize();
        if (OutputManager.outputFile == null) {
            System.out.print(orderedAcqWeightedMinimizer.lowestEnergyState());
        } else {
            FileOutput fileOutput = new FileOutput(OutputManager.outputFile);
            fileOutput.writeString(orderedAcqWeightedMinimizer.lowestEnergyState());
            fileOutput.close();
        }
    }
}

