/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.DataSynthesizer;
import data.GaussianMixture;
import data.ModelPDF;
import data.OutputManager;
import inverters.DT_Inversion;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import numerics.EigenSystem3D;
import numerics.MTRandom;
import numerics.Rotations;
import numerics.SphericalDistributionFitter;
import numerics.Vector3D;
import tools.ArrayOps;
import tools.CL_Initializer;
import tools.FileOutput;

public class OrientationBiasMap
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.OrientationBiasMap");
    private int numSamples;
    private double testFuncFA;
    private double testFuncTr;
    private int thetaStep;
    private int phiStep;
    private String outputRoot;

    public OrientationBiasMap(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.testFuncFA = 0.8;
        this.testFuncTr = 2.1E-9;
        this.numSamples = 500;
        this.thetaStep = 2;
        this.phiStep = 4;
        this.outputRoot = "orientationMap_";
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-samples")) {
                this.numSamples = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-step")) {
                this.thetaStep = Integer.parseInt(stringArray[i + 1]);
                this.phiStep = Integer.parseInt(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
            }
            if (stringArray[i].equals("-fa")) {
                this.testFuncFA = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-trace")) {
                this.testFuncTr = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-outputroot")) continue;
            this.outputRoot = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        if (CL_Initializer.inversionIndices.length > 1) {
            throw new LoggedException("This program fits single DT models only");
        }
        if (CL_Initializer.inversionIndices[0].numDTs > 1) {
            throw new LoggedException("This program fits single DT models only");
        }
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n = 1 + (int)Math.floor((90.0 - (double)this.thetaStep / 2.0) / (double)this.thetaStep);
        int n2 = 1 + (int)Math.floor((360.0 - (double)this.phiStep / 2.0) / (double)this.phiStep);
        double[][] dArray = new double[n][n2];
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        double[][] dArray4 = new double[n][n2];
        double[][] dArray5 = new double[n][n2];
        double[][] dArray6 = new double[n][n2];
        DT dT = this.getTensor(this.testFuncFA, this.testFuncTr);
        DT_Inversion dT_Inversion = DT_Inversion.getIndexedDT_Inversion(CL_Initializer.inversionIndices[0], CL_Initializer.imPars);
        DecimalFormat decimalFormat = new DecimalFormat("0.000E00");
        MTRandom mTRandom = new MTRandom(CL_Initializer.seed);
        for (int i = 0; i < n; ++i) {
            double d = ((double)i + 0.5) * (double)this.thetaStep;
            for (int j = 0; j < n2; ++j) {
                double d2 = ((double)j + 0.5) * (double)this.phiStep;
                Vector3D vector3D = Vector3D.vectorFromSPC(1.0, d * Math.PI / 180.0, d2 * Math.PI / 180.0);
                DT dT2 = Rotations.rotateTensor(dT, vector3D);
                GaussianMixture gaussianMixture = new GaussianMixture(new DT[]{dT2}, new double[]{1.0});
                DataSynthesizer dataSynthesizer = new DataSynthesizer((ModelPDF)gaussianMixture, CL_Initializer.imPars, CL_Initializer.SNR, this.numSamples, mTRandom);
                double[] dArray7 = new double[this.numSamples];
                double[] dArray8 = new double[this.numSamples];
                Vector3D[] vector3DArray = new Vector3D[this.numSamples];
                for (int k = 0; k < this.numSamples; ++k) {
                    double[] dArray9 = dT_Inversion.invert(dataSynthesizer.nextVoxel());
                    DT dT3 = new DT(dArray9[2], dArray9[3], dArray9[4], dArray9[5], dArray9[6], dArray9[7]);
                    dArray7[k] = dT3.fa();
                    dArray8[k] = dT3.trace();
                    double[][] dArray10 = dT3.sortedEigenSystem();
                    vector3DArray[k] = new Vector3D(dArray10[1][0], dArray10[2][0], dArray10[3][0]);
                }
                dArray[i][j] = ArrayOps.mean(dArray7);
                dArray3[i][j] = Math.sqrt(ArrayOps.var(dArray7, dArray[i][j]));
                dArray2[i][j] = ArrayOps.mean(dArray8);
                dArray4[i][j] = Math.sqrt(ArrayOps.var(dArray8, dArray2[i][j]));
                EigenSystem3D eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
                dArray6[i][j] = eigenSystem3D.eigenvalues[0];
                dArray5[i][j] = Math.acos(Math.abs(eigenSystem3D.eigenvectors[0].dot(vector3D))) * 180.0 / Math.PI;
            }
        }
        logger.info("Writing results");
        logger.info("\n    Theta range: (min step max):  " + decimalFormat.format((double)this.thetaStep / 2.0) + " " + decimalFormat.format(this.thetaStep) + " " + decimalFormat.format(((double)n - 0.5) * (double)this.thetaStep) + "\n");
        logger.info("\n    Phi range: (min step max):  " + decimalFormat.format((double)this.phiStep / 2.0) + " " + decimalFormat.format(this.phiStep) + " " + decimalFormat.format(((double)n2 - 0.5) * (double)this.phiStep) + "\n");
        logger.info("\n    Test function FA:  " + decimalFormat.format(this.testFuncFA) + "\n");
        logger.info("\n    Test function Tr:  " + decimalFormat.format(this.testFuncTr) + "\n");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.00000E00");
        this.writeMatrixCSV(dArray, this.outputRoot + "meanfa.csv", decimalFormat2);
        this.writeMatrixCSV(dArray3, this.outputRoot + "stdfa.csv", decimalFormat2);
        this.writeMatrixCSV(dArray2, this.outputRoot + "meantr.csv", decimalFormat2);
        this.writeMatrixCSV(dArray4, this.outputRoot + "stdtr.csv", decimalFormat2);
        this.writeMatrixCSV(dArray6, this.outputRoot + "dyadl1.csv", decimalFormat2);
        this.writeMatrixCSV(dArray5, this.outputRoot + "dyadbias.csv", decimalFormat2);
    }

    protected void writeMatrixCSV(double[][] dArray, String string, DecimalFormat decimalFormat) {
        int n = dArray[0].length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                stringBuffer.append(decimalFormat.format(dArray[i][j]));
                stringBuffer.append(",");
            }
            stringBuffer.append(decimalFormat.format(dArray[i][n - 1]));
            stringBuffer.append("\n");
        }
        FileOutput fileOutput = new FileOutput(string);
        fileOutput.writeString(stringBuffer.toString());
        fileOutput.close();
    }

    protected DT getTensor(double d, double d2) {
        double d3;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Require 0.0 <= FA <= 1.0");
        }
        double d4 = d2;
        double d5 = (-3.0 * d4 + 2.0 * d * d * d4 - 2.0 * Math.sqrt(3.0 * d * d * d4 * d4 - 2.0 * d * d * d * d * d4 * d4)) / (3.0 * (-3.0 + 2.0 * d * d));
        double d6 = d3 = (d4 - d5) / 2.0;
        return new DT(d5, 0.0, 0.0, d3, 0.0, d6);
    }
}

