/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.FileOutput;

public class PointSetToScheme
extends Executable {
    private static final DecimalFormat df = new DecimalFormat("   0.000000;  -0.000000");
    private static final DecimalFormat bValDF = new DecimalFormat("   0.000E00");
    private static final Logger logger = Logger.getLogger("apps.PointSetToScheme");
    private boolean flipX;
    private boolean flipY;
    private boolean flipZ;
    private int M;
    private int numScans;
    private boolean interleave;
    private int bVectorParams;
    private int rectGradST_Params;
    private int rectGradTRSE_Params;
    private boolean useGradMod;
    private double[] dwPars;
    private String schemeVersion;

    public PointSetToScheme(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.flipX = false;
        this.flipY = false;
        this.flipZ = false;
        this.M = 0;
        this.numScans = 1;
        this.interleave = false;
        this.bVectorParams = 1;
        this.rectGradST_Params = 4;
        this.rectGradTRSE_Params = 8;
        this.useGradMod = false;
        double[] dArray = new double[]{};
        this.schemeVersion = "BVECTOR";
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-bvalue")) {
                this.dwPars = new double[1];
                this.dwPars[0] = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-usegradmod")) {
                this.useGradMod = true;
                logger.info("Gradient direction magnitude will be incorporated into b-values");
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-addzeromeas")) {
                this.M = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-flipx")) {
                this.flipX = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipy")) {
                this.flipY = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipz")) {
                this.flipZ = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-numscans")) {
                this.numScans = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-interleave")) {
                this.interleave = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-version")) {
                this.schemeVersion = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-dwparams")) continue;
            int n = 0;
            double[] dArray = new double[100];
            while (i + n + 1 < stringArray.length && !stringArray[i + n + 1].startsWith("-")) {
                dArray[n] = Double.parseDouble(stringArray[i + n + 1]);
                ++n;
            }
            this.dwPars = new double[n];
            System.arraycopy(dArray, 0, this.dwPars, 0, n);
            CL_Initializer.markAsParsed(i, n + 1);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        Locale.setDefault(Locale.UK);
        if (this.useGradMod && !this.schemeVersion.equals("BVECTOR")) {
            throw new LoggedException("Can only use gradient magnitude with BVECTOR scheme version");
        }
        try {
            int n;
            if (CL_Initializer.inputFile == null) {
                logger.info("reading data from standard input");
            }
            double[][] dArray = PointSetToScheme.readPoints(CL_Initializer.inputFile, this.flipX, this.flipY, this.flipZ);
            int n2 = dArray.length;
            double[][] dArray2 = new double[n2 + this.M][3];
            for (n = 0; n < n2; ++n) {
                System.arraycopy(dArray[n], 0, dArray2[n + this.M], 0, 3);
            }
            dArray = dArray2;
            n = dArray.length;
            double[][] dArray3 = new double[this.numScans * n][3];
            if (this.numScans > 1) {
                int n3;
                int n4;
                if (this.interleave) {
                    for (n4 = 0; n4 < n; ++n4) {
                        for (n3 = 0; n3 < this.numScans; ++n3) {
                            System.arraycopy(dArray[n4], 0, dArray3[n4 * this.numScans + n3], 0, 3);
                        }
                    }
                } else {
                    for (n4 = 0; n4 < this.numScans; ++n4) {
                        for (n3 = 0; n3 < n; ++n3) {
                            System.arraycopy(dArray[n3], 0, dArray3[n4 * n + n3], 0, 3);
                        }
                    }
                }
                dArray = dArray3;
            }
            String string = null;
            if (this.schemeVersion.equals("BVECTOR")) {
                if (this.dwPars.length != this.bVectorParams) {
                    throw new LoggedException("Scheme version is " + this.schemeVersion + ", expected " + this.bVectorParams + " param, got " + this.dwPars.length);
                }
                string = PointSetToScheme.pointSetToB_VectorScheme(dArray, this.useGradMod, this.dwPars);
            } else if (this.schemeVersion.equals("STEJSKALTANNER")) {
                if (this.dwPars.length != this.rectGradST_Params) {
                    throw new LoggedException("Scheme version is " + this.schemeVersion + ", expected " + this.rectGradST_Params + " params, got " + this.dwPars.length);
                }
                string = PointSetToScheme.pointSetToRectGradSteTanScheme(dArray, this.dwPars);
            } else if (this.schemeVersion.equals("TRSE")) {
                if (this.dwPars.length != this.rectGradTRSE_Params) {
                    throw new LoggedException("Scheme version is " + this.schemeVersion + ", expected " + this.rectGradTRSE_Params + " params, got " + this.dwPars.length);
                }
                string = PointSetToScheme.pointSetToRectGradTRSE_Scheme(dArray, this.dwPars);
            }
            if (OutputManager.outputFile == null) {
                System.out.print(string);
            } else {
                FileOutput fileOutput = new FileOutput(OutputManager.outputFile);
                fileOutput.writeString(string);
                fileOutput.close();
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public static String pointSetToRectGradSteTanScheme(double[][] dArray, double[] dArray2) {
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = dArray2[3];
        int n = dArray.length;
        double[] dArray3 = PointSetToScheme.getPointModulus(dArray);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!(dArray3[i] > 0.0) || Math.abs(1.0 - dArray3[i]) < 1.0E-5) continue;
            bl = false;
        }
        if (!bl) {
            logger.warning("Some gradient directions do not have unit length. Directions normalized in output.");
        }
        dArray = PointSetToScheme.normalizePoints(dArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#Stejskal-Tanner scheme with rectangular gradient pulses\n");
        stringBuffer.append("#g_x\tg_y\tg_z\t|g|\tDELTA\tdelta\tTE\n");
        stringBuffer.append("VERSION: STEJSKALTANNER");
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(df.format(dArray[i][0]));
            stringBuffer.append(df.format(dArray[i][1]));
            stringBuffer.append(df.format(dArray[i][2]));
            if (dArray[i][0] == 0.0 && dArray[i][1] == 0.0 && dArray[i][2] == 0.0) {
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(d4));
            } else {
                stringBuffer.append(df.format(d));
                stringBuffer.append(df.format(d2));
                stringBuffer.append(df.format(d3));
                stringBuffer.append(df.format(d4));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String pointSetToB_VectorScheme(double[][] dArray, boolean bl, double[] dArray2) {
        double d = dArray2[0];
        int n = dArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#B-vector scheme. Contains gradient directions and b-values\n");
        stringBuffer.append("#g_x\tg_y\tg_z\tb\n");
        stringBuffer.append("VERSION: BVECTOR\n");
        double[] dArray3 = PointSetToScheme.getPointModulus(dArray);
        dArray = PointSetToScheme.normalizePoints(dArray);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(df.format(dArray[i][0]));
            stringBuffer.append(df.format(dArray[i][1]));
            stringBuffer.append(df.format(dArray[i][2]));
            if (dArray[i][0] == 0.0 && dArray[i][1] == 0.0 && dArray[i][2] == 0.0) {
                stringBuffer.append(bValDF.format(0.0));
            } else if (bl) {
                stringBuffer.append(bValDF.format(d * dArray3[i] * dArray3[i]));
            } else {
                stringBuffer.append(bValDF.format(d));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String pointSetToRectGradTRSE_Scheme(double[][] dArray, double[] dArray2) {
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = dArray2[3];
        double d5 = dArray2[4];
        double d6 = dArray2[5];
        double d7 = dArray2[6];
        double d8 = dArray2[7];
        int n = dArray.length;
        double[] dArray3 = PointSetToScheme.getPointModulus(dArray);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!(dArray3[i] > 0.0) || Math.abs(1.0 - dArray3[i]) < 1.0E-5) continue;
            bl = false;
        }
        if (!bl) {
            logger.warning("Some gradient directions do not have unit length. Directions normalized in output.");
        }
        dArray = PointSetToScheme.normalizePoints(dArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#Twice-refocused scheme with rectangular gradient pulses\n");
        stringBuffer.append("#g_x\tg_y\tg_z\t|g|\tt_del1\tdel1\tt_del2\tdel2\tdel3\tt_del4\tTE\n");
        stringBuffer.append("VERSION: TRSE");
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(df.format(dArray[i][0]));
            stringBuffer.append(df.format(dArray[i][1]));
            stringBuffer.append(df.format(dArray[i][2]));
            if (dArray[i][0] == 0.0 && dArray[i][1] == 0.0 && dArray[i][2] == 0.0) {
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(0.0));
                stringBuffer.append(df.format(d8));
            } else {
                stringBuffer.append(df.format(d));
                stringBuffer.append(df.format(d2));
                stringBuffer.append(df.format(d3));
                stringBuffer.append(df.format(d4));
                stringBuffer.append(df.format(d5));
                stringBuffer.append(df.format(d6));
                stringBuffer.append(df.format(d7));
                stringBuffer.append(df.format(d8));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static double[][] readPoints(String string) throws IOException {
        return PointSetToScheme.readPoints(string, false, false, false);
    }

    public static double[][] readPoints(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n;
        int n2;
        Object object;
        Vector<String> vector = new Vector<String>();
        Scanner scanner = null;
        scanner = string == null ? new Scanner(System.in) : new Scanner(new File(string));
        scanner.useDelimiter("\r\n|\n");
        while (scanner.hasNext()) {
            String string2 = scanner.next();
            if (string2.length() <= 0) continue;
            vector.add(string2);
        }
        scanner.close();
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = 0;
        try {
            object = ((String)vector.elementAt(0)).trim().split("\\s+");
            n3 = Integer.parseInt(object[0]);
            if (n3 == (vector.size() - 1) / 3 || n3 == vector.size() - 1) {
                bl4 = true;
            } else {
                if (((String[])object).length != 3) {
                    throw new LoggedException("Unknown point set format");
                }
                n3 = vector.size();
            }
        }
        catch (NumberFormatException numberFormatException) {
            n3 = vector.size();
        }
        if (bl4) {
            try {
                Double.parseDouble(((String)vector.elementAt(1)).trim());
                bl5 = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl5 = false;
            }
        }
        object = new double[n3][3];
        if (bl5) {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    double d = Double.parseDouble((String)vector.elementAt(n2 * 3 + n + 1));
                    object[n2][n] = (String)d;
                }
            }
        } else {
            n2 = bl4 ? 1 : 0;
            for (n = 0; n < n3; ++n) {
                String[] stringArray = ((String)vector.elementAt(n + n2)).trim().split("\\s+");
                if (stringArray.length > 3) {
                    throw new LoggedException("Unknown point set format");
                }
                for (int i = 0; i < 3; ++i) {
                    double d = Double.parseDouble(stringArray[i]);
                    object[n][i] = (String)d;
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (bl && object[n2][0] != 0.0) {
                object[n2][0] = -object[n2][0];
            }
            if (bl2 && object[n2][1] != 0.0) {
                object[n2][1] = -object[n2][1];
            }
            if (!bl3 || object[n2][2] == 0.0) continue;
            object[n2][2] = -object[n2][2];
        }
        return object;
    }

    public static double[] getPointModulus(double[][] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.sqrt(dArray[i][0] * dArray[i][0] + dArray[i][1] * dArray[i][1] + dArray[i][2] * dArray[i][2]);
        }
        return dArray2;
    }

    public static double[][] normalizePoints(double[][] dArray) {
        int n = dArray.length;
        double[][] dArray2 = new double[n][3];
        for (int i = 0; i < n; ++i) {
            double d = Math.sqrt(dArray[i][0] * dArray[i][0] + dArray[i][1] * dArray[i][1] + dArray[i][2] * dArray[i][2]);
            if (Math.abs(1.0 - d) > 1.0E-4 && d > 0.0) {
                dArray[i][0] = dArray[i][0] / d;
                dArray[i][1] = dArray[i][1] / d;
                dArray[i][2] = dArray[i][2] / d;
            }
            for (int j = 0; j < 3; ++j) {
                if (dArray[i][j] != 0.0) continue;
                dArray[i][j] = Math.abs(dArray[i][j]);
            }
        }
        return dArray;
    }
}

