/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.ModelFit;
import data.OutputManager;
import data.VoxelOrderDataSource;
import fitters.FitAlgorithm;
import fitters.FitModel;
import fitters.Fitter;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import imaging.ImageHeader;
import imaging.MetaImageHeader;
import imaging.Nifti1Dataset;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.Vector3D;
import sphfunc.PD;
import tools.CL_Initializer;

public class RGB_ScalarImage {
    public static final int BUFFERSIZE = 0x1000000;
    protected Vector3D[][][][] vectors = null;
    protected double[][][] scalarVol = null;
    protected double[][][] normScalarVol = null;
    protected ImageHeader scalarHeader;
    private double[][][] red = null;
    private double[][][] green = null;
    private double[][][] blue = null;
    private double[][][] alpha = null;
    private boolean haveAlpha = false;
    private static Logger logger = Logger.getLogger("camino.apps.RGB_ScalarImage");
    protected int xDataDim = 0;
    protected int yDataDim = 0;
    protected int zDataDim = 0;
    protected double xVoxelDim = 1.0;
    protected double yVoxelDim = 1.0;
    protected double zVoxelDim = 1.0;
    protected double minScalarValue = 0.0;
    protected double maxScalarValue = 0.0;
    private double gsGamma = 1.0;
    private double rgbGamma = 1.0;

    public RGB_ScalarImage(Vector3D[][][][] vector3DArray, ImageHeader imageHeader, double[][][] dArray, double d, double d2) {
        this.vectors = vector3DArray;
        this.scalarVol = dArray;
        this.scalarHeader = imageHeader;
        this.xDataDim = vector3DArray.length;
        this.yDataDim = vector3DArray[0].length;
        this.zDataDim = vector3DArray[0][0].length;
        this.xVoxelDim = imageHeader.xVoxelDim();
        this.yVoxelDim = imageHeader.yVoxelDim();
        this.zVoxelDim = imageHeader.zVoxelDim();
        this.setNormalizedScalars(d, d2);
        this.calculateRGB();
    }

    public void writeImage(String string) throws IOException {
        logger.info("Saving RGB image as " + string);
        if (string.endsWith(".mha") || string.endsWith(".mhd")) {
            String string2 = string.substring(0, string.length() - 4);
            this.writeMeta(string2);
        } else if (string.endsWith(".vtk")) {
            String string3 = string.substring(0, string.length() - 4);
            this.writeVTK(string3);
        } else if (string.endsWith(".nii") || string.endsWith(".nii.gz")) {
            String string4 = null;
            string4 = string.endsWith(".gz") ? string.substring(0, string.length() - 7) : string.substring(0, string.length() - 4);
            this.writeNifti(string4);
        } else {
            logger.warning("No recognized extension to file " + string + " - image not written");
        }
        logger.info("RGB image saved");
    }

    public void writeNifti(String string) throws IOException {
        Nifti1Dataset nifti1Dataset = null;
        if (this.scalarHeader != null && this.scalarHeader instanceof Nifti1Dataset) {
            nifti1Dataset = (Nifti1Dataset)this.scalarHeader;
        } else {
            nifti1Dataset = new Nifti1Dataset();
            nifti1Dataset.setDims(3, this.xDataDim, this.yDataDim, this.zDataDim, 1, 0, 0, 0);
            nifti1Dataset.setPixDims(1.0, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim, 0.0, 0.0, 0.0, 0.0);
            logger.warning("Header template is not NIfTI, physical space information may be lost");
        }
        int[][][] nArray = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        int[][][] nArray2 = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        int[][][] nArray3 = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    int[] nArray4 = this.rgbTriplet(k, j, i);
                    nArray[k][j][i] = nArray4[0];
                    nArray2[k][j][i] = nArray4[1];
                    nArray3[k][j][i] = nArray4[2];
                }
            }
        }
        if (this.haveAlpha) {
            logger.info("Writing RGBA image, alpha is 1 in foreground and 0 in background");
            Nifti1Dataset nifti1Dataset2 = nifti1Dataset;
            nifti1Dataset2.writeRGBA_Image(nArray, nArray2, nArray3, this.alpha, string);
        } else {
            nifti1Dataset.writeRGB_Image(nArray, nArray2, nArray3, string);
        }
    }

    public void writeMeta(String string) throws IOException {
        MetaImageHeader metaImageHeader = null;
        if (this.scalarHeader != null && this.scalarHeader instanceof MetaImageHeader) {
            metaImageHeader = (MetaImageHeader)this.scalarHeader;
        } else {
            metaImageHeader = new MetaImageHeader();
            metaImageHeader.setDataDims(new int[]{this.xDataDim, this.yDataDim, this.zDataDim});
            metaImageHeader.setVoxelDims(new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim});
            logger.warning("Header template is not Meta, physical space information may be lost");
        }
        int[][][] nArray = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        int[][][] nArray2 = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        int[][][] nArray3 = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    int[] nArray4 = this.rgbTriplet(k, j, i);
                    nArray[k][j][i] = nArray4[0];
                    nArray2[k][j][i] = nArray4[1];
                    nArray3[k][j][i] = nArray4[2];
                }
            }
        }
        metaImageHeader.writeRGB_Image(nArray, nArray2, nArray3, string);
    }

    public void writeVTK(String string) throws IOException {
        String string2 = null;
        string2 = string.endsWith(".vtk") ? string : string + ".vtk";
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string2), 0x1000000));
        dataOutputStream.write(new String("# vtk DataFile Version 2.0\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("Camino RGB-scalar image\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("BINARY\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("DATASET STRUCTURED_POINTS\n").getBytes("US-ASCII"));
        String string3 = "DIMENSIONS " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim + "\n";
        dataOutputStream.write(new String(string3).getBytes("US-ASCII"));
        String string4 = "SPACING " + this.xVoxelDim + " " + this.yVoxelDim + " " + this.zVoxelDim + "\n";
        dataOutputStream.write(string4.getBytes("US-ASCII"));
        dataOutputStream.write(new String("ORIGIN 0 0 0\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("POINT_DATA " + this.xDataDim * this.yDataDim * this.zDataDim + "\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("COLOR_SCALARS scalars 3\n").getBytes("US-ASCII"));
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    int n = this.rgbIndex(k, j, i);
                    dataOutputStream.writeByte((byte)(n >> 16));
                    dataOutputStream.writeByte((byte)(n >> 8 & 0xFF));
                    dataOutputStream.writeByte((byte)(n & 0xFF));
                }
            }
        }
        dataOutputStream.close();
    }

    protected final int rgbIndex(int n, int n2, int n3) {
        double d = Math.pow(this.red[n][n2][n3], this.rgbGamma);
        double d2 = Math.pow(this.green[n][n2][n3], this.rgbGamma);
        double d3 = Math.pow(this.blue[n][n2][n3], this.rgbGamma);
        double d4 = Math.pow(this.normScalarVol[n][n2][n3], this.gsGamma);
        if (!(d4 >= 0.0)) {
            d4 = 0.0;
        }
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n4 = (int)(255.0 * d4 * d);
        n5 = (int)(255.0 * d4 * d2);
        n6 = (int)(255.0 * d4 * d3);
        return n6 + 256 * (n5 + 256 * n4);
    }

    protected final int[] rgbTriplet(int n, int n2, int n3) {
        double d = Math.pow(this.red[n][n2][n3], this.rgbGamma);
        double d2 = Math.pow(this.green[n][n2][n3], this.rgbGamma);
        double d3 = Math.pow(this.blue[n][n2][n3], this.rgbGamma);
        double d4 = Math.pow(this.normScalarVol[n][n2][n3], this.gsGamma);
        if (!(d4 >= 0.0)) {
            d4 = 0.0;
        }
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        return new int[]{(int)(255.0 * d4 * d), (int)(255.0 * d4 * d2), (int)(255.0 * d4 * d3)};
    }

    protected void calculateScalarRange(double d) {
        int n;
        int n2;
        int n3 = 0;
        double[] dArray = new double[this.xDataDim * this.yDataDim * this.zDataDim];
        for (n2 = 0; n2 < this.zDataDim; ++n2) {
            for (n = 0; n < this.yDataDim; ++n) {
                for (int i = 0; i < this.xDataDim; ++i) {
                    dArray[n3++] = this.scalarVol[i][n][n2];
                }
            }
        }
        Arrays.sort(dArray);
        n2 = (int)(d * (double)dArray.length);
        n = dArray.length - n2 - 1;
        this.minScalarValue = dArray[n2];
        this.maxScalarValue = dArray[n];
        if (!(this.maxScalarValue < Double.MAX_VALUE)) {
            while (n >= 0 && !(this.maxScalarValue <= Double.MAX_VALUE)) {
                this.maxScalarValue = dArray[--n];
            }
        }
        if (!(this.minScalarValue > -1.7976931348623157E308)) {
            while (n2 < dArray.length - 1 && !(this.minScalarValue >= -1.7976931348623157E308)) {
                this.minScalarValue = dArray[++n2];
            }
        }
    }

    public void setNormalizedScalars(double d) {
        if (!(d >= 0.0) || !(d < 1.0)) {
            throw new LoggedException("Fraction of scalar values to exclude was : " + d);
        }
        this.calculateScalarRange(d);
        this.setNormalizedScalars();
    }

    public void setNormalizedScalars(double d, double d2) {
        if (d == d2) {
            this.calculateScalarRange(0.005);
        } else {
            this.minScalarValue = d;
            this.maxScalarValue = d2;
        }
        this.setNormalizedScalars();
    }

    private void setNormalizedScalars() {
        this.normScalarVol = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.normScalarVol[k][j][i] = this.scalarVol[k][j][i] < this.minScalarValue ? 0.0 : (this.scalarVol[k][j][i] > this.maxScalarValue ? 1.0 : (this.maxScalarValue - this.minScalarValue != 0.0 ? (this.scalarVol[k][j][i] - this.minScalarValue) / (this.maxScalarValue - this.minScalarValue) : 1.0));
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        Object object;
        CL_Initializer.inputDataType = "double";
        CL_Initializer.maxTensorComponents = 1;
        CL_Initializer.inputModel = "dteig";
        CL_Initializer.numPDsIO = -1;
        CL_Initializer.CL_init(stringArray);
        String string = "bingham";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string2 = null;
        double d6 = 1.0;
        double d7 = 1.0;
        int n6 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-scalarrange")) {
                d4 = Double.parseDouble(stringArray[i + 1]);
                d5 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
            }
            if (stringArray[i].equals("-scalarfile")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-gsgamma")) {
                d6 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-rgbgamma")) {
                d7 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-e1")) {
                n6 = 0;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-e2")) {
                n6 = 1;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-e3")) {
                n6 = 2;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-pdf")) continue;
            string = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        if (CL_Initializer.numPDsIO < 0) {
            CL_Initializer.numPDsIO = CL_Initializer.inputModel.equals("pds") ? 3 : 1;
        }
        if (CL_Initializer.headerTemplateFile == null) {
            CL_Initializer.headerTemplateFile = string2;
        }
        CL_Initializer.initInputSpaceAndHeaderOptions();
        n3 = CL_Initializer.dataDims[0];
        n4 = CL_Initializer.dataDims[1];
        n5 = CL_Initializer.dataDims[2];
        d = CL_Initializer.voxelDims[0];
        d2 = CL_Initializer.voxelDims[1];
        d3 = CL_Initializer.voxelDims[2];
        double[][][] dArray = null;
        ImageHeader imageHeader = CL_Initializer.headerTemplate;
        CL_Initializer.initMaskSource();
        if (string2 != null) {
            object = null;
            if (ImageHeader.imageExists(string2)) {
                ImageHeader imageHeader2 = null;
                try {
                    imageHeader2 = ImageHeader.readHeader(string2);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
                if (!CL_Initializer.headerTemplate.sameSpace(imageHeader2)) {
                    throw new LoggedException("Scalar image space does not match input space");
                }
                object = imageHeader2.getImageDataSource();
            } else {
                object = new VoxelOrderDataSource(string2, 1, CL_Initializer.inputDataType);
            }
            dArray = new double[n3][n4][n5];
            for (n2 = 0; n2 < n5; ++n2) {
                for (int i = 0; i < n4; ++i) {
                    for (n = 0; n < n3; ++n) {
                        dArray[n][i][n2] = object.nextVoxel()[0];
                    }
                }
            }
        }
        object = null;
        if (CL_Initializer.inputModel.equals("dteig")) {
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 12 * CL_Initializer.maxTensorComponents, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromTensorEigenSys(voxelOrderDataSource, CL_Initializer.headerTemplate, dArray, d4, d5, n6);
        } else if (CL_Initializer.inputModel.equals("pds")) {
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 6 + 8 * CL_Initializer.numPDsIO, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromSphFuncPDs(voxelOrderDataSource, CL_Initializer.headerTemplate, dArray, d4, d5);
        } else if (CL_Initializer.inputModel.equals("pico")) {
            n2 = 1;
            if (string.equals("bingham")) {
                n2 = 2;
            }
            if (string.equals("acg")) {
                n2 = 3;
            }
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 1 + (10 + n2) * CL_Initializer.numPDsIO, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromPICoPDFs(voxelOrderDataSource, CL_Initializer.numPDsIO, n2, CL_Initializer.headerTemplate, dArray, d4, d5);
        } else if (CL_Initializer.inputModel.equals("ballstick")) {
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 7, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromBallStick(voxelOrderDataSource, CL_Initializer.headerTemplate, dArray, d4, d5);
        } else {
            throw new LoggedException("Unrecognized input model " + CL_Initializer.inputModel);
        }
        ((RGB_ScalarImage)object).setScalarGamma(d6);
        ((RGB_ScalarImage)object).setRGB_Gamma(d7);
        if (CL_Initializer.bgMask != null) {
            ((RGB_ScalarImage)object).haveAlpha = true;
            ((RGB_ScalarImage)object).alpha = new double[n3][n4][n5];
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (n = 0; n < n3; ++n) {
                        ((RGB_ScalarImage)object).alpha[n][j][i] = CL_Initializer.bgMask.nextVoxel()[0] > 0.0 ? 1.0 : 0.0;
                    }
                }
            }
        }
        try {
            ((RGB_ScalarImage)object).writeImage(OutputManager.outputFile);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    protected void calculateRGB() {
        if (this.red == null) {
            this.red = new double[this.xDataDim][this.yDataDim][this.zDataDim];
            this.green = new double[this.xDataDim][this.yDataDim][this.zDataDim];
            this.blue = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        }
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    double d = Math.abs(this.vectors[k][j][i][0].x);
                    double d2 = Math.abs(this.vectors[k][j][i][0].y);
                    double d3 = Math.abs(this.vectors[k][j][i][0].z);
                    if (this.vectors[k][j][i].length > 1) {
                        Vector3D vector3D = new Vector3D(Math.abs(this.vectors[k][j][i][0].x) + Math.abs(this.vectors[k][j][i][1].x), Math.abs(this.vectors[k][j][i][0].y) + Math.abs(this.vectors[k][j][i][1].y), Math.abs(this.vectors[k][j][i][0].z) + Math.abs(this.vectors[k][j][i][1].z)).normalized();
                        d = vector3D.x;
                        d2 = vector3D.y;
                        d3 = vector3D.z;
                    }
                    this.red[k][j][i] = d;
                    this.green[k][j][i] = d2;
                    this.blue[k][j][i] = d3;
                }
            }
        }
    }

    public static RGB_ScalarImage imageFromSphFuncPDs(VoxelOrderDataSource voxelOrderDataSource, ImageHeader imageHeader, double[][][] dArray, double d, double d2) {
        int n = imageHeader.xDataDim();
        int n2 = imageHeader.yDataDim();
        int n3 = imageHeader.zDataDim();
        double[][][] dArray2 = new double[n][n2][n3];
        Vector3D[][][][] vector3DArray = new Vector3D[n][n2][n3][];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    double[] dArray3 = voxelOrderDataSource.nextVoxel();
                    Vector3D vector3D = null;
                    Vector3D vector3D2 = null;
                    vector3D = new Vector3D(dArray3[6], dArray3[7], dArray3[8]);
                    dArray2[k][j][i] = Math.abs(dArray3[10] + dArray3[13]);
                    if (!(dArray2[k][j][i] > 0.0)) {
                        dArray2[k][j][i] = 0.0;
                    }
                    if (dArray3[2] >= 2.0) {
                        vector3D2 = new Vector3D(dArray3[14], dArray3[15], dArray3[16]);
                    }
                    vector3DArray[k][j][i] = vector3D2 == null ? new Vector3D[]{vector3D} : new Vector3D[]{vector3D, vector3D2};
                }
            }
        }
        if (dArray == null) {
            dArray = dArray2;
        }
        return new RGB_ScalarImage(vector3DArray, imageHeader, dArray, d, d2);
    }

    public static RGB_ScalarImage imageFromPICoPDFs(VoxelOrderDataSource voxelOrderDataSource, int n, int n2, ImageHeader imageHeader, double[][][] dArray, double d, double d2) {
        return RGB_ScalarImage.imageFromPICoPDFs(voxelOrderDataSource, n, n2, imageHeader, dArray, d, d2, 0);
    }

    public static RGB_ScalarImage imageFromPICoPDFs(VoxelOrderDataSource voxelOrderDataSource, int n, int n2, ImageHeader imageHeader, double[][][] dArray, double d, double d2, int n3) {
        int n4 = imageHeader.xDataDim();
        int n5 = imageHeader.yDataDim();
        int n6 = imageHeader.zDataDim();
        Vector3D[][][][] vector3DArray = new Vector3D[n4][n5][n6][];
        double[][][] dArray2 = new double[n4][n5][n6];
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n4; ++k) {
                    int n7;
                    double[] dArray3 = voxelOrderDataSource.nextVoxel();
                    int n8 = (int)dArray3[0];
                    Vector3D vector3D = new Vector3D(dArray3[2 + 3 * n3], dArray3[3 + 3 * n3], dArray3[4 + 3 * n3]);
                    Vector3D vector3D2 = null;
                    for (n7 = 0; n7 < n2; ++n7) {
                        double[] dArray4 = dArray2[k][j];
                        int n9 = i;
                        dArray4[n9] = dArray4[n9] + Math.abs(dArray3[11 + n7]);
                    }
                    if (n8 >= 2) {
                        n7 = 11 + n2;
                        vector3D2 = new Vector3D(dArray3[n7 + 1 + 3 * n3], dArray3[n7 + 2 + 3 * n3], dArray3[n7 + 3 + 3 * n3]);
                        double d3 = 0.0;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            d3 += Math.abs(dArray3[n7 + 10 + i2]);
                        }
                        dArray2[k][j][i] = (dArray2[k][j][i] + d3) / 2.0;
                    }
                    vector3DArray[k][j][i] = vector3D2 == null ? new Vector3D[]{vector3D} : new Vector3D[]{vector3D, vector3D2};
                }
            }
        }
        if (dArray == null) {
            dArray = dArray2;
        }
        return new RGB_ScalarImage(vector3DArray, imageHeader, dArray, d, d2);
    }

    public static RGB_ScalarImage imageFromBallStick(VoxelOrderDataSource voxelOrderDataSource, ImageHeader imageHeader, double[][][] dArray, double d, double d2) {
        int n = imageHeader.xDataDim();
        int n2 = imageHeader.yDataDim();
        int n3 = imageHeader.zDataDim();
        double[][][] dArray2 = new double[n][n2][n3];
        Vector3D[][][][] vector3DArray = new Vector3D[n][n2][n3][];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    double[] dArray3 = voxelOrderDataSource.nextVoxel();
                    Object var16_14 = null;
                    vector3DArray[k][j][i] = new Vector3D[]{new Vector3D(dArray3[4], dArray3[5], dArray3[6])};
                    dArray2[k][j][i] = Math.abs(dArray3[3]);
                    if (dArray2[k][j][i] >= 0.0) continue;
                    dArray2[k][j][i] = 0.0;
                }
            }
        }
        if (dArray == null) {
            dArray = dArray2;
        }
        return new RGB_ScalarImage(vector3DArray, imageHeader, dArray, d, d2);
    }

    public static RGB_ScalarImage imageFromCompartmentModel(ImageHeader imageHeader, double[][][] dArray, double d, double d2) {
        FitModel fitModel = FitModel.getFitModel(CL_Initializer.fitModel);
        if (CL_Initializer.imPars == null) {
            CL_Initializer.imPars = DW_Scheme.nullScheme();
        }
        Fitter fitter = ModelFit.getFitter(fitModel, NoiseModel.GAUSSIAN, FitAlgorithm.LM);
        int n = fitter.getNumValuesPerRun();
        int n2 = fitter.getDirectionIndex();
        if (n2 == 0) {
            logger.warning("Direction index is zero: suggests the model contains no orientational information.");
        }
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, n, CL_Initializer.inputDataType);
        int n3 = imageHeader.xDataDim();
        int n4 = imageHeader.yDataDim();
        int n5 = imageHeader.zDataDim();
        double[][][] dArray2 = new double[n3][n4][n5];
        Vector3D[][][][] vector3DArray = new Vector3D[n3][n4][n5][];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n3; ++k) {
                    double[] dArray3 = voxelOrderDataSource.nextVoxel();
                    Object var20_18 = null;
                    PD pD = new PD(dArray3[n2], dArray3[n2 + 1], 1.0);
                    vector3DArray[k][j][i] = new Vector3D[]{new Vector3D(pD.getPDX(), pD.getPDY(), pD.getPDZ())};
                    dArray2[k][j][i] = Math.abs(dArray3[2]);
                    if (dArray2[k][j][i] >= 0.0) continue;
                    dArray2[k][j][i] = 0.0;
                }
            }
        }
        if (dArray == null) {
            dArray = dArray2;
        }
        return new RGB_ScalarImage(vector3DArray, imageHeader, dArray, d, d2);
    }

    public static RGB_ScalarImage imageFromTensorEigenSys(VoxelOrderDataSource voxelOrderDataSource, ImageHeader imageHeader, double[][][] dArray, double d, double d2) {
        return RGB_ScalarImage.imageFromTensorEigenSys(voxelOrderDataSource, imageHeader, dArray, d, d2, 0);
    }

    public static RGB_ScalarImage imageFromTensorEigenSys(VoxelOrderDataSource voxelOrderDataSource, ImageHeader imageHeader, double[][][] dArray, double d, double d2, int n) {
        int n2 = imageHeader.xDataDim();
        int n3 = imageHeader.yDataDim();
        int n4 = imageHeader.zDataDim();
        Vector3D[][][][] vector3DArray = new Vector3D[n2][n3][n4][];
        double[][][] dArray2 = new double[n2][n3][n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double[] dArray3 = voxelOrderDataSource.nextVoxel();
                    Vector3D vector3D = null;
                    switch (n) {
                        case 0: {
                            vector3D = new Vector3D(dArray3[1], dArray3[2], dArray3[3]);
                            break;
                        }
                        case 1: {
                            vector3D = new Vector3D(dArray3[5], dArray3[6], dArray3[7]);
                            break;
                        }
                        case 2: {
                            vector3D = new Vector3D(dArray3[9], dArray3[10], dArray3[11]);
                            break;
                        }
                        default: {
                            throw new LoggedException("Invalid eigenvector index " + n);
                        }
                    }
                    Vector3D vector3D2 = null;
                    double d3 = (dArray3[0] + dArray3[4] + dArray3[8]) / 3.0;
                    if (d3 > 0.0) {
                        dArray2[k][j][i] = Math.sqrt(1.5 * ((dArray3[0] - d3) * (dArray3[0] - d3) + (dArray3[4] - d3) * (dArray3[4] - d3) + (dArray3[8] - d3) * (dArray3[8] - d3)) / (dArray3[0] * dArray3[0] + dArray3[4] * dArray3[4] + dArray3[8] * dArray3[8]));
                    }
                    if (!(dArray2[k][j][i] >= 0.0) || !(dArray2[k][j][i] < 1.0)) {
                        if (dArray2[k][j][i] < 0.0) {
                            dArray2[k][j][i] = 0.0;
                        } else if (dArray2[k][j][i] > 1.0) {
                            dArray2[k][j][i] = 1.0;
                        }
                    }
                    if (dArray3.length > 12 && (d3 = (dArray3[12] + dArray3[16] + dArray3[20]) / 3.0) > 0.0) {
                        switch (n) {
                            case 0: {
                                vector3D2 = new Vector3D(dArray3[13], dArray3[14], dArray3[15]);
                                break;
                            }
                            case 1: {
                                vector3D2 = new Vector3D(dArray3[17], dArray3[18], dArray3[19]);
                                break;
                            }
                            case 2: {
                                vector3D2 = new Vector3D(dArray3[21], dArray3[22], dArray3[23]);
                                break;
                            }
                            default: {
                                throw new LoggedException("Invalid eigenvector index " + n);
                            }
                        }
                        double d4 = Math.sqrt(1.5 * ((dArray3[12] - d3) * (dArray3[12] - d3) + (dArray3[16] - d3) * (dArray3[16] - d3) + (dArray3[20] - d3) * (dArray3[20] - d3)) / (dArray3[12] * dArray3[12] + dArray3[16] * dArray3[16] + dArray3[20] * dArray3[20]));
                        if (d4 < 0.0) {
                            d4 = 0.0;
                        } else if (d4 > 1.0) {
                            d4 = 1.0;
                        }
                        dArray2[k][j][i] = (dArray2[k][j][i] + d4) / 2.0;
                    }
                    vector3DArray[k][j][i] = vector3D2 == null ? new Vector3D[]{vector3D} : new Vector3D[]{vector3D, vector3D2};
                }
            }
        }
        if (dArray == null) {
            dArray = dArray2;
        }
        return new RGB_ScalarImage(vector3DArray, imageHeader, dArray, d, d2);
    }

    public void setRGB_Gamma(double d) {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException("Cannot use gamma value " + d);
        }
        this.rgbGamma = d;
    }

    public double rgbGamma() {
        return this.rgbGamma;
    }

    public void setScalarGamma(double d) {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException("Cannot use gamma value " + d);
        }
        this.gsGamma = d;
    }

    public double scalarGamma() {
        return this.gsGamma;
    }

    public double[] getVoxelDims() {
        return new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim};
    }
}

