/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.ExternalDataSource;
import data.OutputManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import misc.LoggedException;

public class Shredder
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.Shredder");
    public static int FILEBUFFERSIZE;
    public static DataInputStream in;
    public static DataOutputStream out;
    private static int skipChunkSize;
    private static byte[] skipChunk;
    private int offset;
    private int chunkSize;
    private int space;
    private byte[] chunk;
    private boolean reverse;

    public Shredder(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        FILEBUFFERSIZE = ExternalDataSource.FILEBUFFERSIZE;
        in = new DataInputStream(new BufferedInputStream(System.in, FILEBUFFERSIZE));
        out = new DataOutputStream(new BufferedOutputStream(System.out, FILEBUFFERSIZE));
        skipChunkSize = FILEBUFFERSIZE;
        skipChunk = null;
    }

    @Override
    public void initOptions(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("Usage: java Shredder <offset> <chunk size> <space>.\n\n");
            System.exit(0);
        }
        this.offset = Integer.parseInt(stringArray[0]);
        this.chunkSize = Integer.parseInt(stringArray[1]);
        this.space = Integer.parseInt(stringArray[2]);
    }

    @Override
    public void initVariables() {
        skipChunk = new byte[skipChunkSize];
        this.reverse = false;
        if (this.chunkSize < 0) {
            this.reverse = true;
            this.chunkSize = -this.chunkSize;
        }
        this.chunk = new byte[this.chunkSize];
    }

    @Override
    public void execute(OutputManager outputManager) {
        if (this.chunkSize == 0) {
            throw new LoggedException("Can't read zero byte chunks");
        }
        if (!Shredder.skip(this.offset)) {
            throw new LoggedException("Could not skip initial offset of " + this.offset + " bytes");
        }
        while (Shredder.getChunk(this.chunk)) {
            if (this.reverse) {
                Shredder.arrFlip(this.chunk);
            }
            Shredder.output(this.chunk);
            if (Shredder.skip(this.space)) continue;
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
    }

    public static boolean getChunk(byte[] byArray) {
        int n;
        try {
            int n2;
            for (n = 0; n < byArray.length && (n2 = in.read(byArray, n, byArray.length - n)) != -1; n += n2) {
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        return n > 0;
    }

    public static boolean skip(int n) {
        if (n == 0) {
            return true;
        }
        if (skipChunkSize == 0) {
            throw new LoggedException("Internal error: skip chunk size is zero!");
        }
        int n2 = n / skipChunkSize;
        int n3 = n % skipChunkSize;
        int n4 = 0;
        try {
            int n5;
            int n6;
            for (n6 = 0; n6 < n2; ++n6) {
                int n7;
                for (n5 = 0; n5 < skipChunkSize; n5 += n7) {
                    n7 = in.read(skipChunk, n5, skipChunkSize - n5);
                    if (n7 != -1) continue;
                    return false;
                }
                n4 += n5;
            }
            for (n6 = 0; n6 < n3; n6 += n5) {
                n5 = in.read(skipChunk, n6, n3 - n6);
                if (n5 != -1) continue;
                return false;
            }
            if ((n4 += n6) == n) {
                return true;
            }
            throw new LoggedException("Needed to skip " + n + " bytes, but skipped " + n4);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public static void output(byte[] byArray) {
        try {
            out.write(byArray);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public static void arrFlip(byte[] byArray) {
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[byArray.length - i - 1];
            byArray[byArray.length - i - 1] = by;
        }
    }
}

