/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.VoxelOrderDataSource;
import java.io.DataOutputStream;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import misc.SphericalPoints;
import sphfunc.EvenSHS;
import sphfunc.ISCodes;
import sphfunc.MaxEntProfile;
import sphfunc.SphericalFunction;
import sphfunc.SphericalPointSet;
import sphfunc.TuchRBF_Sum;
import tools.CL_Initializer;

public class SphFuncBitMap
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.SphFuncBitMap");
    public static int BUFFERSIZE;
    private static int miniFigSizeX;
    private static int miniFigSizeY;
    private static int miniFigSeparationX;
    private static int miniFigSeparationY;
    private static int pixelsPerVoxelX;
    private static int pixelsPerVoxelY;
    private static int ORIENTATION;
    private static int[] PROJ;
    private static int[] COLCODE;
    private static int pointSetInd;
    private static double maxD;
    private static double powerScale;
    private static int xSize;
    private static int ySize;
    private static char[][][] imArray;
    private static char[] col;
    private static boolean colCodeDirections;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;
    private int interval;
    private boolean smallPointSet;
    private boolean minmaxnorm;
    private boolean grayscale;
    private String backDropFile;
    private String backInterp;

    public SphFuncBitMap(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        BUFFERSIZE = 1000000;
        miniFigSizeX = 15;
        miniFigSizeY = 15;
        miniFigSeparationX = 1;
        miniFigSeparationY = 1;
        ORIENTATION = 0;
        int[] nArray = new int[]{2, 1, 3};
        pointSetInd = 0;
        maxD = 1.5E-9;
        powerScale = 1.0;
        xSize = 128;
        ySize = 128;
        char[] cArray = new char[]{'\u00ff', '\u00ff', '\u00ff'};
        pixelsPerVoxelX = miniFigSizeX + miniFigSeparationX;
        pixelsPerVoxelY = miniFigSizeY + miniFigSeparationY;
        this.xMin = -1;
        this.xMax = -1;
        this.yMin = -1;
        this.yMax = -1;
        this.interval = 1;
        this.smallPointSet = false;
        this.minmaxnorm = false;
        this.grayscale = true;
        this.backDropFile = null;
        this.backInterp = "bilinear";
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        if (CL_Initializer.schemeFile != null) {
            CL_Initializer.initImagingScheme();
        }
        if (CL_Initializer.inputModel.equals("maxent")) {
            if (CL_Initializer.mePointSet < 0 && CL_Initializer.schemeFile == null) {
                throw new LoggedException("Maximum entropy control points must be specified by a schemefile or -mepointset");
            }
            CL_Initializer.initMaxEnt();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-pointset")) {
                pointSetInd = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-orientation")) {
                ORIENTATION = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-projection")) {
                SphFuncBitMap.PROJ[0] = Integer.parseInt(stringArray[i + 1]);
                SphFuncBitMap.PROJ[1] = Integer.parseInt(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
                CL_Initializer.markAsParsed(i + 2);
            }
            if (stringArray[i].equals("-colcode")) {
                SphFuncBitMap.COLCODE[0] = Integer.parseInt(stringArray[i + 1]);
                SphFuncBitMap.COLCODE[1] = Integer.parseInt(stringArray[i + 2]);
                SphFuncBitMap.COLCODE[2] = Integer.parseInt(stringArray[i + 3]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
                CL_Initializer.markAsParsed(i + 2);
                CL_Initializer.markAsParsed(i + 3);
            }
            if (stringArray[i].equals("-xsize")) {
                xSize = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-ysize")) {
                ySize = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-minifigsize")) {
                miniFigSizeX = Integer.parseInt(stringArray[i + 1]);
                miniFigSizeY = Integer.parseInt(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
                CL_Initializer.markAsParsed(i + 2);
            }
            if (stringArray[i].equals("-minifigseparation")) {
                miniFigSeparationX = Integer.parseInt(stringArray[i + 1]);
                miniFigSeparationY = Integer.parseInt(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
                CL_Initializer.markAsParsed(i + 2);
            }
            if (stringArray[i].equals("-box")) {
                this.xMin = Integer.parseInt(stringArray[i + 1]);
                this.xMax = Integer.parseInt(stringArray[i + 2]);
                this.yMin = Integer.parseInt(stringArray[i + 3]);
                this.yMax = Integer.parseInt(stringArray[i + 4]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
                CL_Initializer.markAsParsed(i + 2);
                CL_Initializer.markAsParsed(i + 3);
                CL_Initializer.markAsParsed(i + 4);
            }
            if (stringArray[i].equals("-coarse")) {
                this.smallPointSet = true;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-minmaxnorm")) {
                this.minmaxnorm = true;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-iconcol")) {
                SphFuncBitMap.col[0] = (char)Integer.parseInt(stringArray[i + 1]);
                SphFuncBitMap.col[1] = (char)Integer.parseInt(stringArray[i + 2]);
                SphFuncBitMap.col[2] = (char)Integer.parseInt(stringArray[i + 3]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
                CL_Initializer.markAsParsed(i + 2);
                CL_Initializer.markAsParsed(i + 3);
                this.grayscale = false;
            }
            if (stringArray[i].equals("-dircolcode")) {
                colCodeDirections = true;
                this.grayscale = false;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-backdrop")) {
                this.backDropFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-backdropinterp")) {
                this.backInterp = stringArray[i + 1];
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-maxd")) {
                maxD = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (stringArray[i].equals("-powerscale")) {
                powerScale = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (!stringArray[i].equals("-interval")) continue;
            this.interval = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i);
            CL_Initializer.markAsParsed(i + 1);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        if (CL_Initializer.inputModel.equals("dt") || CL_Initializer.inputModel.equals("twotensor") || CL_Initializer.inputModel.equals("threetensor") || CL_Initializer.inputModel.equals("multitensor")) {
            CL_Initializer.initTensorDataSource();
        } else {
            CL_Initializer.initSphFuncDataSource();
        }
        if (this.xMax <= 0 || this.xMax > xSize - 1) {
            this.xMax = xSize - 1;
        }
        if (this.yMax <= 0 || this.yMax > ySize - 1) {
            this.yMax = ySize - 1;
        }
        if (this.xMin <= 0 || this.xMin > xSize) {
            this.xMin = 0;
        }
        if (this.yMin <= 0 || this.yMin > ySize) {
            this.yMin = 0;
        }
        pixelsPerVoxelX = miniFigSizeX + miniFigSeparationX;
        pixelsPerVoxelY = miniFigSizeY + miniFigSeparationY;
        int n = (this.xMax + 1 - this.xMin) / this.interval;
        int n2 = (this.yMax + 1 - this.yMin) / this.interval;
        int n3 = n * pixelsPerVoxelX;
        int n4 = n2 * pixelsPerVoxelY;
        imArray = new char[n3][n4][3];
    }

    @Override
    public void execute(OutputManager outputManager) {
        SphericalPointSet[] sphericalPointSetArray;
        if (this.backDropFile != null) {
            sphericalPointSetArray = (SphericalPointSet[])SphFuncBitMap.readBackDrop(this.backDropFile, xSize, ySize);
            SphFuncBitMap.initOutputArray((char[][])sphericalPointSetArray, this.interval, this.xMax, this.yMin, pixelsPerVoxelX, pixelsPerVoxelY, this.backInterp);
        }
        try {
            int n;
            sphericalPointSetArray = new SphericalPointSet[ISCodes.getNoPointSetsForMaxEnt()];
            for (n = 0; n < sphericalPointSetArray.length; ++n) {
                sphericalPointSetArray[n] = ISCodes.getPointSetForMaxEnt(n);
            }
            for (n = 0; n < xSize; ++n) {
                for (int i = 0; i < ySize; ++i) {
                    double d;
                    double d2;
                    Object object;
                    double[] dArray = CL_Initializer.data.nextVoxel();
                    if (!(dArray[0] >= 0.0)) continue;
                    SphericalFunction sphericalFunction = null;
                    DT[] dTArray = null;
                    if (CL_Initializer.inputModel.equals("sh")) {
                        sphericalFunction = new EvenSHS(dArray, CL_Initializer.maxOrder);
                    } else if (CL_Initializer.inputModel.equals("dt")) {
                        object = new DT(dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
                        dTArray = new DT[]{object};
                    } else if (CL_Initializer.inputModel.equals("twotensor")) {
                        dTArray = new DT[2];
                        double d3 = dArray[3] > dArray[10] ? dArray[3] : dArray[10];
                        d2 = dArray[3] / d3;
                        d = dArray[10] / d3;
                        dTArray[0] = new DT(d2 * dArray[4], d2 * dArray[5], d2 * dArray[6], d2 * dArray[7], d2 * dArray[8], d2 * dArray[9]);
                        dTArray[1] = new DT(d * dArray[11], d * dArray[12], d * dArray[13], d * dArray[14], d * dArray[15], d * dArray[16]);
                    } else if (CL_Initializer.inputModel.equals("threetensor")) {
                        dTArray = new DT[3];
                        double d4 = dArray[3];
                        if (dArray[10] > d4) {
                            d4 = dArray[10];
                        }
                        if (dArray[17] > d4) {
                            d4 = dArray[17];
                        }
                        d2 = dArray[3] / d4;
                        d = dArray[10] / d4;
                        double d5 = dArray[17] / d4;
                        dTArray[0] = new DT(d2 * dArray[4], d2 * dArray[5], d2 * dArray[6], d2 * dArray[7], d2 * dArray[8], d2 * dArray[9]);
                        dTArray[1] = new DT(d * dArray[11], d * dArray[12], d * dArray[13], d * dArray[14], d * dArray[15], d * dArray[16]);
                        dTArray[2] = new DT(d5 * dArray[18], d5 * dArray[19], d5 * dArray[20], d5 * dArray[21], d5 * dArray[22], d5 * dArray[23]);
                    } else if (CL_Initializer.inputModel.equals("multitensor")) {
                        int n2;
                        dTArray = new DT[(int)dArray[2]];
                        object = new double[(int)dArray[2]];
                        Object object2 = dArray[3];
                        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                            object[n2] = dArray[3 + 7 * n2];
                            if (!(object[n2] > object2)) continue;
                            object2 = object[n2];
                        }
                        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                            object[n2] = object[n2] / object2;
                        }
                        for (n2 = 0; n2 < dTArray.length; ++n2) {
                            dTArray[n2] = new DT((double)(object[n2] * dArray[4 + 7 * n2]), (double)(object[n2] * dArray[5 + 7 * n2]), (double)(object[n2] * dArray[6 + 7 * n2]), (double)(object[n2] * dArray[7 + 7 * n2]), (double)(object[n2] * dArray[8 + 7 * n2]), (double)(object[n2] * dArray[9 + 7 * n2]));
                        }
                    } else {
                        sphericalFunction = CL_Initializer.inputModel.equals("maxent") ? new MaxEntProfile(dArray, CL_Initializer.kernelParams) : new TuchRBF_Sum(dArray);
                    }
                    if (n < this.xMin || i < this.yMin || n > this.xMax || i > this.yMax || n % this.interval != 0 || i % this.interval != 0) continue;
                    object = SphFuncBitMap.getPointSet(this.smallPointSet, sphericalPointSetArray);
                    char[][][] cArray = CL_Initializer.inputModel.equals("dt") || CL_Initializer.inputModel.equals("twotensor") || CL_Initializer.inputModel.equals("threetensor") || CL_Initializer.inputModel.equals("multitensor") ? SphFuncBitMap.getMiniFigXY_DTs(dTArray, (double[][])object) : SphFuncBitMap.getMiniFigXY(sphericalFunction, (double[][])object, this.minmaxnorm);
                    SphFuncBitMap.addMiniFig((n - this.xMin) / this.interval, (i - this.yMin) / this.interval, cArray);
                }
            }
        }
        catch (Exception exception) {
            LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
        }
        System.err.println("Image size: " + imArray[0].length + "x" + imArray.length);
        SphFuncBitMap.outputBitMap(outputManager.getOutputStream(), this.grayscale);
        outputManager.close();
    }

    private static char[][] readBackDrop(String string, int n, int n2) {
        int n3;
        logger.info("Loading " + string + ".  Expecting type " + CL_Initializer.inputDataType + ".");
        double[][] dArray = new double[n][n2];
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, 1, CL_Initializer.inputDataType);
        double d = 0.0;
        double d2 = 0.0;
        block2: for (int i = 0; i < n; ++i) {
            for (n3 = 0; n3 < n2; ++n3) {
                try {
                    dArray[i][n3] = voxelOrderDataSource.nextVoxel()[0];
                    double d3 = i == 0 ? dArray[i][n3] : (d = dArray[i][n3] > d ? dArray[i][n3] : d);
                    d2 = i == 0 ? dArray[i][n3] : (dArray[i][n3] < d2 ? dArray[i][n3] : d2);
                    continue;
                }
                catch (Exception exception) {
                    logger.warning("Backdrop image smaller than expected.  Continuing...");
                    continue block2;
                }
            }
        }
        char[][] cArray = new char[n][n2];
        if (d > d2) {
            for (n3 = 0; n3 < n; ++n3) {
                for (int i = 0; i < n2; ++i) {
                    cArray[n3][i] = (char)(255.0 * (dArray[n3][i] - d2) / (d - d2));
                }
            }
        }
        return cArray;
    }

    private static void initOutputArray(char[][] cArray, int n, int n2, int n3, int n4, int n5, String string) {
        for (int i = 0; i < imArray.length; ++i) {
            for (int j = 0; j < imArray[0].length; ++j) {
                int n6;
                double d = (double)n2 - (double)((i + n4 / 2) * n) / (double)n4 + 1.0;
                double d2 = (double)((j - n5 / 2) * n) / (double)n5 + (double)n3;
                if (string.equals("nn")) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        SphFuncBitMap.imArray[i][j][n6] = cArray[(int)d][(int)d2];
                    }
                    continue;
                }
                n6 = (int)d;
                int n7 = (int)d2;
                int n8 = n6 + 1 < cArray.length ? n6 + 1 : n6;
                int n9 = n7 + 1 < cArray[0].length ? n7 + 1 : n7;
                double d3 = d - (double)n6;
                double d4 = d2 - (double)n7;
                double d5 = (1.0 - d3) * (1.0 - d4) * (double)cArray[n6][n7] + d3 * (1.0 - d4) * (double)cArray[n8][n7] + (1.0 - d3) * d4 * (double)cArray[n6][n9] + d3 * d4 * (double)cArray[n8][n9];
                for (int k = 0; k < 3; ++k) {
                    SphFuncBitMap.imArray[i][j][k] = (char)d5;
                }
            }
        }
    }

    private static double[][] getPointSet(boolean bl, SphericalPointSet[] sphericalPointSetArray) {
        double[][] dArray = sphericalPointSetArray[SphFuncBitMap.pointSetInd].data;
        if (bl) {
            dArray = SphericalPoints.getElecPointSet(120);
        }
        return dArray;
    }

    private static char[][][] getMiniFigXY(SphericalFunction sphericalFunction, double[][] dArray, boolean bl) {
        int n;
        char[][][] cArray = new char[miniFigSizeX][miniFigSizeY][3];
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = sphericalFunction.getRadius(dArray[n][0], dArray[n][1], dArray[n][2]);
            if (powerScale != 1.0) {
                dArray2[n] = Math.pow(dArray2[n], powerScale);
            }
            double d3 = d = dArray2[n] > d ? dArray2[n] : d;
            d2 = n == 0 ? dArray2[n] : (dArray2[n] < d2 ? dArray2[n] : d2);
        }
        d2 = d2 < 0.0 ? 0.0 : d2;
        for (n = 0; n < dArray.length; ++n) {
            double d4 = dArray2[n] / d;
            if (bl) {
                double d5 = d4 = d > d2 ? (dArray2[n] - d2) / (d - d2) : 0.0;
            }
            if (d4 > 0.0) {
                double d6 = dArray[n][0] * d4;
                double d7 = dArray[n][1] * d4;
                double d8 = dArray[n][2] * d4;
                SphFuncBitMap.addPointToMiniFig(d7, d6, d8, cArray);
                continue;
            }
            if (!(d4 < 0.0)) continue;
            logger.info("Radius less than zero.  Ignoring.");
        }
        return cArray;
    }

    private static char[][][] getMiniFigXY_DTs(DT[] dTArray, double[][] dArray) {
        char[][][] cArray = new char[miniFigSizeX][miniFigSizeY][3];
        for (int i = 0; i < dTArray.length; ++i) {
            int n;
            DT dT = dTArray[i];
            double[][] dArray2 = new double[dArray.length][3];
            for (n = 0; n < dArray.length; ++n) {
                dArray2[n] = dT.multiply(dArray[n]);
            }
            for (n = 0; n < dArray.length; ++n) {
                double d = dArray2[n][0] / maxD;
                double d2 = dArray2[n][1] / maxD;
                double d3 = dArray2[n][2] / maxD;
                SphFuncBitMap.addPointToMiniFig(d2, d, d3, cArray);
            }
        }
        return cArray;
    }

    private static void addPointToMiniFig(double d, double d2, double d3, char[][][] cArray) {
        double d4 = d;
        double d5 = d2;
        if (Math.abs(PROJ[0]) == 1) {
            d4 = PROJ[0] > 0 ? d : -d;
        } else if (Math.abs(PROJ[0]) == 2) {
            d4 = PROJ[0] > 0 ? d2 : -d2;
        } else if (Math.abs(PROJ[0]) == 3) {
            double d6 = d4 = PROJ[0] > 0 ? d3 : -d3;
        }
        if (Math.abs(PROJ[1]) == 1) {
            d5 = PROJ[1] > 0 ? d : -d;
        } else if (Math.abs(PROJ[1]) == 2) {
            d5 = PROJ[1] > 0 ? d2 : -d2;
        } else if (Math.abs(PROJ[1]) == 3) {
            double d7 = d5 = PROJ[1] > 0 ? d3 : -d3;
        }
        if (ORIENTATION == 1) {
            d4 = d3;
            d5 = d2;
        }
        if (ORIENTATION == 2) {
            d4 = d3;
            d5 = -d;
        }
        if (ORIENTATION == 3) {
            d4 = -d3;
            d5 = d2;
        }
        if (ORIENTATION == 4) {
            d4 = -d3;
            d5 = -d;
        }
        if (ORIENTATION == 5) {
            d4 = d2;
            d5 = d;
        }
        if (ORIENTATION == 6) {
            d4 = d3;
            d5 = d2;
        }
        int n = (int)((double)miniFigSizeX * (d4 + 1.0) / 2.0);
        int n2 = (int)((double)miniFigSizeY * (d5 + 1.0) / 2.0);
        if (n >= 0 && n2 >= 0 && n < miniFigSizeX && n2 < miniFigSizeY) {
            char[] cArray2 = SphFuncBitMap.getPixelColour(d, d2, d3);
            for (int i = 0; i < 3; ++i) {
                cArray[n][n2][i] = cArray2[i] > cArray[n][n2][i] ? cArray2[i] : cArray[n][n2][i];
            }
        }
    }

    private static void addMiniFig(int n, int n2, char[][][] cArray) {
        int n3 = imArray.length - pixelsPerVoxelX * (n + 1);
        int n4 = pixelsPerVoxelY * n2;
        for (int i = 0; i < cArray.length; ++i) {
            for (int j = 0; j < cArray[0].length; ++j) {
                if (cArray[i][j][0] <= '\u0000' && cArray[i][j][1] <= '\u0000' && cArray[i][j][2] <= '\u0000') continue;
                for (int k = 0; k < 3; ++k) {
                    SphFuncBitMap.imArray[n3 + i][n4 + j][k] = cArray[i][j][k];
                }
            }
        }
    }

    private static char[] getPixelColour(double d, double d2, double d3) {
        char[] cArray = new char[3];
        if (colCodeDirections) {
            cArray[0] = COLCODE[0] == 1 ? (char)(Math.abs(d) * 255.0) : (COLCODE[0] == 2 ? (char)(Math.abs(d2) * 255.0) : (char)(Math.abs(d3) * 255.0));
            cArray[1] = COLCODE[1] == 1 ? (char)(Math.abs(d) * 255.0) : (COLCODE[1] == 2 ? (char)(Math.abs(d2) * 255.0) : (char)(Math.abs(d3) * 255.0));
            cArray[2] = COLCODE[2] == 1 ? (char)(Math.abs(d) * 255.0) : (COLCODE[2] == 2 ? (char)(Math.abs(d2) * 255.0) : (char)(Math.abs(d3) * 255.0));
        } else {
            cArray[0] = col[0];
            cArray[1] = col[1];
            cArray[2] = col[2];
        }
        return cArray;
    }

    public static void outputBitMap(DataOutputStream dataOutputStream, boolean bl) {
        try {
            for (int i = 0; i < imArray.length; ++i) {
                for (int j = 0; j < imArray[0].length; ++j) {
                    char c = imArray[i][j][0];
                    int n = 255;
                    if (bl) {
                        c = (char)(n - c);
                        dataOutputStream.writeByte(c);
                        continue;
                    }
                    for (int k = 0; k < 3; ++k) {
                        c = imArray[i][j][k];
                        dataOutputStream.writeByte(c);
                    }
                }
            }
        }
        catch (Exception exception) {
            LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
        }
    }

    static {
        PROJ = new int[]{1, 2};
        COLCODE = new int[]{2, 1, 3};
        col = new char[]{'\u00ff', '\u00ff', '\u00ff'};
    }
}

