/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.ModelFit;
import data.OutputManager;
import inverters.EvenSphHarmFitter;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class SphHarmFitter
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.SphHarmFitter");
    private EvenSphHarmFitter eshf;

    public SphHarmFitter(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
    }

    @Override
    public void initVariables() {
        this.eshf = new EvenSphHarmFitter(CL_Initializer.imPars, CL_Initializer.maxOrder);
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray;
                double[] dArray2 = CL_Initializer.data.nextVoxel();
                double d = CL_Initializer.imPars.geoMeanZeroMeas(dArray2);
                if (ModelFit.isBG(d)) {
                    dArray = new double[this.eshf.itemsPerVoxel()];
                    dArray[0] = -1.0;
                    dArray[1] = Math.log(d);
                    outputManager.output(dArray);
                    continue;
                }
                dArray = this.eshf.fit(dArray2);
                outputManager.output(dArray);
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
        outputManager.close();
    }

    public double getSphHarmAnisotropy(double[] dArray) {
        int n = 2;
        int n2 = 0;
        double d = 0.0;
        while (n < dArray.length) {
            d += dArray[n] * dArray[n];
            ++n;
            for (int i = 0; i < 2 * n2; ++i) {
                d += 2.0 * dArray[n] * dArray[n];
                ++n;
            }
            n2 += 2;
        }
        d = Math.sqrt((d - dArray[2] * dArray[2]) / (Math.PI * 4 * dArray[2] * dArray[2]));
        return d;
    }
}

