/*
 * Decompiled with CFR 0.152.
 */
package apps;

import Jama.Matrix;
import apps.Executable;
import data.DataSource;
import data.OutputManager;
import data.VoxelOrderDataSource;
import imaging.MetaImageHeader;
import imaging.Nifti1Dataset;
import java.io.IOException;
import java.util.ArrayList;
import misc.LoggedException;
import numerics.ACG_Fitter;
import numerics.BinghamFitter;
import numerics.ConvergenceException;
import numerics.EigenSystem3D;
import numerics.RealMatrix;
import numerics.SphericalDistributionFitter;
import numerics.Vector3D;
import numerics.WatsonFitter;
import tools.CL_Initializer;

public class SphPDF_Fit
extends Executable {
    boolean upperTriangular;
    boolean outputParamsOnly;
    String pdf;
    Vector3D e1;
    Vector3D e2;
    Vector3D e3;
    int vectorsPerVoxel;
    String inputImageType;
    boolean lastRun;
    DataSource dataSource;
    DataSource bgSource;
    EigenSystem3D nextTBarEig;
    Vector3D[] vectors;
    int counter;

    public SphPDF_Fit(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.upperTriangular = true;
        this.outputParamsOnly = true;
        this.pdf = "bingham";
        this.e1 = null;
        this.e2 = null;
        this.e3 = null;
        this.vectorsPerVoxel = 0;
        this.inputImageType = "raw";
        this.lastRun = false;
        this.dataSource = null;
        this.bgSource = null;
        this.nextTBarEig = null;
        this.vectors = null;
        this.counter = 0;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "double";
        CL_Initializer.inputModel = "vector";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-pdf")) {
                this.pdf = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-evecs")) {
                this.e1 = Vector3D.vectorFromSPC(1.0, Double.parseDouble(stringArray[i + 1]), Double.parseDouble(stringArray[i + 2]));
                this.e2 = Vector3D.vectorFromSPC(1.0, Double.parseDouble(stringArray[i + 3]), Double.parseDouble(stringArray[i + 4]));
                this.e3 = Vector3D.vectorFromSPC(1.0, Double.parseDouble(stringArray[i + 5]), Double.parseDouble(stringArray[i + 6]));
                CL_Initializer.markAsParsed(i, 7);
            }
            if (stringArray[i].equals("-outputpicoformat")) {
                this.outputParamsOnly = false;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-vectorspervoxel")) continue;
            this.vectorsPerVoxel = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        if (CL_Initializer.inputFile != null) {
            if (CL_Initializer.inputFile.endsWith(".mha") || CL_Initializer.inputFile.endsWith(".mhd")) {
                this.inputImageType = "meta";
            } else if (CL_Initializer.inputFile.endsWith(".nii") || CL_Initializer.inputFile.endsWith(".nii.gz")) {
                this.inputImageType = "nifti";
                this.upperTriangular = false;
            }
        }
    }

    @Override
    public void initVariables() {
        if (this.pdf.equals("acg") && !CL_Initializer.inputModel.equals("vector")) {
            throw new LoggedException("Need vectors to fit ACG");
        }
        if (this.inputImageType.equals("meta") && CL_Initializer.inputFile == null) {
            throw new LoggedException("Meta files must be input with -inputfile");
        }
        if (CL_Initializer.bgMaskFile != null) {
            CL_Initializer.initMaskSource();
            this.bgSource = CL_Initializer.bgMask;
        }
        if (CL_Initializer.inputModel.equals("vector")) {
            Object object;
            if (this.inputImageType.equals("raw")) {
                this.dataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 3, CL_Initializer.inputDataType);
            } else if (this.inputImageType.equals("meta")) {
                try {
                    object = MetaImageHeader.readHeader(CL_Initializer.inputFile);
                    this.dataSource = ((MetaImageHeader)object).getImageDataSource();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            if (this.vectorsPerVoxel == 0) {
                object = new ArrayList(2000);
                while (this.dataSource.more()) {
                    ((ArrayList)object).add(new Vector3D(this.dataSource.nextVoxel()));
                    ++this.counter;
                }
                this.vectorsPerVoxel = this.counter;
                this.vectors = new Vector3D[this.vectorsPerVoxel];
                ((ArrayList)object).toArray(this.vectors);
                this.nextTBarEig = SphericalDistributionFitter.tBarEigenSystem(this.vectors);
            } else {
                this.vectors = new Vector3D[this.vectorsPerVoxel];
                for (int i = 0; i < this.vectorsPerVoxel; ++i) {
                    this.vectors[i] = new Vector3D(this.dataSource.nextVoxel());
                }
                this.nextTBarEig = SphericalDistributionFitter.tBarEigenSystem(this.vectors);
            }
        } else if (CL_Initializer.inputModel.equals("dyad")) {
            if (this.inputImageType.equals("raw")) {
                this.dataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 6, CL_Initializer.inputDataType);
            } else if (this.inputImageType.equals("meta")) {
                try {
                    MetaImageHeader metaImageHeader = MetaImageHeader.readHeader(CL_Initializer.inputFile);
                    this.dataSource = metaImageHeader.getImageDataSource();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            } else if (this.inputImageType.equals("nifti")) {
                Nifti1Dataset nifti1Dataset = new Nifti1Dataset(CL_Initializer.inputFile);
                this.dataSource = nifti1Dataset.getImageDataSource();
            }
            this.nextTBarEig = SphericalDistributionFitter.tBarEigenSystem(this.dataSource.nextVoxel(), this.upperTriangular);
        }
        boolean bl = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(OutputManager outputManager) {
        while (!this.lastRun) {
            int n;
            this.lastRun = !this.dataSource.more();
            double[] dArray = null;
            boolean bl = false;
            if (this.bgSource != null && this.bgSource.nextVoxel()[0] == 0.0 || this.nextTBarEig.eigenvalues[0] == 0.0) {
                bl = true;
                if (this.pdf.equals("bingham")) {
                    dArray = new double[2];
                } else if (this.pdf.equals("watson")) {
                    dArray = new double[1];
                } else {
                    if (!this.pdf.equals("acg")) throw new LoggedException("Unrecognized pdf: " + this.pdf);
                    dArray = new double[3];
                }
            } else {
                try {
                    if (this.pdf.equals("bingham")) {
                        dArray = SphPDF_Fit.getBinghamConcentrationParams(this.nextTBarEig);
                    } else if (this.pdf.equals("watson")) {
                        dArray = SphPDF_Fit.getWatsonConcentrationParams(this.nextTBarEig, this.vectors);
                    } else {
                        if (!this.pdf.equals("acg")) throw new LoggedException("Unrecognized pdf: " + this.pdf);
                        dArray = SphPDF_Fit.getACGConcentrationParams(this.vectors);
                    }
                }
                catch (LoggedException loggedException) {
                    for (n = 0; n < dArray.length; ++n) {
                        dArray[n] = 0.0;
                    }
                    System.err.println("Couldn't fit params in voxel " + this.counter + ", scatter matrix eig\n" + this.nextTBarEig);
                }
                if (!(Math.abs(dArray[0]) < 1000000.0)) {
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = 0.0;
                    }
                    System.err.println("Couldn't fit params in voxel " + this.counter + ", scatter matrix eig\n" + this.nextTBarEig);
                }
            }
            if (this.outputParamsOnly) {
                outputManager.output(dArray);
            } else {
                double[] dArray2 = new double[9];
                if (this.e1 != null) {
                    dArray2[0] = this.e1.x;
                    dArray2[1] = this.e1.y;
                    dArray2[2] = this.e1.z;
                    dArray2[3] = this.e2.x;
                    dArray2[4] = this.e2.y;
                    dArray2[5] = this.e2.z;
                    dArray2[6] = this.e3.x;
                    dArray2[7] = this.e3.y;
                    dArray2[8] = this.e3.z;
                } else {
                    for (n = 0; n < 3; ++n) {
                        dArray2[3 * n] = this.nextTBarEig.eigenvectors[n].x;
                        dArray2[3 * n + 1] = this.nextTBarEig.eigenvectors[n].y;
                        dArray2[3 * n + 2] = this.nextTBarEig.eigenvectors[n].z;
                    }
                }
                outputManager.output(new double[]{bl ? 0.0 : 1.0, 1.0});
                outputManager.output(dArray2);
                outputManager.output(dArray);
            }
            ++this.counter;
            if (this.lastRun) continue;
            if (CL_Initializer.inputModel.equals("vector")) {
                this.vectors = new Vector3D[this.vectorsPerVoxel];
                for (int i = 0; i < this.vectorsPerVoxel; ++i) {
                    this.vectors[i] = new Vector3D(this.dataSource.nextVoxel());
                }
                this.nextTBarEig = SphericalDistributionFitter.tBarEigenSystem(this.vectors);
                continue;
            }
            if (!CL_Initializer.inputModel.equals("dyad")) continue;
            this.nextTBarEig = SphericalDistributionFitter.tBarEigenSystem(this.dataSource.nextVoxel(), this.upperTriangular);
        }
        outputManager.close();
    }

    protected static double[] getWatsonConcentrationParams(Vector3D[] vector3DArray) {
        EigenSystem3D eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
        if (vector3DArray != null) {
            return new double[]{WatsonFitter.fitKappa(eigenSystem3D, vector3DArray)};
        }
        return new double[]{WatsonFitter.fitKappa(eigenSystem3D)};
    }

    protected static double[] getWatsonConcentrationParams(EigenSystem3D eigenSystem3D, Vector3D[] vector3DArray) {
        if (vector3DArray != null) {
            return new double[]{WatsonFitter.fitKappa(eigenSystem3D, vector3DArray)};
        }
        return new double[]{WatsonFitter.fitKappa(eigenSystem3D)};
    }

    protected static double[] getBinghamConcentrationParams(EigenSystem3D eigenSystem3D) {
        try {
            double[] dArray = BinghamFitter.bngpar(eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]);
            return new double[]{dArray[0], dArray[1]};
        }
        catch (ConvergenceException convergenceException) {
            return new double[]{0.0, 0.0};
        }
    }

    protected static double[] getBinghamConcentrationParams(Vector3D[] vector3DArray) {
        EigenSystem3D eigenSystem3D = SphericalDistributionFitter.tBarEigenSystem(vector3DArray);
        try {
            double[] dArray = BinghamFitter.bngpar(eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]);
            return new double[]{dArray[0], dArray[1]};
        }
        catch (ConvergenceException convergenceException) {
            return new double[]{0.0, 0.0};
        }
    }

    protected static double[] getACGConcentrationParams(Vector3D[] vector3DArray) {
        RealMatrix realMatrix = ACG_Fitter.findA(vector3DArray);
        Matrix matrix = new Matrix(3, 3);
        matrix.set(0, 0, realMatrix.entries[0][0]);
        matrix.set(0, 1, realMatrix.entries[0][1]);
        matrix.set(0, 2, realMatrix.entries[0][2]);
        matrix.set(1, 0, realMatrix.entries[1][0]);
        matrix.set(1, 1, realMatrix.entries[1][1]);
        matrix.set(1, 2, realMatrix.entries[1][2]);
        matrix.set(2, 0, realMatrix.entries[2][0]);
        matrix.set(2, 1, realMatrix.entries[2][1]);
        matrix.set(2, 2, realMatrix.entries[2][2]);
        EigenSystem3D eigenSystem3D = EigenSystem3D.sort(matrix.eig());
        return new double[]{eigenSystem3D.eigenvalues[0], eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]};
    }
}

