/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import imaging.Nifti1Dataset;
import java.io.IOException;
import misc.LoggedException;
import tools.CL_Initializer;

public class Split4D_NiiImage
extends Executable {
    private String outputRoot;

    public Split4D_NiiImage(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.outputRoot = "";
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-outputroot")) continue;
            this.outputRoot = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
    }

    @Override
    public void execute(OutputManager outputManager) {
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(CL_Initializer.inputFile);
        if (nifti1Dataset.components() == 1) {
            throw new LoggedException("This image is already three-dimensional");
        }
        try {
            Nifti1Dataset.convertTo3D(CL_Initializer.inputFile, this.outputRoot);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

