/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import misc.LoggedException;
import numerics.MTRandom;
import numerics.Point3D;
import numerics.RealMatrix;
import tools.CL_Initializer;
import tractography.BallStickTractographyImage;
import tractography.BayesDiracTractographyImage;
import tractography.DT_TractographyImage;
import tractography.DataModel;
import tractography.FACT_TendFibreTracker;
import tractography.FibreTracker;
import tractography.LinIntDTEulerFibreTracker;
import tractography.LinIntVectorEulerFibreTracker;
import tractography.NC_ProbFibreTracker;
import tractography.NonIntProbFibreTracker;
import tractography.NonInterpolatedFibreTracker;
import tractography.PD_TractographyImage;
import tractography.PICoPDF;
import tractography.PICoTractographyImage;
import tractography.PointListROI;
import tractography.RegionOfInterest;
import tractography.RepBS_DT_TractographyImage;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractographyImage;
import tractography.VoxelROI;
import tractography.WildBS_DT_TractographyImage;

public class StreamlineTractography
extends Executable {
    protected static final int DEFAULT_PICO_ITERATIONS = 5000;
    private double stepSize;
    private boolean voxelCoordinates;
    private int regionIndex;
    private int xDataDim;
    private int yDataDim;
    private int zDataDim;
    private double xVoxelDim;
    private double yVoxelDim;
    private double zVoxelDim;
    private String seedFile;
    private String seedList;
    private double curvePriorK;
    private double curvePriorG;
    private long seed;
    private double anisThresh;
    private double ipThresh;
    private String anisMapFile;
    private String bootstrapModel;
    private RegionOfInterest[] allROIs;
    private String tendF_File;
    private double tendF;
    private double tendG;
    private boolean silent;
    private boolean interpolated;
    private boolean vectorInterpolation;
    private int iterations;
    private PICoPDF picoPDF;
    private Random ran;
    private String outputRoot;
    private ImageType imageType;
    private boolean gzip;
    private RealMatrix trans;
    private RealMatrix invTrans;
    private DataModel dataModel;
    private String externalPriorImageFile;
    private String externalPriorDataType;
    private boolean tend;
    private RealMatrix voxelToPhysicalTrans;
    private Point3D seedPointVox;
    private static Logger logger = Logger.getLogger("camino.apps.StreamlineTractography");

    public StreamlineTractography(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        this.stepSize = 0.0;
        this.xDataDim = 0;
        this.yDataDim = 0;
        this.zDataDim = 0;
        this.xVoxelDim = 0.0;
        this.yVoxelDim = 0.0;
        this.zVoxelDim = 0.0;
        this.voxelCoordinates = false;
        this.regionIndex = -1;
        this.seedFile = null;
        this.seedList = null;
        this.curvePriorK = 0.0;
        this.curvePriorG = 0.0;
        this.seed = System.currentTimeMillis();
        this.anisThresh = 0.0;
        this.ipThresh = Math.cos(1.3962634015954636);
        this.anisMapFile = null;
        this.bootstrapModel = "dt";
        this.allROIs = null;
        this.tendF_File = null;
        this.tendF = 0.0;
        this.tendG = 1.0;
        this.silent = false;
        this.interpolated = false;
        this.vectorInterpolation = false;
        this.iterations = 0;
        this.picoPDF = PICoPDF.BINGHAM;
        this.ran = null;
        this.outputRoot = null;
        this.imageType = null;
        this.gzip = OutputManager.gzipOut;
        this.dataModel = DataModel.CYL_SYMM_DT;
        this.externalPriorImageFile = null;
        this.externalPriorDataType = "double";
        this.tend = false;
        this.voxelToPhysicalTrans = RealMatrix.identity(4);
        this.seedPointVox = null;
    }

    @Override
    public void initOptions(String[] stringArray) {
        if (stringArray.length == 0) {
            System.exit(0);
        }
        CL_Initializer.inputDataType = "double";
        CL_Initializer.pointSetInd = 1;
        CL_Initializer.CL_init(stringArray);
        if (CL_Initializer.inputModel == null) {
            throw new LoggedException("An input model is required.");
        }
        if (CL_Initializer.inputModel.equals("bootstrap")) {
            if (CL_Initializer.bsDataFiles == null) {
                this.imageType = ImageType.WILD_BOOTSTRAP;
            } else {
                if (CL_Initializer.bsDataFiles.length == 1) {
                    throw new LoggedException("Can't do repetition bootstrap with a single image");
                }
                this.imageType = ImageType.BOOTSTRAP;
            }
            CL_Initializer.inputDataType = "float";
        } else if (CL_Initializer.inputModel.equals("pico")) {
            this.imageType = ImageType.PICO;
        } else if (CL_Initializer.inputModel.equals("dt")) {
            this.imageType = ImageType.TENSOR;
        } else if (CL_Initializer.inputModel.equals("multitensor")) {
            this.imageType = ImageType.TENSOR;
        } else if (CL_Initializer.inputModel.equals("pds")) {
            this.imageType = ImageType.PDS;
        } else if (CL_Initializer.inputModel.equals("ballstick")) {
            this.imageType = ImageType.BALL_STICK;
        } else if (CL_Initializer.inputModel.equals("bayesdirac")) {
            CL_Initializer.inputDataType = "float";
            this.imageType = ImageType.BAYES_DIRAC;
        } else {
            throw new LoggedException("Unrecognized input model " + CL_Initializer.inputModel);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-bsmodel")) {
                this.bootstrapModel = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-wildbsmodel")) {
                this.bootstrapModel = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-inputdatatype")) {
                CL_Initializer.inputDataType = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-regionindex")) {
                this.regionIndex = Integer.parseInt(stringArray[i + 1]) - 1;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedfile")) {
                this.seedFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedlist")) {
                this.seedList = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedpointvox")) {
                this.seedPointVox = new Point3D(Integer.parseInt(stringArray[i + 1]), Integer.parseInt(stringArray[i + 2]), Integer.parseInt(stringArray[i + 3]));
                CL_Initializer.markAsParsed(i, 4);
                continue;
            }
            if (stringArray[i].equals("-randomseed") || stringArray[i].equals("-seed")) {
                this.seed = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-anisthresh")) {
                this.anisThresh = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-anisfile")) {
                this.anisMapFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-ipthresh")) {
                this.ipThresh = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-curvethresh")) {
                this.ipThresh = Math.cos(Math.PI * Double.parseDouble(stringArray[i + 1]) / 180.0);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-stepsize")) {
                this.stepSize = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-iterations")) {
                this.iterations = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-pdf")) {
                CL_Initializer.markAsParsed(i);
                if (i == stringArray.length - 1) {
                    throw new LoggedException("Missing PDF type");
                }
                this.picoPDF = PICoPDF.getPDF(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i + 1);
                continue;
            }
            if (stringArray[i].equals("-datamodel")) {
                this.dataModel = DataModel.getModel(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-curvepriork")) {
                this.curvePriorK = Double.parseDouble(stringArray[i + 1]);
                this.curvePriorG = 0.0;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-curvepriorg")) {
                this.curvePriorG = Double.parseDouble(stringArray[i + 1]);
                this.curvePriorK = 0.0;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-extpriorfile")) {
                this.externalPriorImageFile = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-extpriordatatype")) {
                this.externalPriorDataType = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputroot")) {
                this.outputRoot = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-interpolated") || stringArray[i].equals("-interpolate")) {
                this.interpolated = true;
                CL_Initializer.markAsParsed(i);
                if (stringArray.length <= i + 1 || !stringArray[i + 1].equals("vectors")) continue;
                this.vectorInterpolation = true;
                CL_Initializer.markAsParsed(i + 1);
                continue;
            }
            if (stringArray[i].equals("-tendffile")) {
                this.tendF_File = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-tend")) {
                this.tend = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-tendf")) {
                this.tendF = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-tendg")) {
                this.tendG = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-silent")) continue;
            this.silent = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        if (CL_Initializer.headerTemplateFile != null) {
            logger.info("Defining input physical space from " + CL_Initializer.headerTemplateFile);
            CL_Initializer.initInputSpaceAndHeaderOptions();
        } else if (CL_Initializer.voxelDims[0] > 0.0) {
            logger.info("Defining input physical space from data and voxel dimensions, assuming identity transform");
            CL_Initializer.initInputSpaceAndHeaderOptions();
        } else if (this.seedFile != null) {
            logger.info("Defining input physical space from seed file");
            CL_Initializer.headerTemplateFile = this.seedFile;
            CL_Initializer.initInputSpaceAndHeaderOptions();
        } else {
            throw new LoggedException("Can't continue without definition of input physical space");
        }
        this.xDataDim = CL_Initializer.dataDims[0];
        this.yDataDim = CL_Initializer.dataDims[1];
        this.zDataDim = CL_Initializer.dataDims[2];
        this.xVoxelDim = CL_Initializer.voxelDims[0];
        this.yVoxelDim = CL_Initializer.voxelDims[1];
        this.zVoxelDim = CL_Initializer.voxelDims[2];
        this.voxelToPhysicalTrans = CL_Initializer.headerTemplate.getVoxelToPhysicalTransform();
        if (this.stepSize == 0.0) {
            this.stepSize = this.zVoxelDim / 10.0;
        }
        if (this.imageType != ImageType.TENSOR && this.anisThresh > 0.0 && this.anisMapFile == null) {
            throw new LoggedException("Input model is not tensors, anisotropy map (-anisfile) must be supplied when -anisthresh is used");
        }
        this.ran = new MTRandom(this.seed);
        if (!this.imageType.probabilistic) {
            if (this.iterations != 0) {
                logger.warning("Iterations is set to " + this.iterations + " but input model is not probabilistic. " + "Proceeding with deterministic tracking.");
            }
            this.iterations = 1;
        } else if (this.iterations == 0) {
            this.iterations = 5000;
        }
        if (this.seedFile != null) {
            VoxelROI voxelROI = new VoxelROI(this.seedFile, CL_Initializer.headerTemplate);
            this.allROIs = voxelROI.getAllRegions();
        } else if (this.seedList != null) {
            this.allROIs = new RegionOfInterest[]{PointListROI.readPoints(this.seedList, CL_Initializer.headerTemplate)};
        } else {
            Point3D point3D = new Point3D((this.seedPointVox.x + 0.5) * this.xVoxelDim, (this.seedPointVox.y + 0.5) * this.yVoxelDim, (this.seedPointVox.z + 0.5) * this.zVoxelDim);
            this.allROIs = new RegionOfInterest[]{new PointListROI(new Point3D[]{point3D}, 1)};
        }
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n;
        int n2;
        int n3;
        int n4 = this.allROIs.length;
        int[][][] nArray = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        int[][][] nArray2 = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        for (n3 = 0; n3 < this.zDataDim; ++n3) {
            for (n2 = 0; n2 < this.yDataDim; ++n2) {
                for (n = 0; n < this.xDataDim; ++n) {
                    nArray[n][n2][n3] = 0;
                    nArray2[n][n2][n3] = 1;
                }
            }
        }
        if (CL_Initializer.bgMaskFile != null) {
            if (ImageHeader.imageExists(CL_Initializer.bgMaskFile) && !CL_Initializer.headerTemplate.sameSpace(CL_Initializer.bgMaskFile)) {
                throw new LoggedException("Brain mask must be in the same voxel space as the input data");
            }
            CL_Initializer.initMaskSource();
            for (n3 = 0; n3 < this.zDataDim; ++n3) {
                for (n2 = 0; n2 < this.yDataDim; ++n2) {
                    for (n = 0; n < this.xDataDim; ++n) {
                        double d = CL_Initializer.bgMask.nextVoxel()[0];
                        nArray[n][n2][n3] = d > 0.0 ? 0 : -1;
                        nArray2[n][n2][n3] = d > 0.0 ? 1 : 0;
                    }
                }
            }
        }
        if (CL_Initializer.voxelClassMap != null) {
            nArray = new int[this.xDataDim][this.yDataDim][this.zDataDim];
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.voxelClassMap, 1, "int");
            for (n2 = 0; n2 < this.zDataDim; ++n2) {
                for (n = 0; n < this.yDataDim; ++n) {
                    for (int i = 0; i < this.xDataDim; ++i) {
                        nArray[i][n][n2] = (int)voxelOrderDataSource.nextVoxel()[0];
                    }
                }
            }
        }
        double[][][] dArray = null;
        if (this.anisMapFile != null) {
            if (ImageHeader.imageExists(this.anisMapFile)) {
                try {
                    ImageHeader imageHeader = ImageHeader.readHeader(this.anisMapFile);
                    if (!CL_Initializer.headerTemplate.sameSpace(imageHeader)) {
                        throw new LoggedException("Anisotropy image must be in the same voxel space as the input data");
                    }
                    dArray = imageHeader.readSingleVolumeData();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            } else {
                dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
                VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(this.anisMapFile, 1, CL_Initializer.inputDataType);
                for (n = 0; n < this.zDataDim; ++n) {
                    for (int i = 0; i < this.yDataDim; ++i) {
                        for (int j = 0; j < this.xDataDim; ++j) {
                            dArray[j][i][n] = voxelOrderDataSource.nextVoxel()[0];
                        }
                    }
                }
            }
        }
        FibreTracker fibreTracker = null;
        TractographyImage tractographyImage = null;
        if (this.imageType.probabilistic) {
            switch (this.imageType) {
                case BOOTSTRAP: {
                    CL_Initializer.initImagingScheme();
                    if (this.bootstrapModel.equals("dt") || this.bootstrapModel.equals("multitensor")) {
                        tractographyImage = RepBS_DT_TractographyImage.getBS_TractographyImage(CL_Initializer.bsDataFiles, CL_Initializer.inputDataType, CL_Initializer.imPars, CL_Initializer.inversionIndices, nArray, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim}, this.ran);
                        break;
                    }
                    throw new LoggedException("Unsupported bootstrap model : " + this.bootstrapModel);
                }
                case WILD_BOOTSTRAP: {
                    CL_Initializer.initImagingScheme();
                    if (this.bootstrapModel.equals("dt")) {
                        tractographyImage = WildBS_DT_TractographyImage.getBS_TractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.imPars, nArray, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim}, this.ran);
                        break;
                    }
                    throw new LoggedException("Unsupported bootstrap model : " + this.bootstrapModel);
                }
                case PICO: {
                    tractographyImage = PICoTractographyImage.getPICoTractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.numPDsIO, this.picoPDF, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim}, this.ran);
                    break;
                }
                case BAYES_DIRAC: {
                    CL_Initializer.initImagingScheme();
                    BayesDiracTractographyImage bayesDiracTractographyImage = BayesDiracTractographyImage.getBayesDiracTractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.imPars, this.dataModel, nArray2, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim}, CL_Initializer.pointSetInd, this.ran);
                    if (this.curvePriorK > 0.0) {
                        bayesDiracTractographyImage.setCurvePriorKappa(this.curvePriorK);
                    }
                    if (this.curvePriorG > 0.0) {
                        bayesDiracTractographyImage.setCurvePriorGamma(this.curvePriorG);
                    }
                    if (this.externalPriorImageFile != null) {
                        PICoTractographyImage pICoTractographyImage = PICoTractographyImage.getPICoTractographyImage(this.externalPriorImageFile, this.externalPriorDataType, CL_Initializer.numPDsIO, this.picoPDF, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim}, this.ran);
                        bayesDiracTractographyImage.setExternalPriors(pICoTractographyImage);
                    }
                    tractographyImage = bayesDiracTractographyImage;
                    break;
                }
                default: {
                    throw new LoggedException("Unsupported image type : " + (Object)((Object)this.imageType));
                }
            }
            fibreTracker = this.interpolated ? new NC_ProbFibreTracker(tractographyImage, this.stepSize, this.ipThresh, this.ran) : new NonIntProbFibreTracker(tractographyImage, this.ipThresh, this.ran);
        } else {
            switch (this.imageType) {
                case PDS: {
                    tractographyImage = PD_TractographyImage.getPD_TractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.numPDsIO, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim});
                    if (this.interpolated) {
                        fibreTracker = new LinIntVectorEulerFibreTracker(tractographyImage, this.stepSize, this.ipThresh);
                        break;
                    }
                    fibreTracker = new NonInterpolatedFibreTracker(tractographyImage, this.ipThresh);
                    break;
                }
                case BALL_STICK: {
                    tractographyImage = BallStickTractographyImage.getBallStickTractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim});
                    if (this.interpolated) {
                        fibreTracker = new LinIntVectorEulerFibreTracker(tractographyImage, this.stepSize, this.ipThresh);
                        break;
                    }
                    fibreTracker = new NonInterpolatedFibreTracker(tractographyImage, this.ipThresh);
                    break;
                }
                case TENSOR: {
                    tractographyImage = DT_TractographyImage.getDT_TractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.numPDsIO, dArray, this.anisThresh, new int[]{this.xDataDim, this.yDataDim, this.zDataDim}, new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim});
                    if (this.interpolated && this.vectorInterpolation) {
                        fibreTracker = new LinIntVectorEulerFibreTracker(tractographyImage, this.stepSize, this.ipThresh);
                        break;
                    }
                    if (this.interpolated) {
                        fibreTracker = new LinIntDTEulerFibreTracker((DT_TractographyImage)tractographyImage, this.stepSize, this.ipThresh);
                        break;
                    }
                    if (this.tend) {
                        if (this.tendF_File != null) {
                            try {
                                ImageHeader imageHeader = ImageHeader.readHeader(this.tendF_File);
                                fibreTracker = new FACT_TendFibreTracker((DT_TractographyImage)tractographyImage, this.ipThresh, imageHeader.readSingleVolumeData(), this.tendG);
                                break;
                            }
                            catch (IOException iOException) {
                                throw new LoggedException(iOException);
                            }
                        }
                        fibreTracker = new FACT_TendFibreTracker((DT_TractographyImage)tractographyImage, this.ipThresh, this.tendF, this.tendG);
                        break;
                    }
                    fibreTracker = new NonInterpolatedFibreTracker(tractographyImage, this.ipThresh);
                    break;
                }
                default: {
                    throw new LoggedException("Unsupported image type : " + (Object)((Object)this.imageType));
                }
            }
        }
        for (int i = 0; i < this.allROIs.length; ++i) {
            RegionOfInterest regionOfInterest = this.allROIs[i];
            if (this.regionIndex > -1 && regionOfInterest.getRegionLabel() != this.regionIndex) continue;
            int n5 = regionOfInterest.getRegionLabel();
            Point3D[] point3DArray = regionOfInterest.getSeedPoints();
            if (!this.silent) {
                System.err.println("Processing ROI " + (i + 1) + " of " + n4);
            }
            FileOutputStream fileOutputStream = null;
            DataOutputStream dataOutputStream = null;
            try {
                if (this.outputRoot == null) {
                    dataOutputStream = outputManager.getOutputStream();
                } else if (this.gzip) {
                    fileOutputStream = new FileOutputStream(this.outputRoot + n5 + ".Bfloat.gz");
                    dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)fileOutputStream, 0x1000000));
                } else {
                    fileOutputStream = new FileOutputStream(this.outputRoot + n5 + ".Bfloat");
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x1000000));
                }
                for (int j = 0; j < point3DArray.length; ++j) {
                    if (!this.silent) {
                        System.err.print("\rProcessing seed " + (j + 1) + " of " + point3DArray.length);
                    }
                    Point3D point3D = point3DArray[j];
                    int n6 = (int)(point3D.x / this.xVoxelDim);
                    int n7 = (int)(point3D.y / this.yVoxelDim);
                    int n8 = (int)(point3D.z / this.zVoxelDim);
                    int n9 = tractographyImage.numberOfPDs(n6, n7, n8);
                    n9 = n9 == 0 ? 1 : n9;
                    for (int k = 0; k < n9; ++k) {
                        for (int i2 = 0; i2 < this.iterations; ++i2) {
                            TractCollection tractCollection = fibreTracker.trackFromSeed(point3D, k);
                            Tract tract = tractCollection.getTract(0);
                            tract.transformToPhysicalSpace(this.voxelToPhysicalTrans, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                            tract.writeRaw(dataOutputStream);
                        }
                    }
                }
                if (!this.silent) {
                    System.err.println("\n");
                }
                if (this.outputRoot == null) continue;
                dataOutputStream.close();
                continue;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        if (outputManager != null) {
            outputManager.close();
        }
    }

    public static enum ImageType {
        PICO(true),
        BOOTSTRAP(true),
        WILD_BOOTSTRAP(true),
        BAYES_DIRAC(true),
        BAYES_MCMC(true),
        TENSOR(false),
        PDS(false),
        BALL_STICK(false);

        final boolean probabilistic;

        private ImageType(boolean bl) {
            this.probabilistic = bl;
        }
    }
}

