/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import imaging.ImageHeader;
import java.io.DataOutputStream;
import java.io.IOException;
import misc.LoggedException;
import misc.ScalarImage;
import numerics.Point3D;
import numerics.RealMatrix;
import numerics.Vector3D;
import tools.CL_Initializer;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractSource;
import tractography.Voxel;
import tractography.VoxelList;

public class VTK_Streamlines {
    private static OutputManager om;

    public static void main(String[] stringArray) {
        Object object;
        int n;
        CL_Initializer.inputModel = "raw";
        CL_Initializer.CL_init(stringArray);
        om = new OutputManager();
        DataOutputStream dataOutputStream = om.getOutputStream();
        int n2 = CL_Initializer.dataDims[0];
        int n3 = CL_Initializer.dataDims[1];
        int n4 = CL_Initializer.dataDims[2];
        double d = Math.abs(CL_Initializer.voxelDims[0]);
        double d2 = Math.abs(CL_Initializer.voxelDims[1]);
        double d3 = Math.abs(CL_Initializer.voxelDims[2]);
        double[][][] dArray = null;
        ScalarImage scalarImage = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-scalarfile")) {
                string2 = stringArray[n + 1];
                bl4 = true;
                CL_Initializer.markAsParsed(n, 2);
            } else if (stringArray[n].equals("-targetfile")) {
                string3 = stringArray[n + 1];
                bl2 = true;
                CL_Initializer.markAsParsed(n, 2);
            } else if (stringArray[n].equals("-seedfile")) {
                string = stringArray[n + 1];
                bl = true;
                CL_Initializer.markAsParsed(n, 2);
            } else if (stringArray[n].equals("-colourorient")) {
                bl3 = true;
                CL_Initializer.markAsParsed(n);
            }
            if (!stringArray[n].equals("-interpolatescalars") && !stringArray[n].equals("-interpolate")) continue;
            bl5 = true;
            CL_Initializer.markAsParsed(n);
        }
        CL_Initializer.checkParsing(stringArray);
        n = bl4 || bl2 || bl || bl3 ? 1 : 0;
        String string4 = null;
        if (bl4) {
            string4 = string2;
        }
        if (bl2) {
            string4 = string3;
        }
        if (bl) {
            string4 = string;
        }
        CL_Initializer.headerTemplateFile = string4;
        CL_Initializer.initInputSpaceAndHeaderOptions();
        n2 = CL_Initializer.dataDims[0];
        n3 = CL_Initializer.dataDims[1];
        n4 = CL_Initializer.dataDims[2];
        d = Math.abs(CL_Initializer.voxelDims[0]);
        d2 = Math.abs(CL_Initializer.voxelDims[1]);
        d3 = Math.abs(CL_Initializer.voxelDims[2]);
        if (string4 != null) {
            object = null;
            try {
                object = ImageHeader.readHeader(string4);
            }
            catch (IOException iOException) {
                throw new LoggedException("Can't read file " + string4, iOException);
            }
            dArray = ((ImageHeader)object).readSingleVolumeData();
            if (bl4) {
                scalarImage = new ScalarImage(dArray, new double[]{d, d2, d3});
                if (bl5) {
                    scalarImage.setInterpolation("linear");
                }
            }
        }
        object = new TractSource(CL_Initializer.inputFile, null);
        TractCollection tractCollection = new TractCollection(1000, 100.0);
        while (((TractSource)object).more()) {
            tractCollection.addTract(((TractSource)object).nextTract());
        }
        try {
            Object object2;
            int n5;
            String string5 = "# vtk DataFile Version 3.0\nCamino tracts\nBINARY\nDATASET POLYDATA\n";
            string5 = string5 + "POINTS " + tractCollection.totalPoints() + " float\n";
            dataOutputStream.write(string5.getBytes("US-ASCII"));
            for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
                Tract tract = new Tract(tractCollection.getTract(i));
                for (n5 = 0; n5 < tract.numberOfPoints(); ++n5) {
                    object2 = tract.getPoint(n5);
                    dataOutputStream.writeFloat((float)((Point3D)object2).x);
                    dataOutputStream.writeFloat((float)((Point3D)object2).y);
                    dataOutputStream.writeFloat((float)((Point3D)object2).z);
                }
            }
            String string6 = "\nLINES " + tractCollection.numberOfTracts() + " " + (tractCollection.numberOfTracts() + tractCollection.totalPoints()) + "\n";
            dataOutputStream.write(string6.getBytes("US-ASCII"));
            int n6 = 0;
            for (n5 = 0; n5 < tractCollection.numberOfTracts(); ++n5) {
                object2 = tractCollection.getTract(n5);
                dataOutputStream.writeInt(((Tract)object2).numberOfPoints());
                for (int i = 0; i < ((Tract)object2).numberOfPoints(); ++i) {
                    dataOutputStream.writeInt(n6);
                    ++n6;
                }
            }
            String string7 = "CELL_DATA " + tractCollection.numberOfTracts() + "\nPOINT_DATA " + tractCollection.totalPoints() + "\n";
            dataOutputStream.write(string7.getBytes("US-ASCII"));
            if (n != 0) {
                object2 = "";
                if (bl3) {
                    object2 = "COLOR_SCALARS RGB_scalars 3\n";
                } else if (bl2) {
                    object2 = "SCALARS target_scalars float 1\nLOOKUP_TABLE default\n";
                } else if (bl) {
                    object2 = "SCALARS seed_scalars float 1\nLOOKUP_TABLE default\n";
                } else if (bl4) {
                    object2 = "SCALARS custom_scalars float 1\nLOOKUP_TABLE default\n";
                }
                dataOutputStream.write(((String)object2).getBytes("US-ASCII"));
                RealMatrix realMatrix = CL_Initializer.headerTemplate.getPhysicalToVoxelTransform();
                for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
                    int n7;
                    int n8;
                    int n9;
                    Object object3;
                    Object object4;
                    Tract tract = new Tract(tractCollection.getTract(i));
                    if (bl3) {
                        object4 = null;
                        object3 = null;
                        Vector3D vector3D = new Vector3D(1.0, 0.0, 0.0);
                        for (n9 = 0; n9 < tract.numberOfPoints() - 1; ++n9) {
                            object4 = tract.getPoint(n9);
                            object3 = tract.getPoint(n9 + 1);
                            vector3D = new Vector3D((Point3D)object4, (Point3D)object3).normalized();
                            dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.x)));
                            dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.y)));
                            dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.z)));
                        }
                        dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.x)));
                        dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.y)));
                        dataOutputStream.writeByte((byte)(255.0 * Math.abs(vector3D.z)));
                    } else {
                        tract.transformToCaminoSpace(realMatrix, d, d2, d3);
                    }
                    if (bl2) {
                        int n10;
                        object4 = tract.toVoxelList(d, d2, d3);
                        object3 = ((VoxelList)object4).getVoxels();
                        int n11 = ((VoxelList)object4).seedPointIndex();
                        n9 = 0;
                        n8 = 0;
                        for (n7 = n11; n7 < ((Voxel[])object3).length; ++n7) {
                            n10 = (int)dArray[object3[n7].x][object3[n7].y][object3[n7].z];
                            if (n10 <= 0) continue;
                            n9 = n10;
                            break;
                        }
                        for (n7 = n11; n7 >= 0; --n7) {
                            n10 = (int)dArray[object3[n7].x][object3[n7].y][object3[n7].z];
                            if (n10 <= 0) continue;
                            n8 = n10;
                            break;
                        }
                        if (n9 > 0 && n8 == 0) {
                            n8 = n9;
                        } else if (n9 == 0 && n8 > 0) {
                            n9 = n8;
                        }
                        for (n7 = 0; n7 < tract.seedPointIndex(); ++n7) {
                            dataOutputStream.writeFloat(n8);
                        }
                        for (n7 = tract.seedPointIndex(); n7 < tract.numberOfPoints(); ++n7) {
                            dataOutputStream.writeFloat(n9);
                        }
                        continue;
                    }
                    if (bl) {
                        object4 = tract.getPoint(tract.seedPointIndex());
                        int n12 = (int)(((Point3D)object4).x / d);
                        int n13 = (int)(((Point3D)object4).y / d2);
                        n9 = (int)(((Point3D)object4).z / d3);
                        n8 = (int)dArray[n12][n13][n9];
                        for (n7 = 0; n7 < tract.numberOfPoints(); ++n7) {
                            dataOutputStream.writeFloat(n8);
                        }
                        continue;
                    }
                    if (!bl4) continue;
                    for (int j = 0; j < tract.numberOfPoints(); ++j) {
                        object3 = tract.getPoint(j);
                        dataOutputStream.writeFloat((float)scalarImage.valueAt((Point3D)object3));
                    }
                }
            }
            om.close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

