/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import apps.ModelFit;
import data.OutputManager;
import inverters.EvenSphHarmFitter;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class VoxelClassify
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.VoxelClassify");
    private EvenSphHarmFitter eshf;

    public VoxelClassify(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
    }

    @Override
    public void initVariables() {
        if (CL_Initializer.f1 > 0.0) {
            OutputManager.outputDataType = "int";
        }
        this.eshf = new EvenSphHarmFitter(CL_Initializer.imPars, CL_Initializer.maxOrder);
    }

    @Override
    public void execute(OutputManager outputManager) {
        while (CL_Initializer.data.more()) {
            Object[] objectArray;
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                objectArray = this.eshf.fit(dArray);
                StackTraceElement stackTraceElement = objectArray[0];
                double d = Math.exp((double)objectArray[1]);
                double[] dArray2 = this.eshf.getF_TestProbabilities((double[])objectArray, dArray);
                if (CL_Initializer.f1 > 0.0) {
                    try {
                        int n = ModelFit.isBG(d) || stackTraceElement < 0.0 ? -1 : (CL_Initializer.CSFTHRESHOLD > 0.0 && d > CL_Initializer.CSFTHRESHOLD ? 0 : this.eshf.selectModel(dArray2, CL_Initializer.f1, CL_Initializer.f2, CL_Initializer.f3));
                        outputManager.output(new double[]{n});
                    }
                    catch (Exception exception) {
                        LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
                    }
                    continue;
                }
                double[] dArray3 = new double[]{(double)objectArray[0], (double)objectArray[1]};
                outputManager.output(dArray3);
                outputManager.output(dArray2);
            }
            catch (Exception exception) {
                objectArray = exception.getStackTrace();
                String string = new String();
                logger.warning(exception.toString() + "  (Program will continue)");
                for (int i = 0; i < objectArray.length; ++i) {
                    string = string + objectArray[i] + "\n";
                }
                logger.warning(string);
            }
        }
        outputManager.close();
    }
}

