/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Executable;
import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class VoxelToScanner
extends Executable {
    private static Logger logger = Logger.getLogger("camino.apps.VoxelToScanner");
    private static int components;
    VoxelOrderDataSource data;
    private double[][] d;
    private int nv;

    public VoxelToScanner(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public void initDefaultVals() {
        components = 1;
    }

    @Override
    public void initOptions(String[] stringArray) {
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-components")) continue;
            components = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i);
            CL_Initializer.markAsParsed(i + 1);
        }
        CL_Initializer.checkParsing(stringArray);
    }

    @Override
    public void initVariables() {
        this.data = new VoxelOrderDataSource(CL_Initializer.inputFile, components, CL_Initializer.inputDataType);
        this.d = new double[components][CL_Initializer.numVoxels];
        this.nv = CL_Initializer.numVoxels;
    }

    @Override
    public void execute(OutputManager outputManager) {
        int n;
        for (n = 0; n < this.nv; ++n) {
            try {
                double[] dArray = this.data.nextVoxel();
                for (int i = 0; i < components; ++i) {
                    this.d[i][n] = dArray[i];
                }
                continue;
            }
            catch (Exception exception) {
                LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            }
        }
        for (n = 0; n < components; ++n) {
            outputManager.output(this.d[n]);
        }
        outputManager.close();
    }
}

