/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.PD_OrientationViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

class ZoomPanel
extends JPanel {
    private int zoomedXMin = 0;
    private int zoomedYMin = 0;
    private int zoomedXMax = 0;
    private int zoomedYMax = 0;
    private int xBoxCentre = 0;
    private int yBoxCentre = 0;
    private int zoomOutlineXMin = 0;
    private int zoomOutlineYMin = 0;
    private BufferedImage slice = null;
    private int zoomedXExtent = 0;
    private int zoomedYExtent = 0;
    private PD_OrientationViewer container = null;
    private double[][][] normScalarVol = null;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    private final MouseInputAdapter mouseListener = new MouseInputAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ZoomPanel.this.setBoxCentre(mouseEvent);
            ZoomPanel.this.container.setZoomedSlice();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ZoomPanel.this.setBoxCentre(mouseEvent);
            ZoomPanel.this.container.setZoomedSlice();
        }
    };

    public ZoomPanel(PD_OrientationViewer pD_OrientationViewer) {
        this.container = pD_OrientationViewer;
        this.xSize = pD_OrientationViewer.xSize;
        this.ySize = pD_OrientationViewer.ySize;
        this.zSize = pD_OrientationViewer.zSize;
        this.resetZoomPosition();
        this.normScalarVol = pD_OrientationViewer.image.normScalarVol;
        this.setLayout(new GridLayout(2, 1));
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setPreferredSize(new Dimension(this.xSize, this.ySize));
        this.setMinimumSize(new Dimension(this.xSize, this.ySize));
        this.addMouseWheelListener(pD_OrientationViewer.wheelListener);
    }

    public void resetZoomPosition() {
        this.zoomedXExtent = this.container.preferredZoomedExtent;
        this.zoomedYExtent = this.container.preferredZoomedExtent;
        switch (this.container.sliceOrientation) {
            case 100: {
                if (this.xSize < this.zoomedXExtent) {
                    this.zoomedXExtent = this.xSize;
                }
                if (this.ySize < this.zoomedYExtent) {
                    this.zoomedYExtent = this.ySize;
                }
                this.zoomedXMin = 0;
                this.zoomedXMax = this.zoomedXMin + this.zoomedXExtent - 1;
                this.zoomedYMin = this.ySize - this.zoomedYExtent;
                this.zoomedYMax = this.zoomedYMin + this.zoomedYExtent - 1;
                this.zoomOutlineXMin = this.zoomedXMin;
                this.zoomOutlineYMin = this.ySize - this.zoomedYMax - 1;
                break;
            }
            case 200: {
                if (this.xSize < this.zoomedXExtent) {
                    this.zoomedXExtent = this.xSize;
                }
                if (this.zSize < this.zoomedYExtent) {
                    this.zoomedYExtent = this.zSize;
                }
                this.zoomedXMin = 0;
                this.zoomedXMax = this.zoomedXMin + this.zoomedXExtent - 1;
                this.zoomedYMin = this.zSize - this.zoomedYExtent;
                this.zoomedYMax = this.zoomedYMin + this.zoomedYExtent - 1;
                this.zoomOutlineXMin = this.zoomedXMin;
                this.zoomOutlineYMin = this.zSize - this.zoomedYMax - 1;
                break;
            }
            case 300: {
                if (this.ySize < this.zoomedXExtent) {
                    this.zoomedXExtent = this.ySize;
                }
                if (this.zSize < this.zoomedYExtent) {
                    this.zoomedYExtent = this.zSize;
                }
                this.zoomedXMin = 0;
                this.zoomedXMax = this.zoomedXMin + this.zoomedXExtent - 1;
                this.zoomedYMin = this.zSize - this.zoomedYExtent;
                this.zoomedYMax = this.zoomedYMin + this.zoomedYExtent - 1;
                this.zoomOutlineXMin = this.zoomedXMin;
                this.zoomOutlineYMin = this.zSize - this.zoomedYMax - 1;
            }
        }
    }

    private void setBoxCentre(MouseEvent mouseEvent) {
        this.setBoxCentre(mouseEvent.getX(), mouseEvent.getY());
    }

    protected int getXBoxCentre() {
        return this.xBoxCentre;
    }

    protected int getYBoxCentre() {
        return this.yBoxCentre;
    }

    protected void setBoxCentre(int n, int n2) {
        this.xBoxCentre = n;
        this.yBoxCentre = n2;
        this.zoomedXExtent = this.container.preferredZoomedExtent;
        this.zoomedYExtent = this.container.preferredZoomedExtent;
        switch (this.container.sliceOrientation) {
            case 100: {
                if (this.xSize < this.zoomedXExtent) {
                    this.zoomedXExtent = this.xSize;
                }
                if (this.ySize >= this.zoomedYExtent) break;
                this.zoomedYExtent = this.ySize;
                break;
            }
            case 200: {
                if (this.xSize < this.zoomedXExtent) {
                    this.zoomedXExtent = this.xSize;
                }
                if (this.zSize >= this.zoomedYExtent) break;
                this.zoomedYExtent = this.zSize;
                break;
            }
            case 300: {
                if (this.ySize < this.zoomedXExtent) {
                    this.zoomedXExtent = this.ySize;
                }
                if (this.zSize >= this.zoomedYExtent) break;
                this.zoomedYExtent = this.zSize;
            }
        }
        Dimension dimension = this.getSize();
        double d = dimension.getWidth() / (double)this.slice.getWidth();
        double d2 = dimension.getHeight() / (double)this.slice.getHeight();
        if (d < d2) {
            d2 = d;
        } else {
            d = d2;
        }
        int n3 = (int)Math.round((double)n / d);
        int n4 = 0;
        n4 = this.container.sliceOrientation == 100 ? this.ySize - (int)Math.round((double)n2 / d2) - 1 : this.zSize - (int)Math.round((double)n2 / d2) - 1;
        this.zoomedXMin = n3 - this.zoomedXExtent / 2 + 1;
        this.zoomedXMax = n3 + this.zoomedXExtent / 2;
        this.zoomedYMin = n4 - this.zoomedYExtent / 2 + 1;
        this.zoomedYMax = n4 + this.zoomedYExtent / 2;
        switch (this.container.sliceOrientation) {
            case 100: {
                if (this.zoomedXMin < 0) {
                    this.zoomedXMin = 0;
                    this.zoomedXMax = this.zoomedXExtent - 1;
                } else if (this.zoomedXMax >= this.xSize) {
                    this.zoomedXMax = this.xSize - 1;
                    this.zoomedXMin = this.zoomedXMax - this.zoomedXExtent + 1;
                }
                if (this.zoomedYMin < 0) {
                    this.zoomedYMin = 0;
                    this.zoomedYMax = this.zoomedYExtent - 1;
                } else if (this.zoomedYMax >= this.ySize) {
                    this.zoomedYMax = this.ySize - 1;
                    this.zoomedYMin = this.zoomedYMax - this.zoomedYExtent + 1;
                }
                this.zoomOutlineYMin = this.ySize - this.zoomedYMax - 1;
                break;
            }
            case 200: {
                if (this.zoomedXMin < 0) {
                    this.zoomedXMin = 0;
                    this.zoomedXMax = this.zoomedXExtent - 1;
                } else if (this.zoomedXMax >= this.xSize) {
                    this.zoomedXMax = this.xSize - 1;
                    this.zoomedXMin = this.zoomedXMax - this.zoomedXExtent + 1;
                }
                if (this.zoomedYMin < 0) {
                    this.zoomedYMin = 0;
                    this.zoomedYMax = this.zoomedYExtent - 1;
                } else if (this.zoomedYMax >= this.zSize) {
                    this.zoomedYMax = this.zSize - 1;
                    this.zoomedYMin = this.zoomedYMax - this.zoomedYExtent + 1;
                }
                this.zoomOutlineYMin = this.zSize - this.zoomedYMax - 1;
                break;
            }
            case 300: {
                if (this.zoomedXMin < 0) {
                    this.zoomedXMin = 0;
                    this.zoomedXMax = this.zoomedXExtent - 1;
                } else if (this.zoomedXMax >= this.ySize) {
                    this.zoomedXMax = this.ySize - 1;
                    this.zoomedXMin = this.zoomedXMax - this.zoomedXExtent + 1;
                }
                if (this.zoomedYMin < 0) {
                    this.zoomedYMin = 0;
                    this.zoomedYMax = this.zoomedYExtent - 1;
                } else if (this.zoomedYMax >= this.zSize) {
                    this.zoomedYMax = this.zSize - 1;
                    this.zoomedYMin = this.zoomedYMax - this.zoomedYExtent + 1;
                }
                this.zoomOutlineYMin = this.zSize - this.zoomedYMax - 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.container.sliceOrientation);
            }
        }
        this.zoomOutlineXMin = this.zoomedXMin;
        this.repaint();
    }

    protected void recentreBox() {
        this.setBoxCentre(this.xBoxCentre, this.yBoxCentre);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        double d = dimension.getWidth() / (double)this.slice.getWidth();
        double d2 = dimension.getHeight() / (double)this.slice.getHeight();
        if (d < d2) {
            d2 = d;
        } else {
            d = d2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.scale(d, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.drawImage((Image)this.slice, 0, 0, this);
        graphics2D.setColor(Color.yellow);
        graphics2D.drawRect(this.zoomOutlineXMin, this.zoomOutlineYMin, this.zoomedXExtent, this.zoomedYExtent);
    }

    public void setSlice() {
        int n = this.container.currentSliceIndex;
        switch (this.container.sliceOrientation) {
            case 100: {
                this.slice = new BufferedImage(this.xSize, this.ySize, 1);
                for (int i = 0; i < this.xSize; ++i) {
                    for (int j = 0; j < this.ySize; ++j) {
                        this.slice.setRGB(i, this.ySize - j - 1, this.container.image.rgbIndex(i, j, n));
                    }
                }
                break;
            }
            case 200: {
                this.slice = new BufferedImage(this.xSize, this.zSize, 1);
                for (int i = 0; i < this.xSize; ++i) {
                    for (int j = 0; j < this.zSize; ++j) {
                        this.slice.setRGB(i, this.zSize - j - 1, this.container.image.rgbIndex(i, n, j));
                    }
                }
                break;
            }
            case 300: {
                this.slice = new BufferedImage(this.ySize, this.zSize, 1);
                for (int i = 0; i < this.ySize; ++i) {
                    for (int j = 0; j < this.zSize; ++j) {
                        this.slice.setRGB(i, this.zSize - j - 1, this.container.image.rgbIndex(n, i, j));
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.container.sliceOrientation);
            }
        }
        this.repaint();
    }

    public int[] getZoomedRegion() {
        return new int[]{this.zoomedXMin, this.zoomedXMax, this.zoomedYMin, this.zoomedYMax};
    }
}

