/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;

public class MatlabArrayDataSource
implements DataSource {
    protected int xSize;
    protected int ySize;
    protected int zSize;
    protected int components;
    protected double[][][][] data;
    protected int nextX;
    protected int nextY;
    protected int nextZ;

    public MatlabArrayDataSource(double[][][][] dArray) {
        this.data = dArray;
        this.xSize = this.data.length;
        this.ySize = this.data[0].length;
        this.zSize = this.data[0][0].length;
        this.components = this.data[0][0][0].length;
        this.nextX = 0;
        this.nextY = 0;
        this.nextZ = 0;
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        if (!this.more()) {
            throw new DataSourceException("No more voxels.");
        }
        double[] dArray = this.data[this.nextX][this.nextY][this.nextZ];
        ++this.nextX;
        if (this.nextX >= this.xSize) {
            ++this.nextY;
            this.nextX = 0;
            if (this.nextY >= this.ySize) {
                ++this.nextZ;
                this.nextY = 0;
            }
        }
        return dArray;
    }

    @Override
    public boolean more() {
        return this.nextZ < this.zSize;
    }
}

