/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.ExternalDataSource;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import misc.LoggedException;

public class OutputManager {
    private static Logger logger = Logger.getLogger("camino.apps.OutputManager");
    public static final int FILEBUFFERSIZE = 0x1800000;
    private DataOutputStream out = new DataOutputStream(new BufferedOutputStream(System.out, 0x1800000));
    public static String outputDataType = "double";
    public static String outputFile = null;
    public static boolean gzipOut = false;
    private boolean useOutputArray = false;
    private double[][][][] outputArray;
    private int outputArrayX = -1;
    private int outputArrayY = -1;
    private int outputArrayZ = -1;
    private int nextX = 0;
    private int nextY = 0;
    private int nextZ = 0;

    public OutputManager() {
        if (outputFile != null) {
            try {
                if (gzipOut) {
                    this.out = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 0x1800000)));
                }
                this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 0x1800000));
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        } else if (gzipOut) {
            try {
                this.out = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(System.out, 0x1800000)));
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
    }

    public void output(double[] dArray) {
        if (this.useOutputArray) {
            this.addToOutputArray(dArray);
            return;
        }
        int n = 5;
        try {
            n = ExternalDataSource.getDataTypeCode(outputDataType);
        }
        catch (Exception exception) {
            LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            logger.warning("Outputting data as doubles.");
        }
        for (int i = 0; i < dArray.length; ++i) {
            try {
                if (n == 0) {
                    this.out.writeByte((byte)dArray[i]);
                }
                if (n == 6) {
                    int n2 = (int)dArray[i];
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > 255) {
                        n2 = 255;
                    }
                    this.out.writeByte((byte)(n2 & 0xFF));
                    continue;
                }
                if (n == 1) {
                    this.out.writeShort((short)dArray[i]);
                    continue;
                }
                if (n == 7) {
                    int n3 = (int)dArray[i];
                    int n4 = 65534;
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    this.out.writeShort((short)n3);
                    continue;
                }
                if (n == 2) {
                    this.out.writeInt((int)dArray[i]);
                    continue;
                }
                if (n == 8) {
                    long l = (long)dArray[i];
                    long l2 = 0xFFFFFFFFL;
                    if (l > l2) {
                        l = l2;
                    }
                    if (l < 0L) {
                        l = 0L;
                    }
                    this.out.writeInt((int)l);
                    continue;
                }
                if (n == 3) {
                    this.out.writeLong((long)dArray[i]);
                    continue;
                }
                if (n == 4) {
                    this.out.writeFloat((float)dArray[i]);
                    continue;
                }
                this.out.writeDouble(dArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
    }

    public DataOutputStream getOutputStream() {
        return this.out;
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                LoggedException.logExceptionWarning(iOException, Thread.currentThread().getName());
            }
        }
    }

    public void setOutputArray(int n, int n2, int n3) {
        this.useOutputArray = true;
        this.outputArrayX = n;
        this.outputArrayY = n2;
        this.outputArrayZ = n3;
        this.outputArray = new double[this.outputArrayX][this.outputArrayY][this.outputArrayZ][0];
        this.nextX = 0;
        this.nextY = 0;
        this.nextZ = 0;
    }

    private void addToOutputArray(double[] dArray) {
        if (this.nextZ >= this.outputArrayZ) {
            throw new LoggedException("Output array exhausted.");
        }
        this.outputArray[this.nextX][this.nextY][this.nextZ] = dArray;
        ++this.nextX;
        if (this.nextX == this.outputArrayX) {
            ++this.nextY;
            this.nextX = 0;
        }
        if (this.nextY == this.outputArrayY) {
            ++this.nextZ;
            this.nextY = 0;
        }
    }

    public double[][][][] getOutputArray() {
        return this.outputArray;
    }
}

