/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSourceException;
import data.ExternalDataSource;
import java.io.IOException;
import misc.LoggedException;
import tools.EndianNeutralDataInputStream;

public class VoxelOrderDataSource
extends ExternalDataSource {
    protected double[] next;
    private boolean reachedEndOfFile;
    private boolean noMoreVoxels;

    protected VoxelOrderDataSource() {
    }

    public VoxelOrderDataSource(String string, int n, String string2) {
        this.initFileInput(string, false, 0);
        this.init(n, string2);
    }

    public VoxelOrderDataSource(String string, int n, String string2, boolean bl) {
        this.initFileInput(string, bl, 0);
        this.init(n, string2);
    }

    public VoxelOrderDataSource(String string, int n, String string2, boolean bl, int n2) {
        this.initFileInput(string, bl, n2);
        this.init(n, string2);
    }

    public VoxelOrderDataSource(EndianNeutralDataInputStream endianNeutralDataInputStream, int n, String string) {
        this.dataIn = endianNeutralDataInputStream;
        this.init(n, string);
    }

    protected void init(int n, String string) {
        this.numComponents = n;
        this.next = new double[this.numComponents];
        try {
            this.datatype = VoxelOrderDataSource.getDataTypeCode(string);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.reachedEndOfFile = false;
        this.noMoreVoxels = false;
        try {
            this.readNextVoxel();
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        double[] dArray = this.retrieveCurrentVoxelData();
        this.readNextVoxel();
        if (this.reachedEndOfFile) {
            this.noMoreVoxels = true;
        }
        return dArray;
    }

    @Override
    public boolean more() {
        return !this.noMoreVoxels;
    }

    protected double[] retrieveCurrentVoxelData() {
        double[] dArray = new double[this.numComponents];
        for (int i = 0; i < this.numComponents; ++i) {
            dArray[i] = this.next[i];
        }
        return dArray;
    }

    private void readNextVoxel() throws DataSourceException {
        if (this.reachedEndOfFile) {
            this.noMoreVoxels = true;
            throw new DataSourceException("No more voxels in data source.");
        }
        int n = 0;
        for (int i = 0; i < this.numComponents; ++i) {
            try {
                n = i;
                if (this.datatype == 0) {
                    this.next[i] = this.dataIn.readByte();
                    continue;
                }
                if (this.datatype == 6) {
                    this.next[i] = this.dataIn.readUnsignedByte();
                    continue;
                }
                if (this.datatype == 1) {
                    this.next[i] = this.dataIn.readShort();
                    continue;
                }
                if (this.datatype == 7) {
                    this.next[i] = this.dataIn.readUnsignedShort();
                    continue;
                }
                if (this.datatype == 2) {
                    this.next[i] = this.dataIn.readInt();
                    continue;
                }
                if (this.datatype == 8) {
                    this.next[i] = this.dataIn.readUnsignedInt();
                    continue;
                }
                if (this.datatype == 3) {
                    this.next[i] = this.dataIn.readLong();
                    continue;
                }
                if (this.datatype == 4) {
                    this.next[i] = this.dataIn.readFloat();
                    continue;
                }
                if (this.datatype != 5) continue;
                this.next[i] = this.dataIn.readDouble();
                continue;
            }
            catch (IOException iOException) {
                this.reachedEndOfFile = true;
                if (n > 0) {
                    this.noMoreVoxels = true;
                    throw new DataSourceException("End of file reached without completing voxel.");
                }
                try {
                    this.dataIn.close();
                }
                catch (Exception exception) {
                    System.err.println("Failed to close the data input stream in VoxelOrderDataSource. Trying to continue...");
                }
                return;
            }
        }
    }
}

