/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.BallCylinderLM_Fitter;
import fitters.BallCylinderMultiRunLM_Fitter;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class BallGDRCylindersLM_Fitter
extends CompartmentFitter {
    protected BallCylinderLM_Fitter bcfitter;
    private final int numModelParams = 9;
    private final int numOptParams = 7;

    public BallGDRCylindersLM_Fitter() {
    }

    public BallGDRCylindersLM_Fitter(DW_Scheme dW_Scheme) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("gammadistribradiicylinders"), new String("ball")};
        double[] dArray = new double[]{1.0, 0.7, 0.3, 1.0, 1.0, 1.7E-9, 1.5, 1.5, 1.7E-9};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.bcfitter = new BallCylinderMultiRunLM_Fitter(dW_Scheme, 3, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[]{Math.sqrt(dArray[0]), Math.acos(Math.sqrt(dArray[1])), Math.acos(Math.sqrt(dArray[3] / 20.0)), Math.acos(Math.sqrt((dArray[4] - 1.0E-7) / 2.0E-5)), Math.sqrt(dArray[5]), dArray[6], dArray[7]};
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double[] dArray2 = new double[9];
                dArray2[0] = dArray[0] * dArray[0];
                double d = Math.cos(dArray[1]);
                d *= d;
                dArray2[1] = d;
                dArray2[2] = 1.0 - d;
                dArray2[3] = Math.cos(dArray[2]);
                dArray2[3] = dArray2[3] * dArray2[3] * 20.0;
                dArray2[4] = 1.0E-7 + Math.cos(dArray[3]) * Math.cos(dArray[3]) * 2.0E-5;
                dArray2[5] = dArray[4] * dArray[4];
                dArray2[6] = dArray[5];
                dArray2[7] = dArray[6];
                dArray2[8] = dArray2[5];
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 7;
            }

            @Override
            public int getNumModelParams() {
                return 9;
            }

            @Override
            public int getDirectionIndex() {
                return 6;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray2 = MultiRunMinimizer.getBestSolution(this.bcfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.bcfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray2[1];
        double d2 = dArray2[5];
        double d3 = dArray2[6];
        double d4 = dArray2[2];
        double d5 = dArray2[4];
        double d6 = 1.8;
        double d7 = dArray2[7];
        double[] dArray3 = new double[9];
        dArray3[0] = d;
        dArray3[1] = d4;
        dArray3[1] = dArray3[1] < 0.1 ? 0.1 : dArray3[1];
        dArray3[1] = dArray3[1] > 0.9 ? 0.9 : dArray3[1];
        dArray3[2] = 1.0 - dArray3[1];
        dArray3[3] = d6;
        dArray3[4] = d7;
        dArray3[5] = d5;
        dArray3[6] = d2;
        dArray3[7] = d3;
        dArray3[8] = d5;
        return dArray3;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        BallGDRCylindersLM_Fitter ballGDRCylindersLM_Fitter = new BallGDRCylindersLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = ballGDRCylindersLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

