/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import data.OutputManager;
import fitters.BallCylinderLM_Fitter;
import fitters.BallCylinderMultiRunLM_Fitter;
import fitters.Codec;
import fitters.CompartmentFitter;
import fitters.NoiseModel;
import imaging.DW_Scheme;
import misc.LoggedException;
import models.compartments.CompartmentModel;
import optimizers.LM_Minimizer;
import optimizers.MinimizerException;
import optimizers.MultiRunMinimizer;
import tools.CL_Initializer;

public class BallGDRCylindersSphereLM_Fitter
extends CompartmentFitter {
    protected BallCylinderLM_Fitter bcfitter;
    private final int numModelParams = 12;
    private final int numOptParams = 9;

    public BallGDRCylindersSphereLM_Fitter() {
    }

    public BallGDRCylindersSphereLM_Fitter(DW_Scheme dW_Scheme) {
        this.scheme = dW_Scheme;
        this.makeCodec();
        String[] stringArray = new String[]{new String("gammadistribradiicylinders"), new String("ball"), new String("spheregpd")};
        double[] dArray = new double[]{1.0, 0.6, 0.3, 0.1, 1.0, 1.0, 1.7E-9, 1.5, 1.5, 1.7E-9, 1.7E-9, 1.7E-6};
        this.cm = new CompartmentModel(stringArray, dArray);
        try {
            this.initLM_Minimizer(NoiseModel.getNoiseModel(CL_Initializer.noiseModel));
            LM_Minimizer cfr_ignored_0 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setCONVERGETHRESH(1.0E-8);
            LM_Minimizer cfr_ignored_1 = (LM_Minimizer)this.minimizer;
            LM_Minimizer.setMAXITER(5000);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.bcfitter = new BallCylinderMultiRunLM_Fitter(dW_Scheme, 1, 0);
    }

    protected void makeCodec() {
        this.cod = new Codec(){

            @Override
            public double[] modelToOpt(double[] dArray) {
                double[] dArray2 = new double[9];
                dArray2[0] = Math.sqrt(dArray[0]);
                dArray2[1] = Math.acos(Math.sqrt(dArray[1]));
                dArray2[2] = Math.acos(Math.sqrt(dArray[2] / (1.0 - dArray[1])));
                dArray2[3] = Math.acos(Math.sqrt(dArray[4] / 20.0));
                dArray2[4] = Math.acos(Math.sqrt((dArray[5] - 1.0E-7) / 2.0E-5));
                dArray2[5] = Math.sqrt(dArray[6]);
                dArray2[6] = dArray[7];
                dArray2[7] = dArray[8];
                if (dArray2[7] < 1.0E-5) {
                    dArray2[7] = dArray2[7] - Math.PI;
                }
                dArray2[8] = Math.acos(Math.sqrt((dArray[11] - 1.0E-7) / 4.0E-5));
                return dArray2;
            }

            @Override
            public double[] optToModel(double[] dArray) {
                double d;
                double[] dArray2 = new double[12];
                dArray2[0] = dArray[0] * dArray[0];
                double d2 = Math.cos(dArray[1]);
                d2 *= d2;
                dArray2[1] = d2;
                dArray2[2] = d = Math.cos(dArray[2]) * Math.cos(dArray[2]) * (1.0 - d2);
                dArray2[3] = 1.0 - d2 - d;
                dArray2[4] = Math.cos(dArray[3]);
                dArray2[4] = dArray2[4] * dArray2[4] * 20.0;
                dArray2[5] = 1.0E-7 + Math.cos(dArray[4]) * Math.cos(dArray[4]) * 2.0E-5;
                dArray2[6] = dArray[5] * dArray[5];
                dArray2[7] = dArray[6];
                dArray2[8] = dArray[7];
                dArray2[9] = dArray2[6];
                dArray2[10] = dArray2[6];
                dArray2[11] = 1.0E-7 + Math.cos(dArray[8]) * Math.cos(dArray[8]) * 4.0E-5;
                return dArray2;
            }

            @Override
            public int getNumOptParams() {
                return 9;
            }

            @Override
            public int getNumModelParams() {
                return 12;
            }

            @Override
            public int getDirectionIndex() {
                return 7;
            }
        };
    }

    @Override
    protected double[] getStartPoint(double[] dArray) {
        double[] dArray2;
        if (this.getFixedStartPoint(dArray) != null) {
            return this.getFixedStartPoint(dArray);
        }
        try {
            dArray2 = MultiRunMinimizer.getBestSolution(this.bcfitter.fit(dArray));
        }
        catch (MinimizerException minimizerException) {
            dArray2 = this.bcfitter.getStartPoint(dArray);
            minimizerException.printStackTrace();
        }
        double d = dArray2[1];
        double d2 = dArray2[5];
        double d3 = dArray2[6];
        double d4 = dArray2[2] - 5.0E-5;
        double d5 = dArray2[3] - 5.0E-5;
        double d6 = 1.0E-4;
        double d7 = dArray2[4];
        double d8 = 1.8;
        double d9 = dArray2[7];
        double d10 = 2.0E-6;
        double[] dArray3 = new double[]{d, d4, d5, d6, d8, d9, d7, d2, d3, d7, d7, d10};
        return dArray3;
    }

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        OutputManager outputManager = new OutputManager();
        BallGDRCylindersSphereLM_Fitter ballGDRCylindersSphereLM_Fitter = new BallGDRCylindersSphereLM_Fitter(CL_Initializer.imPars);
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                double[][] dArray2 = ballGDRCylindersSphereLM_Fitter.fit(dArray);
                outputManager.output(dArray2[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        outputManager.close();
    }
}

