/*
 * Decompiled with CFR 0.152.
 */
package fitters;

import misc.LoggedException;
import models.compartments.CompartmentType;

public enum FitModel {
    BALLSTICK,
    BALLCYLINDER,
    ZEPPELINSTICK,
    ZEPPELINCYLINDER,
    TENSORSTICK,
    TENSORCYLINDER,
    BALLSTICKDOT,
    BALLSTICKASTROSTICKS,
    BALLSTICKASTROCYLINDERS,
    ZEPPELINSTICKDOT,
    ZEPPELINSTICKASTROSTICKS,
    ZEPPELINSTICKASTROCYLINDERS,
    TENSORSTICKDOT,
    TENSORSTICKASTROSTICKS,
    TENSORSTICKASTROCYLINDERS,
    BALLCYLINDERDOT,
    ZEPPELINCYLINDERDOT,
    TENSORCYLINDERDOT,
    ZEPPELINCYLINDERASTROSTICKS,
    TENSORCYLINDERASTROSTICKS,
    BALLCYLINDERASTROSTICKS,
    BALLCYLINDERASTROCYLINDERS,
    ZEPPELINCYLINDERASTROCYLINDERS,
    TENSORCYLINDERASTROCYLINDERS,
    BALLGDRCYLINDERS,
    BIZEPPELIN,
    ZEPPELINGDRCYLINDERS,
    TENSORGDRCYLINDERS,
    BALLGDRCYLINDERSDOT,
    ZEPPELINGDRCYLINDERSDOT,
    TENSORGDRCYLINDERSDOT,
    BALLGDRCYLINDERSASTROSTICKS,
    BALLGDRCYLINDERSASTROCYLINDERS,
    ZEPPELINGDRCYLINDERSASTROSTICKS,
    ZEPPELINGDRCYLINDERSASTROCYLINDERS,
    TENSORGDRCYLINDERSASTROSTICKS,
    TENSORGDRCYLINDERSASTROCYLINDERS,
    BALLSTICKSPHERE,
    ZEPPELINSTICKSPHERE,
    TENSORSTICKSPHERE,
    BALLCYLINDERSPHERE,
    ZEPPELINCYLINDERSPHERE,
    TENSORCYLINDERSPHERE,
    BALLGDRCYLINDERSSPHERE,
    ZEPPELINGDRCYLINDERSSPHERE,
    TENSORGDRCYLINDERSSPHERE,
    ZEPPELINSTICKDIRECT,
    ZEPPELINSTICKTORT,
    ZEPPELINCYLINDERDIRECT,
    ZEPPELINCYLINDERTORT,
    ZEPPELINCYLINDERDOTDIRECT,
    ZEPPELINCYLINDERDOTCSFDIRECT,
    MMWMDBASIC,
    MMWMDINVIVO,
    MMWMDFIXED;


    public static final String[] getCompartmentList(String string) {
        FitModel fitModel = FitModel.getFitModel(string);
        if (fitModel == BALLSTICK) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.BALL.toString()};
        }
        if (fitModel == BALLCYLINDER) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.BALL.toString()};
        }
        if (fitModel == BIZEPPELIN) {
            return new String[]{CompartmentType.ZEPPELIN.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == ZEPPELINSTICK) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == ZEPPELINSTICKDIRECT) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == ZEPPELINSTICKTORT) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == ZEPPELINCYLINDER) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERDIRECT) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERTORT) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == TENSORSTICK) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.TENSOR.toString()};
        }
        if (fitModel == TENSORCYLINDER) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.TENSOR.toString()};
        }
        if (fitModel == BALLSTICKDOT) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.BALL.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == BALLSTICKASTROSTICKS) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.BALL.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == BALLSTICKASTROCYLINDERS) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.BALL.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == BALLSTICKSPHERE) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.BALL.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == ZEPPELINSTICKDOT) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == ZEPPELINSTICKASTROSTICKS) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == ZEPPELINSTICKASTROCYLINDERS) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == TENSORSTICKDOT) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.TENSOR.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == TENSORSTICKSPHERE) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.TENSOR.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == TENSORSTICKASTROSTICKS) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.TENSOR.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == TENSORSTICKASTROCYLINDERS) {
            return new String[]{CompartmentType.STICK.toString(), CompartmentType.TENSOR.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == BALLCYLINDERDOT) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.BALL.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == BALLCYLINDERSPHERE) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.BALL.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERDOT) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERDOTDIRECT) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERDOTCSFDIRECT) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.DOT.toString(), CompartmentType.BALL.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERSPHERE) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == TENSORCYLINDERDOT) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.TENSOR.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == TENSORCYLINDERSPHERE) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.TENSOR.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == BALLCYLINDERASTROSTICKS) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.BALL.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERASTROSTICKS) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == TENSORCYLINDERASTROSTICKS) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.TENSOR.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == TENSORCYLINDERASTROCYLINDERS) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.TENSOR.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == BALLCYLINDERASTROCYLINDERS) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.BALL.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == ZEPPELINCYLINDERASTROCYLINDERS) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == BALLGDRCYLINDERS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.BALL.toString()};
        }
        if (fitModel == BALLGDRCYLINDERSASTROSTICKS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.BALL.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == BALLGDRCYLINDERSSPHERE) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.BALL.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == BALLGDRCYLINDERSASTROCYLINDERS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.BALL.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == BALLGDRCYLINDERSDOT) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.BALL.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSASTROSTICKS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSSPHERE) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSASTROCYLINDERS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == TENSORGDRCYLINDERSASTROSTICKS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.TENSOR.toString(), CompartmentType.ASTROSTICKS.toString()};
        }
        if (fitModel == TENSORGDRCYLINDERSSPHERE) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.TENSOR.toString(), CompartmentType.SPHEREGPD.toString()};
        }
        if (fitModel == TENSORGDRCYLINDERSASTROCYLINDERS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.TENSOR.toString(), CompartmentType.ASTROCYLINDERS.toString()};
        }
        if (fitModel == ZEPPELINGDRCYLINDERS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSDOT) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == TENSORGDRCYLINDERS) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.TENSOR.toString()};
        }
        if (fitModel == TENSORGDRCYLINDERSDOT) {
            return new String[]{CompartmentType.GAMMADISTRIBRADIICYLINDERS.toString(), CompartmentType.TENSOR.toString(), CompartmentType.DOT.toString()};
        }
        if (fitModel == MMWMDBASIC) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString()};
        }
        if (fitModel == MMWMDINVIVO) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.BALL.toString()};
        }
        if (fitModel == MMWMDFIXED) {
            return new String[]{CompartmentType.CYLINDERGPD.toString(), CompartmentType.ZEPPELIN.toString(), CompartmentType.DOT.toString(), CompartmentType.BALL.toString()};
        }
        throw new LoggedException("Unknown fitting model " + (Object)((Object)fitModel));
    }

    public static final double[] getCompartmentModelParams(String string) {
        FitModel fitModel = FitModel.getFitModel(string);
        if (fitModel == BALLSTICK) {
            return new double[]{2.0, 0.5, 0.5, 1.0, 0.0, 1.0, 1.0};
        }
        if (fitModel == BALLCYLINDER) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0};
        }
        if (fitModel == ZEPPELINSTICK) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5};
        }
        if (fitModel == ZEPPELINSTICKDIRECT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5};
        }
        if (fitModel == ZEPPELINSTICKTORT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5};
        }
        if (fitModel == ZEPPELINCYLINDER) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0};
        }
        if (fitModel == ZEPPELINCYLINDERDIRECT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0};
        }
        if (fitModel == ZEPPELINCYLINDERTORT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0};
        }
        if (fitModel == TENSORSTICK) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.0};
        }
        if (fitModel == TENSORCYLINDER) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5, 0.0};
        }
        if (fitModel == BALLSTICKDOT) {
            return new double[]{2.0, 0.5, 0.5, 1.0, 0.0, 1.0, 1.0, 0.5};
        }
        if (fitModel == BALLSTICKASTROSTICKS) {
            return new double[]{2.0, 0.5, 0.5, 1.0, 0.0, 1.0, 1.0, 0.5, 0.5};
        }
        if (fitModel == BALLSTICKASTROCYLINDERS) {
            return new double[]{2.0, 0.5, 0.5, 1.0, 0.0, 1.0, 1.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == BALLSTICKSPHERE) {
            return new double[]{2.0, 0.5, 0.5, 1.0, 0.0, 1.0, 1.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == ZEPPELINSTICKDOT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5};
        }
        if (fitModel == ZEPPELINSTICKASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5};
        }
        if (fitModel == ZEPPELINSTICKASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == ZEPPELINSTICKSPHERE) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == TENSORSTICKDOT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 1.0, 1.0};
        }
        if (fitModel == BALLCYLINDERDOT) {
            return new double[]{1.0, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0};
        }
        if (fitModel == ZEPPELINCYLINDERDOT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5};
        }
        if (fitModel == ZEPPELINCYLINDERDOTDIRECT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5};
        }
        if (fitModel == ZEPPELINCYLINDERDOTCSFDIRECT) {
            return new double[]{1.0, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5};
        }
        if (fitModel == TENSORCYLINDERDOT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == BALLCYLINDERASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }
        if (fitModel == BALLCYLINDERASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.5};
        }
        if (fitModel == ZEPPELINCYLINDERASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == ZEPPELINCYLINDERSPHERE) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5, 0.5, 0.5};
        }
        if (fitModel == TENSORSTICKASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5};
        }
        if (fitModel == TENSORSTICKASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == TENSORSTICKSPHERE) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5, 0.5};
        }
        if (fitModel == TENSORCYLINDERASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5, 0.5, 0.5};
        }
        if (fitModel == TENSORCYLINDERASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5, 0.5, 0.5, 0.5};
        }
        if (fitModel == TENSORCYLINDERSPHERE) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5};
        }
        if (fitModel == ZEPPELINCYLINDERASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5, 0.5};
        }
        if (fitModel == MMWMDBASIC) {
            return new double[]{1.0, 0.5, 0.25, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0};
        }
        if (fitModel == MMWMDINVIVO) {
            return new double[]{1.0, 0.5, 0.25, 0.25, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }
        if (fitModel == MMWMDFIXED) {
            return new double[]{1.0, 0.5, 0.25, 0.25, 0.25, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }
        if (fitModel == BALLGDRCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        }
        if (fitModel == BALLGDRCYLINDERSASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        }
        if (fitModel == BALLGDRCYLINDERSASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        }
        if (fitModel == BALLGDRCYLINDERSSPHERE) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSSPHERE) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.5};
        }
        if (fitModel == TENSORGDRCYLINDERSASTROSTICKS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        }
        if (fitModel == TENSORGDRCYLINDERSASTROCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        }
        if (fitModel == BALLGDRCYLINDERSDOT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0};
        }
        if (fitModel == BIZEPPELIN) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0};
        }
        if (fitModel == ZEPPELINGDRCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0};
        }
        if (fitModel == ZEPPELINGDRCYLINDERSDOT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0};
        }
        if (fitModel == TENSORGDRCYLINDERS) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        }
        if (fitModel == TENSORGDRCYLINDERSDOT) {
            return new double[]{1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        }
        throw new LoggedException("Unknown fitting model " + (Object)((Object)fitModel));
    }

    public static final FitModel getFitModel(String string) {
        for (FitModel fitModel : FitModel.values()) {
            if (!fitModel.toString().equalsIgnoreCase(string)) continue;
            return fitModel;
        }
        throw new LoggedException("unrecognised fit model name " + string);
    }
}

